/* ***************************************************************************************
 * FILE:          clReceiverThread.h
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  clReceiverThread.h is part of NanoMsg_MasterApplication
 * 				 This class is a thread class runs for receiving msg's from CIS
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  12.02.2020
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CLRECEIVERTHREAD_HEADER
#define CLRECEIVERTHREAD_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "clNanoMsgCoreThread.h"
#include "clMsgIDMapping.h"
#include "clMsgIDMapping.h"
#include "IBackendInterface.h"

#include <iostream>

class clReceiverThread : public clNanoMsgCoreThread
{

public:
	static clReceiverThread* getInstance();
	static void vDeleteInstance();
	virtual ~clReceiverThread();
	bool _nanoMsgCallBack(std::shared_ptr<stNanoMsgData> data);

private:
	clReceiverThread();
	static clReceiverThread* m_poSelf;

	clMsgIDMapping *IDMappingInstance;
//	IBackendInterface *IBackendInstance;
};
#endif // !defined(CLRECEIVERTHREAD_HEADER)
