/* ***************************************************************************************
 * FILE:          clReceiverThread.cpp
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  clReceiverThread.cpp is part of NanoMsg_MasterApplication
 * 				 This class is a thread class runs for receiving msg's from CIS
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  12.02.2020
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */


/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "clReceiverThread.h"
#include "plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_NANOMSGMASTERCMPCORE
#include "trcGenProj/Header/clReceiverThread.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

clReceiverThread* clReceiverThread::m_poSelf = NULL;
/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION:   Static Function, Singleton implementation, return the ptr of the
*				Singleton class clReceiverThread
*PARAMETER:		None
*RETURNVALUE: 	clReceiverThread*
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
clReceiverThread* clReceiverThread::getInstance()
{
   if (NULL == m_poSelf)
   {
      m_poSelf = new clReceiverThread();
   }
    return m_poSelf;
}


/************************************************************************
*FUNCTION: 		vDeleteInstance()
*DESCRIPTION:   Static Function, Singleton implementation, Deletes the Singleton Object 
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Supriya Seshadri(RBEI/ECG5)   Initial version
*************************************************************************/
void clReceiverThread::vDeleteInstance()
{
   if (NULL != m_poSelf)
   {
	   ETG_TRACE_USR4(("clReceiverThread::vDeleteInstance(), deleting the obj"));
		delete m_poSelf;
		m_poSelf = NULL;
   }
}

/************************************************************************
*FUNCTION: 		clReceiverThread()
*DESCRIPTION:   Constructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
clReceiverThread::clReceiverThread(){
	IDMappingInstance = clMsgIDMapping::getInstance();
}

/************************************************************************
*FUNCTION: 		~clReceiverThread()
*DESCRIPTION:   Destructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
clReceiverThread::~clReceiverThread(){
clMsgIDMapping::vDeleteInstance();
}

/************************************************************************
*FUNCTION: 		_nanoMsgCallBack()
*DESCRIPTION:   Thread call back function will be called by parent class 
*				when msg is added to queue to send data to clients
*PARAMETER:		std::shared_ptr<stNanoMsgData>
*RETURNVALUE: 	Bool
*History:		Shiva Kumar J(RBEI/ECH2)   Initial version
*************************************************************************/
bool clReceiverThread::_nanoMsgCallBack( std::shared_ptr<stNanoMsgData> data )
{
	if(data != NULL)
	{
    	if (NULL != IDMappingInstance)
		{
			//get the Service Instance 
			IBackendInterface *IBackendInstance = IDMappingInstance->getInstanceForMsgID(data->MsgID);
			if (NULL != IBackendInstance)
			{
				//get the callback function pointer
				FUNCPTR func = IDMappingInstance->getFunctionPtr(data->MsgID);
				//Do the function Callback
				if (NULL != func)
				{
				  (IBackendInstance->*func)(data.get());
				}
				else
				{
				  ETG_TRACE_USR4(("clReceiverThread::FUNCPTR return NULL from IDMappingInstance"));
				  return false;
				}
			}
			else
			{
			  ETG_TRACE_USR4(("clReceiverThread::IBackendInstance return NULL from IDMappingInstance"));
			  return false;
			}
		}
		else
		{
		  ETG_TRACE_USR4(("clReceiverThread::IDMappingInstance return NULL "));
		  return false;
		}
	}
	else
	{
		ETG_TRACE_USR4(("clReceiverThread::Received data us NULL "));
		return false;
	}
	return true;
} 