/* ***************************************************************************************
 * FILE:          clNanoMsgCoreThread.h
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  clNanoMsgCoreThread.h is part of NanoMsg_MasterApplication
 * 				 This is thread base class with queue and wait logic, class that 
 *				 inherits from this would have to implement _nanoMsgCallBack(std::shared_ptr<stNanoMsgData> data)
 *				 function to get a msg update. 
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  29.01.2020
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CL_NANO_MSG_CORE_THREAD_HEADER
#define CL_NANO_MSG_CORE_THREAD_HEADER

#include "includes.h"
#include "Constants.h"

typedef void * (*THREADFUNCPTR)(void *);
void msSleep( unsigned int mseconds);


class clNanoMsgCoreThread
{
private:
	// Private member variable declarations

	bool		  m_thRunStatus;
	pthread_t     m_thHandle;
	LONG	      m_threadID;
	vector<std::shared_ptr<stNanoMsgData> >    *m_thNanoMsgQueue;

	std::shared_ptr<stNanoMsgData>       m_thNanoMsgCurrentContainer;
	enum_ThreadSM_en  m_thCurrentState;
	LONG          m_thStatusTime;
	LONG		  m_thStackSize;
	bool		  addNanoMsgToQueue(std::shared_ptr<stNanoMsgData> s);
	bool		  getNanoMsgFromQueue();
	bool		  isQueueEmpty();
	int           m_thStopTimer;

public:

	//Constructor and destructor
	clNanoMsgCoreThread(void);
	virtual ~clNanoMsgCoreThread(void);

	//Thread create Call back and routine
	virtual bool _nanoMsgCallBack(std::shared_ptr<stNanoMsgData> data) = 0;
	VOIDPTR thStartRoutine(VOIDPTR NanoPacket);

	//Public methods declarations
	bool		processNanoMsg();
	bool		setNanoMsgEvent(stNanoMsgData data);
	bool		pThreadStop(); //Stop Thread
	bool		pThreadStart(); // Start Thread
	//bool		checkThreadRunStatus(LONG timeout=0); // to be introduced on need basis

	//Setters and getters section
	enum_ThreadSM_en getThreadState(){ return m_thCurrentState; }
	void setThreadState(enum_ThreadSM_en thState){	m_thCurrentState = thState; 	}
	void setThreadRunStatus(bool status){ m_thRunStatus = status;}
	bool getThreadRunStatus() {return m_thRunStatus;}
	// Declaration of thread condition variable
	pthread_cond_t m_thWaitCond;
	// declaring mutex
	pthread_mutex_t m_thMutexLock;
};
#endif

