/* ***************************************************************************************
 * FILE:          clMsgIDMapping.h
 * SW-COMPONENT:  NanoMsg_Master_Application
 * DESCRIPTION:  clMsgIDMapping.h is part of NanoMsg_MasterApplication
 * 				 This class would have msgid mapping table mapped to function pointers
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  12.02.2020
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CL_MSG_ID_MAPPING_HEADER
#define CL_MSG_ID_MAPPING_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define LCM_START_MSG_ID 0x0001;
#define LCM_END_MSG_ID 0x00FF;

#define INTERCOM_START_MSG_ID 0x0100;
#define INTERCOM_END_MSG_ID 0x01FF;

typedef enum {
	enmMsgType_None,
	enmMsgType_Request_LCM,
	enmMsgType_Request_INTERCOM,
	enmMsgType_Request_GENERIC,
	enmMsgType_Response_LCM,
	enmMsgType_Response_INTERCOM,
	enmMsgType_Response_GENERIC,
	enmMsgType_Event_LCM,
	enmMsgType_Event_INTERCOM,
	enmMsgType_Event_GENERIC,
	enmMsgType_Blocked
} enumm_MsgType_en;

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "Constants.h"
#include "IBackendInterface.h"
#include<map>

typedef void (IBackendInterface::*FUNCPTR)(stNanoMsgData *);
typedef std::map<int, FUNCPTR> FuncMap;

class clMsgIDMapping
{

private:

	FuncMap m_mapingTable;
	enumm_MsgType_en m_MsgType;
	std::map<int, enumm_MsgType_en> m_sMap;
	std::map<uint16_t, uint16_t> m_ReqRspMap;
	static clMsgIDMapping *m_poSelf;

	clMsgIDMapping();

public:

	static clMsgIDMapping* getInstance();
	static void vDeleteInstance();
	void setSMap();
	void setReqRspMap();
	virtual ~clMsgIDMapping();

	void setCallback(int MSGID, FUNCPTR funcptr);

	IBackendInterface* getInstanceForMsgID(int MsgID);

	FUNCPTR getFunctionPtr(int MsgID);
	
	bool bcheckforEvent(int MSGID);
	
	uint16_t u16GetRspMsgID(uint16_t MsgID);


};
#endif // !defined(CL_MSG_ID_MAPPING_HEADER)
