/*
 * Copyright (c) 2010 Gracenote, Inc. All rights reserved.
 *
 * This software may not be used in any way or distributed without
 * Gracenote's written permission. 
 *
 * One or more patents owned by Gracenote apply to this software.
 */

/*
 * xsampa_to_lnh_conversion.h
 *
 * Is the heart of the conversion and it demonstrates the X-SAMPA 
 * to L&H+ conversion as well as the L&H+ language specific 
 * post-processing.  It will output the conversion data to the 
 * valid or invalid output file depending on its success.
 */

#ifndef _XSAMPA_TO_LNH_CONVERSION_H_
#define _XSAMPA_TO_LNH_CONVERSION_H_

/* Error-Code Headers */
#include "gnex_errors.h"

#ifdef __cplusplus
extern "C"{
#endif 

/* xsampa_to_lnh_conversion
 *
 * Converts the xsampa transcription to lnh and returns the output.
 *
 * Memory is allocated by this call. The gnepal_smart_free function
 * should be called once the output strings are no longer needed.
 *
 * Parameters:
 *  IN		: lang					: language identifier
 *  IN		: xsampa				: X-SAMPA transcription.
 *  OUT		: lnh_conversion		: L&H+ transcription.
 *  OUT		: lnh_final_conversion	: Final L&H+ transcription.
 *
 * Return Values:
 *  On success:
 *   gnex_error_t				: GNEX_PHOCVRT_NoError
 *   lnh_conversion				: L&H+ transcription before post processing.
 *   lnh_final_conversion		: Final L&H+ transcription after post processing.
 *
 *	On error:
 *   gnex_error_t				: Gracenote Extension Error Value
 *   lnh_conversion				: Will not have been modified.
 *   lnh_final_conversion		: Will not have been modified.
 */
gnex_error_t xsampa_to_lnh_conversion(
    const gn_uchar_t* lang,				/* language identifier */
    const gn_uchar_t* xsampa,			/* X-SAMPA transcription */
    gn_uchar_t** lnh_conversion,		/* lnh converted transcription */
    gn_uchar_t** lnh_final_conversion	/* lnh final converted transcription */
    );

#ifdef __cplusplus
};
#endif 

#endif
