/// \file GracenoteLanguageId.h
///
/// This provides helper classes to convert sds_fi_lang language codes to
/// Gracenote spoken language identifieres and back
///
/// Copyright: (c) 2011 Robert Bosch GmbH
///
/// \author Ingo Reise CM-AI/PJ-GM28 (external.ingo.reise@de.bosch.com)
///
/// \version 05.04.2011 Initial version
#ifndef GRACENOTELANGUAGEID_H_
#define GRACENOTELANGUAGEID_H_

#include "GracenoteLanguageCode.h"
#include "GracenoteCountryCode.h"

/// \brief A combination of language and country codes
/// \details Using tclLanguageCode and tclCountryCode this class supports
/// <UL>
/// <LI> Gracenote spoken language specifiers like "USA_eng"
/// <LI> Alpha-codes from ISO 3166/639 like "en", "USA"
/// <LI> Numeric codes from sds_fi_tcl_e16_* classes
/// </UL>
class tclLanguageId {
    char GNCodeArray[8];

    /// tclLanguageCode
    tclLanguageCode language;
    /// tclCountryCode
    tclCountryCode country;
    
    // set Gracenote spoken language identifier
    void updateGNCode(void) ;
    
    void initISO639HelperStruct(void);

public:
    // Constructor specifying both codes directly
    tclLanguageId(tclLanguageCode LC, tclCountryCode CC);
    
    // Default constructor initializing to 0, this should be a not existing
    // language
    tclLanguageId();
    
    // Constructor specifying a spoken language identifier from Gracenote
    tclLanguageId(char *gnId);

    // get Gracenote spoken language identifier
    operator unsigned char * const() const;
    

    // Less operator
    bool operator<(const tclLanguageId &li2) const;

    // Equality operator
    bool operator==(const tclLanguageId &li2) const;
};

#endif /*GRACENOTELANGUAGEID_H_*/
