/// \file GracenoteIsoCodeAsShort.cpp
///
/// This provides base class to handle numeric (short) representations of ISO codes
/// for languages and countries
///
/// Copyright: (c) 2011 Robert Bosch GmbH
///
/// \author Ingo Reise CM-AI/PJ-GM28 (external.ingo.reise@de.bosch.com)
///
/// \version 05.04.2011 Initial version
///
#include "GracenoteIsoCodeAsShort.h"

/*! \cond ALL */

/* **************************************************************************
 * Function  Default contructor
 * *************************************************************************/
/**
 * Default contructor initializing code to 0
 */
IsoCodeAsShort::IsoCodeAsShort() : code(0) {}

/* **************************************************************************
 * Function  operator short 
 * *************************************************************************/
/**
 * cast to short
 * 
 * \return 16bit representation
 */
IsoCodeAsShort::operator short const() const {
    return code;
}

/* **************************************************************************
 * Function less operator   
 * *************************************************************************/
/**
 * less operator
 */
bool IsoCodeAsShort::operator<(const IsoCodeAsShort &icas2) const {
    return this->code < icas2.code;
}

/* **************************************************************************
 * Function equality operator
 * *************************************************************************/
/**
 * equality operator
 */
bool IsoCodeAsShort::operator==(const IsoCodeAsShort &icas2) const {
    return this->code == icas2.code;
}

/*! \endcond */
