/// \file GracenoteCountryCode.cpp
///
/// This provides base class to handle numeric (short) representations of ISO country codes
///
/// Copyright: (c) 2011 Robert Bosch GmbH
///
/// \author Ingo Reise CM-AI/PJ-GM28 (external.ingo.reise@de.bosch.com)
///
/// \version 05.04.2011 Initial version
///

#include "GracenoteCountryCode.h"


/* **************************************************************************
 * Function setCode
 * *************************************************************************/ 
/**
 * Convert three characters to 16 bit short, 5bit per character
 * 
 * \param[in] lc 3-char country  
*/
void tclCountryCode::setCode(char* const lc)
{
    code = (short) (1024 * (lc[0] - '@') + 32 * (lc[1] - '@') + (lc[2] - '@'));
}

/*! \cond ALL */

/* **************************************************************************
 * Function Constructor 
 * *************************************************************************/ 
/**
* Constructor just setting code directly
*/
tclCountryCode::tclCountryCode(short lc)
{
    code = lc;
}

/* **************************************************************************
 * Function Constructor 
 * *************************************************************************/ 
/**
* Constructor converting three characters to 15 bit short
*/
tclCountryCode::tclCountryCode(char *lc)
{
    setCode(lc);
}

/*! \endcond */

/* **************************************************************************
 * Function Constructor 
 * *************************************************************************/ 
/**
* Constructor with sds_fi_tcl_e16_ISOCountryCode
* 
* Example:
* \code tclCountryCode(sds_fi_tcl_e16_ISOCountryCode::FI_EN_ISO_ALPHA_3_DEU); \endcode
*/
tclCountryCode::tclCountryCode(sds_fi_tcl_e16_ISOCountryCode cc)
{
    code = (short) cc.enType;
}

