/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : IHealthcareMonParser.h
 * COMPONENT Name      : IHealthcareMonParser
 * DESCRIPTION         :
 * AUTHOR              : Piyush Priye
 * Date                : 16.06.2021
 * Revision History    : 1.0
*/
 
//****************************************************************************/
#ifndef I_HEALTHCAREMON_PARSER_H_
#define I_HEALTHCAREMON_PARSER_H_
#include <string>
#include <vector>
#include <map>
#include<iterator>
#include "system_types.h"

typedef struct {
                        std::string m_sname;
                        uint32_t  m_sCode;
                        uint8_t m_severity;
                        uint16_t m_textid;
                        std::string m_errname;
                        std::string m_lang;
               }tDeviceDTCInfo; 


typedef std::vector<tDeviceDTCInfo>tDTCInfo;


class IHealthcareMonParser
{
	public:
	//API for starting parsing
		virtual tBool bParseXml() = 0;
	//API to get Device DTC code
		virtual tDTCInfo vectorGetDTCListInfo(tCString pDevName) = 0;
		//Get Error code 
		virtual tU8 u8GetErrorCode() = 0;
		//Get Error Description 
		virtual std::string sGetErrorDescription() = 0;
		
		virtual ~IHealthcareMonParser(){}
};
#endif /* I_HEALTHCAREMON_PARSER_H_ */