/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : HealthcareMonParsingError.h
 * COMPONENT Name      : HealthcareMonParsingError
 * @details         :
 * AUTHOR              : Piyush Priye
 * Date                : 15.06.2021
 * Revision History    : 1.0
 */

#ifndef HEALTHCAREMON_HEALTHCAREMONPARSINGERROR_H_
#define HEALTHCAREMON_HEALTHCAREMONPARSINGERROR_H_
#include <string>
#include "system_types.h"

class tclHealthcareMonParsingError {
public:
	enum {
		HEALTHCAREMON_NO_ERROR = 0,
		HEALTHCAREMON_ERROR = 1,
		HEALTHCAREMON_ERROR_OPENING_FILE = 2,
		HEALTHCAREMON_ERROR_OUT_OF_MEMORY = 3,
		HEALTHCAREMON_ERROR_PARSING_ELEMENT = 4,
		HEALTHCAREMON_ERROR_FAILED_TO_READ_ELEMENT_NAME = 5,
		HEALTHCAREMON_ERROR_READING_ELEMENT_VALUE = 6,
		HEALTHCAREMON_ERROR_READING_ATTRIBUTES = 7,
		HEALTHCAREMON_ERROR_PARSING_EMPTY = 8,
		HEALTHCAREMON_ERROR_READING_END_TAG = 9,
		HEALTHCAREMON_ERROR_PARSING_UNKNOWN = 10,
		HEALTHCAREMON_ERROR_PARSING_COMMENT = 11,
		HEALTHCAREMON_ERROR_PARSING_DECLARATION = 12,
		HEALTHCAREMON_ERROR_DOCUMENT_EMPTY = 13,
		HEALTHCAREMON_ERROR_EMBEDDED_NULL = 14,
		HEALTHCAREMON_ERROR_PARSING_CDATA = 15,
		HEALTHCAREMON_ERROR_DOCUMENT_TOP_ONLY = 16,
		HEALTHCAREMON_ERROR_STRING_COUNT = 17,
		HEALTHCAREMON_ERROR_DUPLICATE_ENTITYID = 18,
		HEALTHCAREMON_ERROR_DUPLICATE_ENTITYIP = 19,
		HEALTHCAREMON_ERROR_DEVICE_UNAVAILABLE = 20
	 };
private:
	tU8 m_u8ErrorCode;
	std::string m_sErrorDesc;
public:
	tclHealthcareMonParsingError();
	virtual ~tclHealthcareMonParsingError();
	tU8 u8GetErrorCode();
	tVoid vSetErrorCode(tU8 u8ErrorCode);
	tVoid vSetErrorDescription(std::string sErrorDesc);
	std::string sGetErrorDescription();
};

#endif /* HEALTHCAREMON_HEALTHCAREMONPARSINGERROR_H_ */
