/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : HealthcareMonParsingError.cpp
 * COMPONENT Name      : HealthcareMonParsingError
 * @details         :
 * AUTHOR              : Piyush Priye
 * Date                : 15.06.2021
 * Revision History    : 1.0
 */

#include "HealthcareMonParsingError.h"
#include "HealthMontrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HEALTHCAREMONASF
#define ETG_I_TRACE_CHANNEL               TR_COMP_FC_TELEMATIC
#define ETG_I_TTFIS_CMD_PREFIX            "HEALTHCAREMONAPP"
#define ETG_I_FILE_PREFIX                 HEALTHCAREMONAPP::SERVICE
#include "trcGenProj/Header/HealthcareMonParsingError.cpp.trc.h"
#endif


/*! ***********************************************************************
 *FUNCTION: 		tclHealthcareMonParsingError
 *@details: 		Constr
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Piyush Priye		Initial
 ************************************************************************/
tclHealthcareMonParsingError::tclHealthcareMonParsingError():m_u8ErrorCode(0){
	// TODO Auto-generated constructor stub
	ETG_TRACE_USR4(("tclHealthcareMonParsingError: Constructor"));

}

/*! ***********************************************************************
 *FUNCTION: 		tclHealthcareMonParsingError
 *@details: 		Destr
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Piyush Priye		Initial
 ************************************************************************/
tclHealthcareMonParsingError::~tclHealthcareMonParsingError() {
	// TODO Auto-generated destructor stub
	ETG_TRACE_USR4(("tclHealthcareMonParsingError: Destructor"));
}


/*! ***********************************************************************
 *FUNCTION: 		u8GetErrorCode
 *@details: 		Get the error code
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		tU8
 *@details
 *HISTORY:
 *08.03.2020		0.1		Piyush Priye		Initial
 ************************************************************************/
tU8 tclHealthcareMonParsingError::u8GetErrorCode(){
	return m_u8ErrorCode;
}

/*! ***********************************************************************
 *FUNCTION: 		vSetErrorCode
 *@details: 		Set the error code
 *REQUIREMENT ID:	NA
 *@param:		tU8
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Piyush Priye		Initial
 ************************************************************************/
tVoid tclHealthcareMonParsingError::vSetErrorCode(tU8 u8ErrorCode){
	m_u8ErrorCode = u8ErrorCode;
}

/*! ***********************************************************************
 *FUNCTION: 		vSetErrorDescription
 *@details: 		Set the error code
 *REQUIREMENT ID:	NA
 *@param:		string
 *@return: 		NA
 *@details
 *HISTORY:
 *08.03.2020		0.1		Piyush Priye		Initial
 ************************************************************************/
tVoid tclHealthcareMonParsingError::vSetErrorDescription(std::string sErrorDesc){
	m_sErrorDesc = sErrorDesc;
}

/*! ***********************************************************************
 *FUNCTION: 		sGetErrorDescription
 *@details: 		Set the error description
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		string
 *@details
 *HISTORY:
 *08.03.2020		0.1		Piyush Priye		Initial
 ************************************************************************/
std::string tclHealthcareMonParsingError::sGetErrorDescription() {
	return m_sErrorDesc;
}
