/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * @file               : HealthcareMonParser.h
 * @brief	       : HealthcareMonParser
 * @detail             :
 * @author             : Piyush Priye
 * @Date               : 11.05.2021
 * Revision History    : 1.0
 */
#ifndef HALTHCAREMON_PARSER_H_
#define HALTHCAREMON_PARSER_H_

#include "tinyxml.h"
#include "IHealthcareMonParser.h"
#include "HealthcareMonParsingError.h"
#include <string>
#include <vector>
#include "system_types.h"


class tclHealthcareMonParser:public IHealthcareMonParser
{
private:
	
	tDTCInfo m_CMCDTCInfo;
	tDTCInfo m_CMADTCInfo;
	tDTCInfo m_CMGDTCInfo;
	tDTCInfo m_CMPDTCInfo;
	tDTCInfo m_CMRDTCInfo;
	tBool m_bParseState;
	tclHealthcareMonParsingError m_parsingErrorObj;
	static tclHealthcareMonParser* m_pInstance;
	tclHealthcareMonParser();
	tBool bParseEntity(TiXmlElement* pElement);
public:
	~tclHealthcareMonParser();
	tDeviceDTCInfo ParseDeviceDtcInfo(TiXmlAttribute* pXmlAttribute,TiXmlElement* pElement = nullptr);
	static tclHealthcareMonParser* pGetInstance();
	//Parsing xml API
	tBool bParseXml();
	//Get Error code 
	tU8 u8GetErrorCode();
	//Get Error Description 
	std::string sGetErrorDescription();
	tDTCInfo vectorGetDTCListInfo(tCString pDevName);
	
};
#endif   //HALTHCAREMON_PARSER_H_


