/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                  : HealthcareMonComponent.cpp
* COMPONENT Name        : HealthcareMon
* DESCRIPTION           : DBus Server for HealthcareMon Services.
* AUTHOR                : 
* Date                  : 24.07.2018
* Revision History      : 0.1
* Date 23.08.2017       : Initial version
****************************************************************************/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
//#include "IntercomService.h"
//#include "IntercomAudioClientHandler.h"
#include "HealthcareMonComponent.h"
#include "HealthMontrace.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON



#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HEALTHCAREMONASF
#define ETG_I_TRACE_CHANNEL               TR_COMP_FC_TELEMATIC
#define ETG_I_TTFIS_CMD_PREFIX            "HEALTHCAREMONAPP"
#define ETG_I_FILE_PREFIX                 HealthcareMonInterface::HealthcareMonComponent::
#include "trcGenProj/Header/HealthcareMonComponent.cpp.trc.h"
#endif


namespace HealthcareMonInterface {

HealthcareMonComponent::HealthcareMonComponent() 
{
    vInitPlatformEtg();
    ETG_I_REGISTER_FILE();
    ETG_I_REGISTER_CHN(0xA300);
    
    if (NULL == HealthCareMonServer::getInstance())
    {
        ETG_TRACE_USR4(("HealthCareMonServer Object creation failed"));
    }
    if(NULL == HealthCareNanoMsgClient::getInstance())
    {
       ETG_TRACE_USR4(("HealthCareNanoMsgClient Object creation failed"));
    }
    if(NULL == HealthcareMonDtcProcess::getInstance())
    {
      ETG_TRACE_USR4(("HealthCareMonDtc Object creation failed"));
    }
    if(NULL == HealthCareDiaglogClient::getInstance())
    {
      ETG_TRACE_USR4(("HealthCareDiagClient Object creation failed"));
    }
}

HealthcareMonComponent::~HealthcareMonComponent()
{
   HealthCareMonServer::vDeleteInstance();
   HealthCareNanoMsgClient::vDeleteInstance();
   HealthcareMonDtcProcess::vDeleteInstance();
   HealthCareDiaglogClient::vDeleteInstance();

}

/************************************************************************
*FUNCTION: 		TraceCmd_HEALTHCAREMONAPP()
*DESCRIPTION: TTFIS handler of the class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	21/06/2021
*************************************************************************/
ETG_I_CMD_DEFINE((TraceCmd_HEALTHCAREMONAPP,"Healthcaremon %u",uint8_t))
void HealthcareMonComponent::TraceCmd_HEALTHCAREMONAPP(uint8_t i)
{
ETG_TRACE_USR4(("Entered HealthcareMonApp TTFIS handler"));
//HealthCareMonServer::getInstance()->toTestServer(i);
HealthCareNanoMsgClient::getInstance()->totestDtcEvent(i);
}




}//HealthcareMonInterface

