#ifndef HEALTHCARE_DEFINES
#define HEALTHCARE_DEFINES
#include <vector>
#include <stdio.h>
#include <stdlib.h>
#include <map>
#include <iostream>
#include "NanoMsgLCMInterfaceConst.h"
#include "HealthcareMonParser.h"
#include <pthread.h>
#include <mutex>
#include <condition_variable>
#include <atomic>
#include <malloc.h>
#include <memory.h>
#include <sched.h>

using namespace std;
using namespace ::bosch::cm::di::NanoMsgLCMInterface;

#define ACTIVE 1
#define INACTIVE 0

#define OK 0
#define NOK 1
#define DISABLE 2
#define WAIT_FOR_ACK 3

#define DTC_FOUND 1
#define DTC_NOTFOUND  0
#define DEFAULT_DTC_SEVERITY 3
#define MAX_KDS_SEVERITY 4
#define MIN_KDS_SEVERITY 0
struct dtcInfo 
{
   uint32_t u32Dtccode;
   uint8_t  u8Status;
};

typedef vector<dtcInfo> Dtclist;
typedef vector<uint8_t> rawDtcInfo;
typedef struct dtctbl {
	        ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_ID = enDevID__enDevID_Media_Center;
                uint8_t u8devNr = 0;
	      	uint32_t u32DtcCode = 0;
		uint8_t u8DtcActiveStatus = 0;
		uint8_t u8AckStatus = 0;
               }dtctable;
typedef vector<dtctable> dtcinfotable;
typedef map<::bosch::cm::di::NanoMsgLCMInterface::enDevID,dtcinfotable> mapdtctable;
typedef map<::bosch::cm::di::NanoMsgLCMInterface::enDevID,tDTCInfo> mapDTCXmltable;

struct dtcEvent
{
	::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_ID = enDevID__enDevID_Media_Center;
	uint8_t u8devNr = 0;
	uint16_t u16msgid = 0;
	string RecevedIP = "";
	vector<uint8_t> receivedDtcEvent;
};

struct dtcHMIQueue
{
    ::bosch::cm::di::NanoMsgLCMInterface::enDevID Dev_ID = enDevID__enDevID_Media_Center;
    uint8_t u8devNr = 0;
    uint32_t u32dtccode = 0;
    uint16_t u16textid = 0;
    string default_text ="";
};

typedef enum
{
	enmPOPUPIDLE,
	enmPOPUPBUSY
}enum_HMIPOPUPSTATE;

typedef enum
{
	enmDTCAvailable_And_Active,
	enmDTCAvailable_And_Inactive,
	enmNewDTC_tobe_Added,
	enumunknown
}enum_dtcAvailability;


typedef enum {
    enmThStateBusy,
    enmThStateWaiting,
    enmThStateDown,
    enmThStateShuttingDown,
    enmThStateFault

}enum_ThreadSM_en;

#endif
