/* ***************************************************************************************
* FILE:          HealthCareMonServer.cpp
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  HealthCareMonServer.cpp is part of HealtCareMonApplication
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Sathiya
 * Date: 14.06.2021
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "HealthCareMonServer.h"

#include "../Trace/HealthMontrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HEALTHCAREMONASF
#define ETG_I_TRACE_CHANNEL               TR_COMP_FC_TELEMATIC
#define ETG_I_TTFIS_CMD_PREFIX            "HEALTHCAREMONAPP"
#define ETG_I_FILE_PREFIX                 HEALTHCAREMONAPP::SERVICE
#include "trcGenProj/Header/HealthCareMonServer.cpp.trc.h"
#endif

using namespace ::asf::core;

HealthCareMonServer* HealthCareMonServer::p_HealthCareMonServer = NULL;

#define PORT_NAME "HealthcareMonServerPort"

/************************************************************************
*FUNCTION: 		HealthCareMonServer()
*DESCRIPTION: 	Constructor of the class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	14/06/2021
*************************************************************************/
HealthCareMonServer::HealthCareMonServer():HealthcareMonServiceStub(PORT_NAME)
{
	 ETG_TRACE_USR4(("HealthCareMonServer Constructor called"));
}
/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION: 	singleton implementation, creates an object
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	14/06/2021
*************************************************************************/
HealthCareMonServer* HealthCareMonServer::getInstance()
{
	ETG_TRACE_USR4(("HealthCareMonServer getInstance called"));
	if(p_HealthCareMonServer == NULL)
	{
		p_HealthCareMonServer = new HealthCareMonServer();
		ETG_TRACE_USR4(("HealthCareMonServer Instance created"));
	}
	return p_HealthCareMonServer;
}

/************************************************************************
*FUNCTION: 		vDeleteInstance()
*DESCRIPTION: 	vDeleteInstance will delete HealthCareMonServer
*				Singleton Object
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	14/06/2021
*************************************************************************/
void HealthCareMonServer::vDeleteInstance()
{
   if(p_HealthCareMonServer != NULL)
   {
      delete p_HealthCareMonServer;
      p_HealthCareMonServer = NULL;
   }
}


/************************************************************************
*FUNCTION: 		HealthCareMonServer()
*DESCRIPTION: 	singleton implementation, creates an object
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	14/02/2020
*************************************************************************/
HealthCareMonServer::~HealthCareMonServer()
{
	delete p_HealthCareMonServer;
}
/************************************************************************
*FUNCTION: 		onSendAcknowldgementRequest()
*DESCRIPTION: 	This method will be called by ASF Framework for getting 
Ack from HMI
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	14/06/2021
*************************************************************************/
void HealthCareMonServer::onSendAcknowldgementRequest (const ::boost::shared_ptr< SendAcknowldgementRequest >& request)
{
	ETG_TRACE_USR4(("Acknowlegement received from HMI"));
        ::bosch::cm::ai::HealthcareMonService::enDevID dev_ID = request->getDev_ID();
        uint8_t devNr = request->getDev_Nr();
        uint32_t Dtccode = request->getDtcCode();
        uint8_t ackstatus = request->getAck();
        ETG_TRACE_USR4(("DevId received from HMI is %d",dev_ID));
        ETG_TRACE_USR4(("DevNr receivef from HMI is %d",devNr));
        ETG_TRACE_USR4(("Dtccode received from HMI is %x",Dtccode));
        ETG_TRACE_USR4(("Ackstatus received from HMI is %d",ackstatus));
        HealthcareMonDtcProcess::getInstance()->HandleHMIStatus(static_cast<::bosch::cm::di::NanoMsgLCMInterface::enDevID>(dev_ID),devNr,Dtccode,ackstatus);
}
/************************************************************************
*FUNCTION:              SendtoHMI()
*DESCRIPTION:   this function from DtcProcess for sending dtc message 
to HMI
*PARAMETER: enDevID,dev_Nr,dtcCode,text_ID,default_text
*RETURNVALUE:   None
*HISTORY:
*revision 0.1   rsa8cob 28/06/2021
*************************************************************************/
void HealthCareMonServer::vSendToHMI(::bosch::cm::ai::HealthcareMonService::enDevID dev_ID,uint8 dev_Nr,uint32 dtcCode,uint16 text_ID,std::string default_text)
{
	 ETG_TRACE_USR4(("DevId send to HMI %d",dev_ID));
	 ETG_TRACE_USR4(("DevNr send to HMI %d",dev_Nr));
	 ETG_TRACE_USR4(("DtcCode send to HMI %d",dtcCode));
	 ETG_TRACE_USR4(("TextId send to HMI %d",text_ID));
	 ETG_TRACE_USR4(("Default string send to HMI %s",default_text));
	 sendSig_ShowDTCPopupSignal(dev_ID,dev_Nr,dtcCode,text_ID,default_text);
}
/************************************************************************
*FUNCTION:              toTestServer()
*DESCRIPTION:   this function will be called via TTFIS command
handler
*PARAMETER:             uint8_t
*RETURNVALUE:   None
*HISTORY:
*revision 0.1   rsa8cob 22/06/2021
*************************************************************************/
void  HealthCareMonServer::toTestServer(uint8_t choice)
{
 if(choice == 1)
 {
  ::bosch::cm::ai::HealthcareMonService::enDevID dev_ID =  ::bosch::cm::ai::HealthcareMonService::enDevID::enDevID__enDevID_Media_Apm;
  uint8 dev_Nr = 0x01;
  uint32 dtcCode = 0xbe0e5;
  uint16 text_ID = 0x00;
  std::string default_text = "CM-A Right Speaker 3 Output - open load";
  sendSig_ShowDTCPopupSignal(dev_ID,dev_Nr,dtcCode,text_ID,default_text);
  ETG_TRACE_USR4(("Sent ShowDtcPopupsignal to HMI"));
}
 if(choice == 2)
 {
  ::bosch::cm::ai::HealthcareMonService::enDevID dev_ID =  ::bosch::cm::ai::HealthcareMonService::enDevID::enDevID__enDevID_Media_Apm;
  uint8 dev_Nr = 0x01;
  uint32 dtcCode = 0xbe0e5;
  uint16 text_ID = 0x1B00;
  std::string default_text = "CM-A Right Speaker 3 Output - open load";
  sendSig_ShowDTCPopupSignal(dev_ID,dev_Nr,dtcCode,text_ID,default_text);
  ETG_TRACE_USR4(("Sent ShowDtcPopupsignal to HMI"));
}
 if(choice == 3)
 {
  ::bosch::cm::ai::HealthcareMonService::enDevID dev_ID =  ::bosch::cm::ai::HealthcareMonService::enDevID::enDevID__enDevID_Media_Apm;
  uint8 dev_Nr = 0x01;
  uint32 dtcCode = 0xbe0e5;
  uint16 text_ID = 0x000;
  std::string default_text = "";
  sendSig_ShowDTCPopupSignal(dev_ID,dev_Nr,dtcCode,text_ID,default_text);
  ETG_TRACE_USR4(("Sent ShowDtcPopupsignal to HMI"));
}
}
