/* ***************************************************************************************
* FILE:          HealthcareMonDtcProcess.h
* SW-COMPONENT:  HMI-BASE
 * DESCRIPTION:  HealthCareMonServer.h is part of HealtCareMonApplication
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Sathiya
 * Date: 23.06.2021
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef HEALTHCARE_MON_PROCESS_H
#define HEALTHCARE_MON_PROCESS_H
#include "NanoMsgLCMInterfaceConst.h"
#include "NanoMsgLCMInterfaceClientBase.h"
#include "NanoMsgLCMInterfaceProxy.h"
#include "HealthcareDefines.h"
#include "../DbusServer/HealthCareMonServer.h"
#include "HealthcareMonParser.h"

using namespace ::asf::core;
using namespace ::bosch::cm::di::NanoMsgLCMInterface;

typedef void * (*THREADFUNCPTR)(void *);
void msSleep( unsigned int mseconds);

class HealthcareMonDtcProcess
{
private:

      static HealthcareMonDtcProcess* p_HealthCareDtcProcess;
      uint16_t u16textid;
      string default_text;
      bool bDTCProcessFlag;
      dtcinfotable::iterator dtctableiter;
      uint8_t u8XmlSeverity;
      uint8_t u8KdsSeverity;
      enum_HMIPOPUPSTATE enHMIPopupState;
public:
      ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode powermode;
      string ipaddress;
      enum_ThreadSM_en  m_thCurrentState;
      bool		  m_thRunStatus;
      int           m_thStopTimer;
      mapdtctable dtcTableInformation;
      mapDTCXmltable dtcXmlContent;
      dtcinfotable CMA_dtctable;
      dtcinfotable CMG_dtctable;
      dtcinfotable CMR_dtctable;
      dtcinfotable CMP_dtctable;
      dtcinfotable HDTV_dtctable;
      dtcinfotable CMX_dtctable;
      dtcinfotable Intercom_dtctable;
      dtcinfotable Swivel_dtctable;
      dtcinfotable TestBed_dtctable;
      tDTCInfo CMC_ParsedContent;
      tDTCInfo CMA_ParsedContent;
      tDTCInfo CMG_ParsedContent;
      tDTCInfo CMR_ParsedContent;
      tDTCInfo CMP_ParsedContent;
     // vector<dtcEvent >    m_DtcEventQueue;
      vector<std::shared_ptr<dtcEvent> >    *m_DtcEventQueue;
      std::shared_ptr<dtcEvent>       m_thDtcEventCurrentContainer;
      vector<dtcHMIQueue> m_DtcHMIQueue;
      pthread_t     m_thHandle;
      long      m_threadID;
      // Declaration of thread condition variable
      pthread_cond_t m_thWaitCond;
      // declaring mutex
      pthread_mutex_t m_thMutexLock;
      void* thStartRoutine(void* dtcEventdata);
      bool addDtcEventToQueue(std::shared_ptr<dtcEvent> event);
      bool setDtcEvent(dtcEvent event);
      static HealthcareMonDtcProcess* getInstance();
      static void vDeleteInstance();
      virtual ~HealthcareMonDtcProcess();
    HealthcareMonDtcProcess();
    void Initialize();
    bool checkforValidSeverity(uint8_t severity);
    bool IsDTCCodeValid(uint32_t u32dtccode,tDTCInfo dtcparsedtable);
    void populateXmlContents();
    void processReceivedDtclist(::bosch::cm::di::NanoMsgLCMInterface::entPowerMode powermode,::bosch::cm::di::NanoMsgLCMInterface::enDevID devId,uint8_t devNumber,uint16_t msgId,string receivedIp,rawDtcInfo rawdtc);
    Dtclist vecGetAdaptedDTCList(rawDtcInfo rawdtc);
    dtcinfotable* getdtctable(::bosch::cm::di::NanoMsgLCMInterface::enDevID devId);
    tDTCInfo* getdtcXmlContenttable(::bosch::cm::di::NanoMsgLCMInterface::enDevID devId);
    void checkUpdateDtclistWithDtctable(::bosch::cm::di::NanoMsgLCMInterface::enDevID devId,uint8_t devNumber,dtcinfotable& dtctab,tDTCInfo& dtcparsedtable,Dtclist dtclist);
    void PopulateHMIQueue(::bosch::cm::di::NanoMsgLCMInterface::enDevID devId,uint8_t devNumber,uint32_t dtccode,dtcinfotable& dtctab);
    void AddDtcToDtctable(::bosch::cm::di::NanoMsgLCMInterface::enDevID devId,uint8_t devNumber,uint32_t dtccode);
    void HandleHMIStatus(::bosch::cm::di::NanoMsgLCMInterface::enDevID devId,uint8_t devNumber,uint32_t dtccode,uint8_t ackstatus);
    void readKdsDTCSeverity();
    bool checkAndAssignSeverity(uint8_t& severity);
    bool getdtcEventfromQueue();
    bool		pThreadStop(); //Stop Thread
    bool		pThreadStart(); // Start Thread
    void AddDTCEventtoHMIQueue(dtcHMIQueue newevent);
    void checkHMIQueueandUpdateHMI();
    bool processDtcEvent();
    enum_dtcAvailability    checkDtcStatusInHMIQueue(uint32_t u32dtccode,uint8_t u8status);
    bool isQueueEmpty();
    enum_ThreadSM_en getThreadState(){ return m_thCurrentState; }
    void setThreadState(enum_ThreadSM_en thState){	m_thCurrentState = thState; 	}
    void setThreadRunStatus(bool status){ m_thRunStatus = status;}
    bool getThreadRunStatus() {return m_thRunStatus;}
    HealthcareMonDtcProcess(const HealthcareMonDtcProcess&);           // Prevent copy-construction
    HealthcareMonDtcProcess& operator=(const HealthcareMonDtcProcess&);      // Prevent assignment
};
#endif

