/* ***************************************************************************************
* FILE:          HealthCareNanoMsgClient.cpp
* SW-COMPONENT:  
 * DESCRIPTION:  HealthCareNanoMsgClient.cpp is part of HealtCareMonApplication
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Sathiya
 * Date: 16.06.2021
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "HealthCareNanoMsgClientHandler.h"

#include "../Trace/HealthMontrace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_HEALTHCAREMONASF
#define ETG_I_TRACE_CHANNEL               TR_COMP_FC_TELEMATIC
#define ETG_I_TTFIS_CMD_PREFIX            "HEALTHCAREMONAPP"
#define ETG_I_FILE_PREFIX                 HEALTHCAREMONAPP::SERVICE
#include "trcGenProj/Header/HealthCareNanoMsgClientHandler.cpp.trc.h"
#endif

using namespace ::asf::core;

HealthCareNanoMsgClient* HealthCareNanoMsgClient::p_HealthCareNanoMsgClient = NULL;

#define CLIENT_PORT "NanoMsgLCMPort"

/************************************************************************
*FUNCTION: 		HealthCareNanoMsgClient()
*DESCRIPTION: 	Constructor of the class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
HealthCareNanoMsgClient::HealthCareNanoMsgClient()
{
	m_poLCMDBUSProxy = NanoMsgLCMInterfaceProxy::createProxy(CLIENT_PORT,*this);
        if(m_poLCMDBUSProxy == NULL)
        {
           ETG_TRACE_USR4(("Nanomsg Proxy creation failed"));
        }
	ETG_TRACE_USR4(("HealthCareNanoMsgClient Constructor called"));
}
/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION: 	Object creation of the class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
HealthCareNanoMsgClient* HealthCareNanoMsgClient::getInstance()
{
	ETG_TRACE_USR4(("HealthCareNanoMsgClient getInstance called"));
	if(p_HealthCareNanoMsgClient == NULL)
	{
		p_HealthCareNanoMsgClient = new HealthCareNanoMsgClient();
                if(p_HealthCareNanoMsgClient)
                {
	        	ETG_TRACE_USR4(("HealthCareNanoMsgClient Instance created"));
                }
	}
	return p_HealthCareNanoMsgClient;
}
/************************************************************************
*FUNCTION: 		vDeleteInstance()
*DESCRIPTION: 	Destruction of the object class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
void HealthCareNanoMsgClient::vDeleteInstance()
{
	if(p_HealthCareNanoMsgClient != NULL)
   {
      delete p_HealthCareNanoMsgClient;
	  p_HealthCareNanoMsgClient = NULL;
   }
}
/************************************************************************
*FUNCTION: 		~HealthCareNanoMsgClient()
*DESCRIPTION: 	Destruction of the object class
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
HealthCareNanoMsgClient::~HealthCareNanoMsgClient()
{
   ETG_TRACE_USR4(("HealthCareNanoMsgClient Destructor"));
   p_HealthCareNanoMsgClient = NULL;

}
/************************************************************************
*FUNCTION: 		onAvailable()
*DESCRIPTION: 	This function gets once the LCMDBUS client Service is 
available
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
void HealthCareNanoMsgClient::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
    ETG_TRACE_USR4(("HealthCareNanoMsgClient OnAvailable"));
   if(m_poLCMDBUSProxy)
   {
//      m_poLCMDBUSProxy->sendSig_RspHealthCareRegister(*this);
      m_poLCMDBUSProxy->sendSig_EventDtcOccuranceRegister(*this);
      ETG_TRACE_USR4(("Registered for Event DTC Signal"));
   }
}
/************************************************************************
*FUNCTION: 		onUnavailable()
*DESCRIPTION: 	This function gets once the LCMDBUS client Service is 
unavailable
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
void HealthCareNanoMsgClient::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
	ETG_TRACE_USR4(("HealthCareNanoMsgClient LCMDBUS Service Not Available"));
        if(m_poLCMDBUSProxy)
        {
//           m_poLCMDBUSProxy->sendSig_RspHealthCareDeregisterAll();
             m_poLCMDBUSProxy->sendSig_EventDtcOccuranceDeregisterAll();
        }
}
/************************************************************************
*FUNCTION: 		onSig_RspHealthCareSignal()
*DESCRIPTION: 	This function gets called once there is a DTC Message 
available from NanoMsg
unavailable
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
void HealthCareNanoMsgClient::onSig_RspHealthCareSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareSignal >& signal)
{
/*	ETG_TRACE_USR4(("HealthCareNanoMsgClient onSig_RspHealthCareSignal"));
        ::bosch::cm::di::NanoMsgLCMInterface::entPowerMode powermode = signal->getPowerMode();
        ::bosch::cm::di::NanoMsgLCMInterface::enDevID      devId     = signal->getDev_ID();
        uint8_t      u8DevNr     = signal->getDev_Nr();
        uint16_t    u16msgId     = signal->getMsg_ID();
        string      recievedIp = signal->getRecevedIP();
        rawDtcInfo rawdtc = signal->getDtcTable();
	ETG_TRACE_USR4(("HealthCareNanoMsgClient onSig_RspHealthCareSignal EventPower mode %d", powermode));
	ETG_TRACE_USR4(("HealthCareNanoMsgClient onSig_RspHealthCareSignal DevId is %d",devId));
	ETG_TRACE_USR4(("HealthCareNanoMsgClient onSig_RspHealthCareSignal DevNr is %d",u8DevNr));
	ETG_TRACE_USR4(("HealthCareNanoMsgClient onSig_RspHealthCareSignal received Ip is %s",recievedIp));
        if(NULL != HealthcareMonDtcProcess::getInstance())
        {
             HealthcareMonDtcProcess::getInstance()->processReceivedDtclist(powermode,devId,u8DevNr,u16msgId,recievedIp,rawdtc);
        }*/
       
}
/************************************************************************
*FUNCTION: 		onSig_RspHealthCareError()
*DESCRIPTION: 	
unavailable
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	rsa8cob	16/06/2021
*************************************************************************/
void HealthCareNanoMsgClient::onSig_RspHealthCareError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspHealthCareError >& error)
{
  ETG_TRACE_USR4(("HealthCareNanoMsgClient onSig_RspHealthCareSignal"));
}
/************************************************************************
*FUNCTION:             onSig_EventDtcOccuranceError ()
*DESCRIPTION:   
unavailable
*PARAMETER:             None
*RETURNVALUE:   None
*HISTORY:
*revision 0.1   rsa8cob 18/10/2021
*************************************************************************/
void HealthCareNanoMsgClient::onSig_EventDtcOccuranceError(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDtcOccuranceError >& error)
{
}
/************************************************************************
*FUNCTION:             onSig_EventDtcOccuranceSignal ()
*DESCRIPTION:   This function will be called whenever there is DTC Event
unavailable
*PARAMETER:             None
*RETURNVALUE:   None
*HISTORY:
*revision 0.1   rsa8cob 18/10/2021
*************************************************************************/
void HealthCareNanoMsgClient::onSig_EventDtcOccuranceSignal(const ::boost::shared_ptr< NanoMsgLCMInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventDtcOccuranceSignal >& signal)
{
	ETG_TRACE_USR4(("HealthCareNanoMsgClient onSigDTCEvent"));
//        ::bosch::cm::di::NanoMsgLCMInterface::enDevID      devId     = signal->getDev_ID();
  //      uint8_t      u8DevNr     = signal->getDev_Nr();
    //    uint16_t    u16msgId     = signal->getMsg_ID();
      //  string      recievedIp = signal->getRecevedIP();
        //rawDtcInfo rawdtc = signal->getDtcTable();
	dtcEvent newEvent;
	newEvent.Dev_ID = signal->getDev_ID();
	newEvent.u8devNr = signal->getDev_Nr();
	newEvent.u16msgid = signal->getMsg_ID();
	newEvent.RecevedIP = signal->getRecevedIP();
	newEvent.receivedDtcEvent = signal->getDtcTable();
        if(NULL != HealthcareMonDtcProcess::getInstance())
        {
             HealthcareMonDtcProcess::getInstance()->setDtcEvent(newEvent);
        }



}
/************************************************************************
*FUNCTION:             totestDtcEvent ()
*DESCRIPTION:   This is a TTFIS Handler function to test dtc Event
unavailable
*PARAMETER:             None
*RETURNVALUE:   None
*HISTORY:
*revision 0.1   rsa8cob 24/10/2021
*************************************************************************/
void HealthCareNanoMsgClient::totestDtcEvent(int i)
{
	ETG_TRACE_USR4(("HealthCareNanoMsgClient tetestDtcEvent"));
	dtcEvent newEvent;
	newEvent.Dev_ID = (::bosch::cm::di::NanoMsgLCMInterface::enDevID)2;
        newEvent.u8devNr = 2;
        newEvent.u16msgid = 4;
        newEvent.RecevedIP = "ipaddress";

	std ::vector<uint8_t> DtcTableData;
	if(i == 1)
	{
	DtcTableData.push_back(0x01);
	DtcTableData.push_back(0x07);
	DtcTableData.push_back(0xe0);
	DtcTableData.push_back(0xe3);
	DtcTableData.push_back(0xFF);
	DtcTableData.push_back(0x07);
	DtcTableData.push_back(0xe0);
	DtcTableData.push_back(0xe4);
	DtcTableData.push_back(0xFF);
	DtcTableData.push_back(0x07);
	DtcTableData.push_back(0xe0);
	DtcTableData.push_back(0xe5);
	DtcTableData.push_back(0xFF);
	DtcTableData.push_back(0x07);
	DtcTableData.push_back(0xe0);
	DtcTableData.push_back(0xe6);
	DtcTableData.push_back(0xFF);
	DtcTableData.push_back(0x08);
	DtcTableData.push_back(0xe0);
	DtcTableData.push_back(0xe3);
	DtcTableData.push_back(0xFF);
        }
	if(i == 2)
	{
		DtcTableData.push_back(0x01);
        DtcTableData.push_back(0x07);
        DtcTableData.push_back(0xe0);
        DtcTableData.push_back(0xe3);
        DtcTableData.push_back(0x00);
        DtcTableData.push_back(0x07);
        DtcTableData.push_back(0xe0);
        DtcTableData.push_back(0xe4);
        DtcTableData.push_back(0x00);
        DtcTableData.push_back(0x07);
        DtcTableData.push_back(0xe0);
        DtcTableData.push_back(0xe5);
        DtcTableData.push_back(0x00);
        DtcTableData.push_back(0x07);
        DtcTableData.push_back(0xe0);
        DtcTableData.push_back(0xe6);
        DtcTableData.push_back(0x00);
        DtcTableData.push_back(0x08);
        DtcTableData.push_back(0xe0);
        DtcTableData.push_back(0xe3);
        DtcTableData.push_back(0x00);
        }
        newEvent.receivedDtcEvent = DtcTableData;
	if(NULL != HealthcareMonDtcProcess::getInstance())
        {
             HealthcareMonDtcProcess::getInstance()->setDtcEvent(newEvent);
        }




}
