/************************************************************************
*FILE: 			  EmpListTTFisCmd.cpp
*SW-COMPONENT:  Di_Middleware_server
*DESCRIPTION: 	 Defines the class EmpListTTFisCmd which
*               handles TTFis input commands (that simulates Clients and EMPList Components actions)
*AUTHOR:        DRM2KOR
*COPYRIGHT:     (c) 2018 - 2019 Robert Bosch Car Multimedia GmbH
*HISTORY:
*20.02.2020 Rev. 0.1 DRM2KOR
************************************************************************/
/*****************************************************************
| includes
|----------------------------------------------------------------*/


#include "../ListController/ListHandler/ListHandlerLogic.h"
#include "AvdeccClientHandler.h"
#include "../ListController/AlbumArt/tClAlbumArt.h"
#include "EMPFactory.h"
#include <unistd.h>
#include <iostream>
#include <arpa/inet.h> 
#include "EmpListTTFisCmd.h"
	

/* Header files required for Tracing out log statements */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_ASF
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES1
#define ETG_I_TTFIS_CMD_PREFIX            "EMPLIST_"
#define ETG_I_FILE_PREFIX                 EMP_ListHandler::DbusComponent::EMPServer::EmpListTTFisCmd::
#include "trcGenProj/Header/EmpListTTFisCmd.cpp.trc.h"
#endif

/************************************************************************
*FUNCTION:      EmpListTTFisCmd
*DESCRIPTION:   Constructor
*PARAMETER:     None
*RETURNVALUE:   NA
*
*HISTORY:
*Rev 0.1 Initial Revision.
*revision 0.1	DRM2KOR
************************************************************************/
namespace EMP_ListHandler {
	namespace DbusComponent {
           namespace EMPServer {
EmpListTTFisCmd::EmpListTTFisCmd()
{
	ETG_TRACE_USR4(("EmpListTTFisCmd::EmpListTTFisCmd()"));
}

/************************************************************************
*FUNCTION:      ~EmpListTTFisCmd
*DESCRIPTION:   Destructor
*PARAMETER:     None
*RETURNVALUE:   NA
*
*HISTORY:
*Rev 0.1 Initial Revision.
*revision 0.1	DRM2KOR
************************************************************************/

EmpListTTFisCmd::~EmpListTTFisCmd()
{
	ETG_TRACE_USR4(("~EmpListTTFisCmd::~EmpListTTFisCmd()"));
}

/************************************************************************
*FUNCTION:      initialize
*DESCRIPTION:   Initialise fnction of tracehandler
*PARAMETER:     None
*RETURNVALUE:   NA
*
*HISTORY:
*revision 0.1	DRM2KOR
************************************************************************/
void EmpListTTFisCmd::initialize()
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::initialize() "));
	ETG_I_REGISTER_CHN(TR_TTFIS_NAVRES1);
	ETG_I_REGISTER_FILE();
}


/************************************************************************
*FUNCTION:      traceCmd_getDbStates
*DESCRIPTION:   Handles TTFis command to get db related states 
*PARAMETER:		(uint16_t SRCTYPE)
*				
*RETURNVALUE:   void
*
*HISTORY:
*revision 0.1	DRM2KOR	29/10/2020
************************************************************************/
ETG_I_CMD_DEFINE((traceCmd_getDbStates, "GetDbStates %u ", uint16_t))
void EmpListTTFisCmd::traceCmd_getDbStates(uint16_t SRCTYPE)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_getDbStates()"));
    EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler* pAvdeccClientHandler= EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler::poGetInstance();    
    pAvdeccClientHandler->en_getDBAvailability(static_cast<EnumConst::entSourceType>(SRCTYPE));
    pAvdeccClientHandler->en_getDBDownloadState(static_cast<EnumConst::entSourceType>(SRCTYPE));
	
}

/************************************************************************
*FUNCTION:      traceCmd_AADownloadRequest
*DESCRIPTION:   Handles TTFis command for AADownloadRequest-vSetTrackDetails
*PARAMETER:		(uint16_t SRCTYPE,uint16_t SONGID)
*				
*RETURNVALUE:   void
*
*HISTORY:
*revision 0.1	DRM2KOR	29/10/2020
************************************************************************/
ETG_I_CMD_DEFINE((traceCmd_AADownloadRequest, "AADownloadRequest %u %u %u", uint16_t, uint16_t, uint16_t))
void EmpListTTFisCmd::traceCmd_AADownloadRequest(uint16_t SRCTYPE, uint16_t SONGID, uint16_t LISTTYPE)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_AADownloadRequest()"));
	tClAlbumArt *instance = tClAlbumArt::poGetInstance();
	 uint16 songId= SONGID;
	entSourceType srcType = static_cast<entSourceType>(SRCTYPE);
	
	if(NULL != instance)
	instance->vSetTrackDetails(srcType, songId, LISTTYPE);
}

/************************************************************************
*FUNCTION:      traceCmd_CreateMediaPlayerListRequest
*DESCRIPTION:   Handles TTFis command for CreateMediaPlayerListRequest
*PARAMETER:		(uint16_t LISTTYPE,uint16_t SRCTYPE,uint8_t Region,uint16_t AbsoluteIndex)
*				
*RETURNVALUE:   void
*
*HISTORY:
*revision 0.1	DRM2KOR	22/11/2020
************************************************************************/
ETG_I_CMD_DEFINE((traceCmd_CreateMediaPlayerListRequest, "CreateMediaPlayerListRequest %u %u %u %u ", uint16_t, uint16_t, uint8_t, uint16_t))
void EmpListTTFisCmd::traceCmd_CreateMediaPlayerListRequest(uint16_t LISTTYPE,uint16_t SRCTYPE,uint8_t Region,uint16_t AbsoluteIndex)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_CreateMediaPlayerListRequest()"));
	clAsfEmpListHmiServiceAdaptor *instance = clAsfEmpListHmiServiceAdaptor::getInstance();
        boost::shared_ptr<ReqCreateMediaPlayerListRequest> ptr_ListReq{ new ReqCreateMediaPlayerListRequest() };
	    entListType listType = static_cast<entListType>(LISTTYPE);
        entSourceType srcType = static_cast<entSourceType>(SRCTYPE);
        ptr_ListReq->setSourceType(srcType);
        ptr_ListReq->setListType(listType);
	ptr_ListReq->setRegion(Region);
	ptr_ListReq->setAbsoluteIndex(AbsoluteIndex);
	if(NULL != instance)
	instance->onReqCreateMediaPlayerListRequest(ptr_ListReq);
}

/************************************************************************
*FUNCTION:      traceCmd_MediaPlayerListSliceRequest
*DESCRIPTION:   Handles TTFis command for MediaPlayerListSliceRequest
*PARAMETER:		(uint16_t LISTTYPE,uint16_t SRCTYPE,uint8_t Region,uint16_t StartingIndex,uint8_t WindowSize)
*				
*RETURNVALUE:   void
*
*HISTORY:
*revision 0.1	DRM2KOR	22/11/2020
************************************************************************/
ETG_I_CMD_DEFINE((traceCmd_MediaPlayerListSliceRequest, "MediaPlayerListSliceRequest %u %u %u %u %u", uint16_t, uint16_t, uint8_t, uint16_t, uint8_t))
void EmpListTTFisCmd::traceCmd_MediaPlayerListSliceRequest(uint16_t LISTTYPE,uint16_t SRCTYPE,uint8_t Region,uint16_t StartingIndex,uint8_t WindowSize)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_MediaPlayerListSliceRequest()"));
       clAsfEmpListHmiServiceAdaptor *instance = clAsfEmpListHmiServiceAdaptor::getInstance();
	boost::shared_ptr<ReqMediaPlayerListSliceRequest> ptr_ListSliceReq{ new ReqMediaPlayerListSliceRequest() };
	    entListType listType = static_cast<entListType>(LISTTYPE);
        entSourceType srcType = static_cast<entSourceType>(SRCTYPE);
        ptr_ListSliceReq->setSourceType(srcType);
    ptr_ListSliceReq->setListType(listType);
	ptr_ListSliceReq->setRegion(Region);
	ptr_ListSliceReq->setStartingIndex(StartingIndex);
        ptr_ListSliceReq->setWindowSize(WindowSize);
	if(NULL != instance)
	{
	    instance->onReqMediaPlayerListSliceRequest(ptr_ListSliceReq);
	}
}

ETG_I_CMD_DEFINE((traceCmd_SetLanguages, "SetLanguages %u", uint16_t))
void EmpListTTFisCmd::traceCmd_SetLanguages( uint16_t SRCTYPE)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_SetLanguages()"));
       clAsfEmpListHmiServiceAdaptor *instance = clAsfEmpListHmiServiceAdaptor::getInstance();
	boost::shared_ptr<SetMediaVideoLanguagesListRequest> ptr_LangList{ new SetMediaVideoLanguagesListRequest() };
    entSourceType srcType = static_cast<entSourceType>(SRCTYPE);
    
    std::vector<uint16> languages;
    languages.push_back(1);
    
    ptr_LangList->setSourceType(srcType);
	ptr_LangList->setRegion(0);
	ptr_LangList->setVideoLanguageIds(languages);
	if(NULL != instance)
	{
	    instance->onSetMediaVideoLanguagesListRequest(ptr_LangList);
	}
}

ETG_I_CMD_DEFINE((traceCmd_getSelectedLanguages, "getSelectedLanguages %u", uint16_t))
void EmpListTTFisCmd::traceCmd_getSelectedLanguages(uint16_t SRCTYPE)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_getSelectedLanguages()"));
    clAsfEmpListHmiServiceAdaptor *instance = clAsfEmpListHmiServiceAdaptor::getInstance();
    EnumConst::entSourceType enSourceType = static_cast<EnumConst::entSourceType>(SRCTYPE);
	if(NULL != instance)
	{
	    instance->vecGetSelectedLanguages(enSourceType);
	}
}

ETG_I_CMD_DEFINE((traceCmd_HasPlayableAudioVideoFiles, "MediaPlayerListHasPlayableAudioVideoFiles %u", uint16_t))
void EmpListTTFisCmd::traceCmd_HasPlayableAudioVideoFiles ( uint16_t SRCTYPE )
{
    ETG_TRACE_USR4(("traceCmd_HasPlayableAudioVideoFiles wont work as the implementation is moved to avdec client handler."));
	
	//implementation is moved to avdecclienthandler. inclusions of asf::dbus headers causes compilation errors
    AvdeccClientHandler *vAvdeccClientHandler =  AvdeccClientHandler::poGetInstance();
	 vAvdeccClientHandler->bRequestDBDownload ( static_cast <EnumConst::entSourceType> ( SRCTYPE ));
	 vAvdeccClientHandler->vCheckPlayableItem ( static_cast <EnumConst::entSourceType> ( SRCTYPE ) );
	
}

ETG_I_CMD_DEFINE((traceCmd_CheckInit_Playable, "MediaPlayerListCheckInit_Playable %u", uint16_t))
void EmpListTTFisCmd::traceCmd_CheckInit_Playable ( uint16_t SRCTYPE) 
{
    ETG_TRACE_USR4(("SelectQueryDAO for sourceType %d traceCmd_CheckInit_Playable ", SRCTYPE ));
    EnumConst::entSourceType enSourceType = static_cast <EnumConst::entSourceType>(SRCTYPE);
	EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler* pAvdeccClientHandler= EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler::poGetInstance();    
    pAvdeccClientHandler->vCheckPlayableItem(enSourceType);
}

ETG_I_CMD_DEFINE((traceCmd_SetPlayBackModes, "SetPlayBackModes %u %u %u %u ",uint32_t, uint16_t, uint16_t, uint32_t))
void EmpListTTFisCmd::traceCmd_SetPlayBackModes(uint32_t PLAYMODE, uint16_t SRCTYPE, uint16_t REGION, uint32_t SUBSOURCE)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_SetPlayBackModes()"));
    EnumConst::enPlayback_Modes enPlayMode = static_cast <EnumConst::enPlayback_Modes>(PLAYMODE);
    EnumConst::entSourceType enSourceType = static_cast <EnumConst::entSourceType>(SRCTYPE);
    EnumConst::enSubSourceType enSubSource = static_cast <EnumConst::enSubSourceType>(SUBSOURCE);
        
    EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler* pAvdeccClientHandler= EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler::poGetInstance();    
    pAvdeccClientHandler->enSetPlayBackMode(enPlayMode,REGION,enSourceType,enSubSource);
}

ETG_I_CMD_DEFINE((traceCmd_GetPlayBackMode, "GetPlayBackMode %u ",uint32_t))
void EmpListTTFisCmd::traceCmd_GetPlayBackMode(uint16_t SUBSRCTYPE)
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_GetPlayBackMode()"));
    EnumConst::enSubSourceType enSubSource = static_cast <EnumConst::enSubSourceType>(SUBSRCTYPE);
        
    EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler* pAvdeccClientHandler= EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler::poGetInstance();    
    ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_GetPlayBackMode() -- PLAYBACKMODE : %d", pAvdeccClientHandler->enGetPlayBackMode(enSubSource)));
}


    
ETG_I_CMD_DEFINE((traceCmd_RequestTrackIndex, "RequestTrackIndex %u %u %u %s",uint8_t, uint16_t, uint16_t, ETG_I_STRING))
void EmpListTTFisCmd::traceCmd_RequestTrackIndex(uint8_t TRACKINDEXACTION, uint16_t SRCTYPE, uint16_t LISTTYPE, std::string FOLDERPATH = "")
{
	ETG_TRACE_COMP(("EmpListTTFisCmd::traceCmd_RequestTrackIndex()"));

    EnumConst::entSourceType enSourceType = static_cast <EnumConst::entSourceType> ( SRCTYPE ); 
    EnumConst::entListType enListType = static_cast<EnumConst::entListType>(LISTTYPE);

    EMPFactory* m_poEmpFactory = EMPFactory::getEmpFactoryReference();
    if(m_poEmpFactory != NULL)
    {
    	tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(enSourceType);
	if(poListHandlerLogic != NULL)
        	poListHandlerLogic->vRequestTrackIndex(TRACKINDEXACTION, enSourceType, enListType, FOLDERPATH, 0);
    }
}

ETG_I_CMD_DEFINE((traceCmd_Init, "MediaPlayerInit %u", uint16_t))
void EmpListTTFisCmd::traceCmd_Init ( uint16_t SRCTYPE ) 
{
    ETG_TRACE_USR4(("MediaPlayerInit %d  ", SRCTYPE ));
	SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();

		if(nullptr != poSelectQueryDAO)
		{       
			bool init_status = poSelectQueryDAO->init(static_cast < eSourceType >(SRCTYPE));	
            ETG_TRACE_USR4(("MediaPlayerInit init_status %d ", init_status ));
		}
}

ETG_I_CMD_DEFINE((traceCmd_DeInit, "MediaPlayerDeInit %u", uint16_t))
void EmpListTTFisCmd::traceCmd_DeInit ( uint16_t SRCTYPE ) 
{
    ETG_TRACE_USR4(("MediaPlayerDeInit %d  ", SRCTYPE ));
	SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();

		if(nullptr != poSelectQueryDAO)
		{       
			bool Deinit_status = poSelectQueryDAO->deinit ( static_cast <eSourceType > (SRCTYPE));	
            ETG_TRACE_USR4(("MediaPlayerDeInit Deinit_status %d ", Deinit_status ));
		}
}

ETG_I_CMD_DEFINE((traceCmd_GetFirstSongId, "MediaPlayerGetFirstSongId %u %u", uint16_t, uint16_t))	
void EmpListTTFisCmd::traceCmd_GetFirstSongId ( uint16_t LISTTYPE, uint16_t SRCTYPE )
{
		SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();
		bool bRet =  false;
		ResponseSongInfo sCurrTrackInfo;
		eSourceType srcType = static_cast<eSourceType>(SRCTYPE);
		if(nullptr != poSelectQueryDAO)
		{
            sRequestFrontRearSong sReqFrontRearSong;
            sReqFrontRearSong.setType(static_cast<eListType>(LISTTYPE));
            sReqFrontRearSong.setSourceType(srcType);
            Langlist MediaLanguagesList;
            MediaLanguagesList.push_back(2);
            MediaLanguagesList.push_back(3);
            sReqFrontRearSong.setLang(MediaLanguagesList);
			ETG_TRACE_USR4(("traceCmd_GetFirstSongId getFirstSongId"));
		    bool bRet = poSelectQueryDAO->getFirstSongId(sReqFrontRearSong ,sCurrTrackInfo);	
            ETG_TRACE_USR4(("traceCmd_GetFirstSongId bRet  %d " , bRet));
            ETG_TRACE_USR4(("traceCmd_GetFirstSongId sCurrTrackInfo  %d " , sCurrTrackInfo.getUpdatedSongId()));
		}
		//vUpdateTrackIndex(bRet,u32CurrTrackIndex);
}

ETG_I_CMD_DEFINE((traceCmd_GetlastSong, "MediaPlayerGetLastSongID %u %u", uint16_t, uint16_t))	
void EmpListTTFisCmd::traceCmd_GetlastSong ( uint16_t LISTTYPE, uint16_t SRCTYPE )
{
		SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();
		bool bRet =  false;
		ResponseSongInfo sCurrTrackInfo;
		eSourceType srcType = static_cast<eSourceType>(SRCTYPE);
		if(nullptr != poSelectQueryDAO)
		{
            sRequestFrontRearSong sRequest_lastTrackIndex;
            sRequest_lastTrackIndex.setType(static_cast<eListType>(LISTTYPE));
            sRequest_lastTrackIndex.setSourceType(srcType);
            Langlist MediaLanguagesList;
            MediaLanguagesList.push_back(2);
            MediaLanguagesList.push_back(3);
            sRequest_lastTrackIndex.setLang(MediaLanguagesList);
			ETG_TRACE_USR4(("traceCmd_GetFirstSongId getLastSongId"));
		    bool bRet = poSelectQueryDAO->getLastSongId(sRequest_lastTrackIndex ,sCurrTrackInfo);	
            ETG_TRACE_USR4(("traceCmd_GetFirstSongId bRet  %d " , bRet));
            ETG_TRACE_USR4(("traceCmd_GetFirstSongId sCurrTrackInfo  %d " , sCurrTrackInfo.getUpdatedSongId()));
		}
		//vUpdateTrackIndex(bRet,u32CurrTrackIndex);
}

ETG_I_CMD_DEFINE((traceCmd_GetNextPreviousSongId, "MediaPlayerGetNextPreviousSongId %u %u %u %u %u", uint16_t, uint16_t, uint16_t, uint16_t, uint16_t))						
void EmpListTTFisCmd::traceCmd_GetNextPreviousSongId ( uint16_t SRCTYPE , uint16_t LISTTYPE, uint16_t SONGID , uint16_t Direction, uint16_t filetype)
{
		SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();
		sRequestSongId sRequestNextPrevSongId;
		sRequestNextPrevSongId.setCurrentSongId(SONGID);
		sRequestNextPrevSongId.setType(static_cast<eListType>(LISTTYPE));
		sRequestNextPrevSongId.setDirection(static_cast<eDirection>(Direction));
		sRequestNextPrevSongId.setSourceType(static_cast<eSourceType>(SRCTYPE));
		sRequestNextPrevSongId.setFileType(static_cast<eFileType>(filetype));
            Langlist vecSelectedLanguages;
            vecSelectedLanguages.push_back(2);
            vecSelectedLanguages.push_back(3);
        sRequestNextPrevSongId.setLang(vecSelectedLanguages);
		bool bRet =  false;
		ResponseSongInfo TrackInFo;
		if(nullptr != poSelectQueryDAO)
		{       
			bRet = poSelectQueryDAO->getNextPreviousSongId(sRequestNextPrevSongId,TrackInFo);
            ETG_TRACE_USR4(("traceCmd_GetNextPreviousSongId TrackIndex  %d " , TrackInFo.getUpdatedSongId()));
            ETG_TRACE_USR4(("traceCmd_GetNextPreviousSongId bRet  %d " , bRet));
        }
}

ETG_I_CMD_DEFINE((traceCmd_GetListCount, "MediaPlayerGetListCount %u %u", uint16_t, uint16_t))						
void EmpListTTFisCmd::traceCmd_GetListCount ( uint16_t SRCTYPE , uint16_t LISTTYPE )
{
        //Hard coding the list of languages.
		SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();
		sRequestCount sRequestListCount;
        sRequestListCount.setType(static_cast<eListType>(LISTTYPE));
        sRequestListCount.setSourceType(static_cast<eSourceType>(SRCTYPE));
            Langlist vecSelectedLanguages;
            vecSelectedLanguages.push_back(2);
            vecSelectedLanguages.push_back(3);
        sRequestListCount.setLang(vecSelectedLanguages);
        bool bRet =  false;
        uint16_t m_u16count = 0;
        if(nullptr != poSelectQueryDAO)
        {
            ETG_TRACE_USR4(("traceCmd_GetListCount Request GetList Count for list type %d , " , sRequestListCount.getType()));
            bRet = poSelectQueryDAO->getListCount(sRequestListCount,m_u16count);	
            ETG_TRACE_USR4(("traceCmd_GetListCount Count  %d " , m_u16count));
            ETG_TRACE_USR4(("traceCmd_GetListCount bRet  %d " , bRet));
        }
        //clearing the list of languages.
        vecSelectedLanguages.clear();
        sRequestListCount.setLang(vecSelectedLanguages);
        bRet =  false;
        m_u16count = 0;
        if(nullptr != poSelectQueryDAO)
        {
            ETG_TRACE_USR4(("traceCmd_GetListCount Count for list type %d , " , sRequestListCount.getType()));
            bRet = poSelectQueryDAO->getListCount(sRequestListCount,m_u16count);	
            ETG_TRACE_USR4(("traceCmd_GetListCount Count  %d " , m_u16count));
            ETG_TRACE_USR4(("traceCmd_GetListCount bRet  %d " , bRet));
        }
}

ETG_I_CMD_DEFINE((traceCmd_GetListSlice, "MediaPlayerGetListSlice %u %u %u", uint16_t, uint16_t, uint16_t))						
void EmpListTTFisCmd::traceCmd_GetListSlice ( uint16_t SRCTYPE , uint16_t LISTTYPE, uint16_t STARTINDEX )
{
    
    ETG_TRACE_USR4(("MediaPlayerGetListSlice"));
	sRequestMessage stReqWindowMessgae;
	stReqWindowMessgae.setType(static_cast<eListType>(LISTTYPE));
	stReqWindowMessgae.setStartIndex(STARTINDEX);
	stReqWindowMessgae.setWindowSize(20);
	stReqWindowMessgae.setSourceType(static_cast<eSourceType>(SRCTYPE));
            Langlist vecSelectedLanguages;
            vecSelectedLanguages.push_back(2);
            vecSelectedLanguages.push_back(3);
    stReqWindowMessgae.setLang(vecSelectedLanguages);
	ETG_TRACE_USR4((" MediaPlayerGetListSlice type   : %d, start index : %d , windowSize : %d \n",stReqWindowMessgae.getType(),stReqWindowMessgae.getStartIndex(),stReqWindowMessgae.getWindowSize()));
	SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();
	bool bRet =  false;
    dbManagerTypes::ItemList vItemList;
	if(nullptr != poSelectQueryDAO)
	{
		bRet = poSelectQueryDAO->getWindowListSliced((stReqWindowMessgae),vItemList);
		ETG_TRACE_USR4((" RRequestd to DB - Request Status  : %d \n",bRet));
	}
    
    //Print vItemList
    dbManagerTypes::ItemList::iterator itr;
	ETG_TRACE_USR4((" MediaPlayerGetListSlice  data size %d",vItemList.size()));
	for (itr = vItemList.begin(); itr != vItemList.end() ; itr++)
	{
		ETG_TRACE_USR4((" MediaPlayerGetListSlice  getFirstString : %s \n",itr->getFirstString().c_str()));
		ETG_TRACE_USR4((" MediaPlayerGetListSlice  getSecondString : %s \n",itr->getSecondString().c_str()));
		ETG_TRACE_USR4((" MediaPlayerGetListSlice  getAbsoluteIndex : %d \n",itr->getAbsoluteIndex()));
	} 
}

ETG_I_CMD_DEFINE((traceCmd_GetListInfo, "MediaPlayerGetListInfo %u %u", uint16_t, uint16_t))						
void EmpListTTFisCmd::traceCmd_GetListInfo ( uint16_t SRCTYPE , uint16_t LISTTYPE )
{
    
    ETG_TRACE_USR4(("MediaPlayerGetListInfo"));
	ReqListInfoMessage sRequestListInfoMessage;
	sRequestListInfoMessage.setType(static_cast <eListType> ( LISTTYPE ));
    sRequestListInfoMessage.setSourceType(static_cast <eSourceType > ( SRCTYPE ));
            Langlist vecSelectedLanguages;
            vecSelectedLanguages.push_back(2);
            vecSelectedLanguages.push_back(3);
    sRequestListInfoMessage.setLang(vecSelectedLanguages);
	SelectQueryDAO *poSelectQueryDAO = SelectQueryDAO::getInstance();
	bool bRet =  false;
    dbManagerTypes::ItemList vItemList;
	if(nullptr != poSelectQueryDAO)
	{
		bRet = poSelectQueryDAO->getListInfo((sRequestListInfoMessage), vItemList);
        ETG_TRACE_USR4((" MediaPlayerGetListInfo - Request Status  : %d \n",bRet));
	}
    
    //Print vItemList
    dbManagerTypes::ItemList::iterator itr;
	ETG_TRACE_USR4((" MediaPlayerGetListInfo  data size %d",vItemList.size()));
	for (itr = vItemList.begin(); itr != vItemList.end() ; itr++)
	{
		ETG_TRACE_USR4((" MediaPlayerGetListInfo  getFirstString : %s \n",itr->getFirstString().c_str()));
		ETG_TRACE_USR4((" MediaPlayerGetListInfo  getSecondString : %s \n",itr->getSecondString().c_str()));
		ETG_TRACE_USR4((" MediaPlayerGetListInfo  getAbsoluteIndex : %d \n",itr->getAbsoluteIndex()));
	} 
}


}}
}



/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
