/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : TFTPClientCMP.h
* COMPONENT Name      : di_middlewareserver
* DESCRIPTION         : Handles downloading of DB or Albumart for external media player List
* AUTHOR              : Madhuree
* Date                : 31.08.2020
* Revision History    : 0.1
* Date 31.08.2020     : Initial version
****************************************************************************/

#ifndef TFTPCLIENTCMP_HEADER
#define TFTPCLIENTCMP_HEADER

#include <stdio.h>
#include <string>
#include "AVRoutingParser.h"
#include "../DbusComponent/AvdeccClient/AvdeccPluginConstant.h"
#include "TFTPClientBase.h"

#include "TFTPClientDefines.h"

class TFTPClientCMP: public TFTPClientBase
{
    public:
        TFTPClientCMP();
        virtual ~TFTPClientCMP();
        static size_t my_fwrite(void *buffer, size_t size, size_t nmemb, void *stream);
        EnumConst::entDownloadState reqDBDownload(uint16_t sourceType);
        EnumConst::entDownloadState reqAlbumArtDownload(uint16_t sourceType, uint16_t songId, uint16_t FileType);
        void RemoveDBFile(uint16_t sourceType);
        std::string getCmpIpAddress();
        
    private:
        static TFTPClientCMP* m_poSelf;
        bool downloadDB(std::string IP);
        bool downloadAlbumart(std::string IP, uint16_t songID, uint16_t FileType);
        bool curlDownloadFile(TftpFile *tftpFile, std::string url);
        void removePrevAlbumart();	
        
         std::string CmpIpAddress = "";
        void createDirectory();	
        bool initializeXMLParser ();		

};


#endif
