/****************************************************************************
* Copyright (c) 2019-2020 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : TFTPClientBase.h
* COMPONENT Name      : di_middlewareserver
* DESCRIPTION         : Abstract class for TFTP clients
* AUTHOR              : Apoorva C S
* Date                : 13/08/2021
* Revision History    : 0.1
* Date 13/08/2021     : Initial version
****************************************************************************/

#ifndef TFTPCLIENT_HEADER
#define TFTPCLIENT_HEADER

#include <stdio.h>
#include <string>
#include "AVRoutingParser.h"
#include "../DbusComponent/AvdeccClient/AvdeccPluginConstant.h"
#include "TFTPClientDefines.h"

class TFTPClientBase
{
    public:
        struct TftpFile {
            char *filename;
            FILE *stream;
        };
        TftpFile *tftpFile;
        tclEntityInfo *m_pEntityInfo;
        std::string savedAlbumartName;
        bool     m_bParseState;
        int m_albumartDirCreation;
        int m_databaseDirCreation;
        
        virtual ~TFTPClientBase() {};
        virtual EnumConst::entDownloadState reqDBDownload(uint16_t sourceType) = 0;
        virtual EnumConst::entDownloadState reqAlbumArtDownload(uint16_t sourceType, uint16_t songId, uint16_t FileType) = 0;
        virtual void RemoveDBFile(uint16_t sourceType) = 0;
        virtual bool downloadDB(std::string IP) = 0;
        virtual void removePrevAlbumart() = 0;	
        virtual bool downloadAlbumart(std::string IP, uint16_t songID, uint16_t FileType) = 0;
        virtual bool curlDownloadFile(TftpFile *tftpFile, std::string url) = 0;
        virtual void createDirectory() = 0;	
        virtual bool initializeXMLParser () = 0;		

};


#endif
