/* ***************************************************************************************
 * FILE:          clListHandlerCoreThread.h
 * SW-COMPONENT:  EMP_List_Handler_Application
 * DESCRIPTION:  clListHandlerCoreThread.h is part of EMP List Handler Application
 * 				 This is thread base class with queue and wait logic, 
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Vasuki T(RBEI/ECG5)  22.12.2020
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CL_LIST_HANDLER_CORE_THREAD_HEADER
#define CL_LIST_HANDLER_CORE_THREAD_HEADER

#include "includes.h"
#include "Constants.h"
#include "ListHandlerLogic.h"

typedef void * (*THREADFUNCPTR)(void *);
void msSleep( unsigned int mseconds);


class clListHandlerCoreThread
{
private:
	// Private member variable declarations

	bool		  m_thRunStatus;
	pthread_t     m_thHandle;
	LONG	      m_threadID;
	vector<std::shared_ptr<stWindowSliceRequest> >    *m_thListReqQueue;

	std::shared_ptr<stWindowSliceRequest>       m_thListReqCurrentContainer;
	enum_ThreadSM_en  m_thCurrentState;
	LONG          m_thStatusTime;
	LONG		  m_thStackSize;
	bool		  addListRequestToQueue(std::shared_ptr<stWindowSliceRequest> s);
	bool		  getListRequestFromQueue();
	bool		  isQueueEmpty();
	int           m_thStopTimer;
	// tclListHandlerLogic* m_plistHandler;

public:

	//Constructor and destructor
	clListHandlerCoreThread();
	virtual ~clListHandlerCoreThread(void);

	//Thread create Call back and routine
	virtual bool _listRequestCallBack(std::shared_ptr<stWindowSliceRequest> listData) = 0;
	VOIDPTR thStartRoutine(VOIDPTR NanoPacket);

	//Public methods declarations
	bool		processListRequest();
	bool		setListRequestEvent(stWindowSliceRequest listData);
	bool		pThreadStop(); //Stop Thread
	bool		pThreadStart(); // Start Thread
	//bool		checkThreadRunStatus(LONG timeout=0); // to be introduced on need basis

	//Setters and getters section
	enum_ThreadSM_en getThreadState(){ return m_thCurrentState; }
	void setThreadState(enum_ThreadSM_en thState){	m_thCurrentState = thState; 	}
	void setThreadRunStatus(bool status){ m_thRunStatus = status;}
	bool getThreadRunStatus() {return m_thRunStatus;}
	// Declaration of thread condition variable
	pthread_cond_t m_thWaitCond;
	// declaring mutex
	pthread_mutex_t m_thMutexLock;
};
#endif

