/* ***************************************************************************************
 * FILE:          clCMRProcessThread.h
 * SW-COMPONENT:  EMP_ListHandler
 * DESCRIPTION:  clCMRProcessThread.h is part of EMP_ListHandler
 * 				 This class is a thread class runs for processing CMP msg's
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  04.08.2021
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */


/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "clCMRProcessThread.h"
#include "ListHandlerTypes.h"
#include "CMRListHandlerLogic.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_LOGIC
#define ETG_I_TRACE_CHANNEL     TR_TTFIS_NAVRES1
#include "trcGenProj/Header/clCMRProcessThread.cpp.trc.h"
#endif

clCMRProcessThread* clCMRProcessThread::m_poSelf = NULL;
/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION:   Static Function, Singleton implementation, return the ptr of the
*				Singleton class clCMRProcessThread
*PARAMETER:		None
*RETURNVALUE: 	clCMRProcessThread*
*History:		Initial version
*************************************************************************/
clCMRProcessThread* clCMRProcessThread::getInstance()
{
        ETG_TRACE_USR4(("clCMRProcessThread::getInstance()"));

   if (NULL == m_poSelf)
   {
      m_poSelf = new clCMRProcessThread();
   }
   return m_poSelf;
}
//todo Delete instance to be created
//delete instance to be called in the destructor of the NanoMsgMasterAppService

/************************************************************************
*FUNCTION: 		clCMRProcessThread()
*DESCRIPTION:   Constructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Initial version
*************************************************************************/
clCMRProcessThread::clCMRProcessThread()
{
    ETG_TRACE_USR4(("clCMRProcessThread::Constructor"));
}

/************************************************************************
*FUNCTION: 		~clCMRProcessThread()
*DESCRIPTION:   Destructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Initial version
*************************************************************************/
clCMRProcessThread::~clCMRProcessThread()
{
    ETG_TRACE_USR4(("clCMRProcessThread::Destructor"));
	if(m_poSelf != NULL)
		delete m_poSelf;
}

/************************************************************************
*FUNCTION: 		vDeleteInstance()
*DESCRIPTION:   Static Function, Singleton implementation, Deletes the Singleton Object 
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Initial version
*************************************************************************/
void clCMRProcessThread::vDeleteInstance()
{
   if (NULL != m_poSelf)
   {
	   ETG_TRACE_USR4(("clCMRProcessThread::vDeleteInstance(), deleting the obj"));
		delete m_poSelf;
		m_poSelf = NULL;
   }
}


/************************************************************************
*FUNCTION: 		_listRequestCallBack()
*DESCRIPTION:   Thread call back function will be called by parent class 
*				when msg is added to queue to send it to List handler
*PARAMETER:		std::shared_ptr<stWindowSliceRequest>
*RETURNVALUE: 	Bool
*History:		Initial version
*************************************************************************/
bool clCMRProcessThread::_listRequestCallBack( std::shared_ptr<stWindowSliceRequest> listData )
{
	ETG_TRACE_USR4(("clCMRProcessThread::_listRequestCallBack"));
	if (NULL != listData)
	CMRListHandlerLogic::getInstance()->vRequestMediaPlayerListSlice(*(listData.get()));
	return true;
} 
