/************************************************************************
*FILE: 			ListHandlerTypes.h
*SW-COMPONENT:
*DESCRIPTION:   User defined data types with respect to External Mediaplayer List handler
*				Functionalities
*AUTHOR: 		Deepak Babu K
*COPYRIGHT: 	(c) 2020 - 2021 Robert Bosch Car Multimedia GmbH
*HISTORY:
*28.07.2020 Rev. 0.1 Deepak Babu K
* 				Initial Revision.
************************************************************************/

#ifndef LISTHANDLER_DATATYPES_HEADER
#define LISTHANDLER_DATATYPES_HEADER


#include <string>
#include <stdint.h>
#include "../../DbusComponent/AvdeccClient/AvdeccPluginConstant.h"
#include "ListHandler.h"

#include<iostream>
#include <map>
#define DEFAULT_WINDOW_SIZE 20
#define ZERO 0
#define ONE 1
#define TOTAL_SLICES 3
class tclListHandlerInterface;

namespace listHandlerTypes
{
	typedef struct
	{
		EnumConst::entListType ListType;
		EnumConst::entSourceType SourceType;
		uint8_t Region;
		uint16_t startIndex;
		uint8_t windowSize;
        std::string FolderPath;
	}stWindowSliceRequest;

	typedef std::map<EnumConst::entListType,tclListHandlerInterface*> mEMPDataMap;

}
#endif // LISTHANDLER_DATATYPES_HEADER
