/* ***************************************************************************************
 * FILE:          CMPListHandlerLogic.h
 * SW-COMPONENT:  EMP_ListHandler
 * DESCRIPTION:  CMPListHandlerLogic.h is part of EMP_ListHandler
 * 				 This class is a thread class runs for processing CMP msg's
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  04.08.2021
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */

#ifndef CLCMPLISTHANDLERLOGIC_HEADER
#define CLCMPLISTHANDLERLOGIC_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

#include "ListHandlerLogic.h"
#include "dbManagerTypeDefs.h"

class CMPListHandlerLogic : public tclListHandlerLogic
{

public:
	static CMPListHandlerLogic* getInstance();
	static void vDeleteInstance();
	virtual ~CMPListHandlerLogic();
	void vRequestMediaPlayerListSlice(stWindowSliceRequest listData);
	void vRequestCreateMediaPlayerList(const EnumConst::entListType eListType,
													const EnumConst::entSourceType eSourceType,
													const uint8_t u8Region,
													std::string sFolderPath);
    void vUpdateListSlice(dbManagerTypes::ItemList& ListData, EnumConst::entListType enListType);
    CMPListHandlerLogic();

private:
	static CMPListHandlerLogic* m_poSelf;
		
};
#endif //CLCMPLISTHANDLERLOGIC_HEADER