/* ***************************************************************************************
 * FILE:          CMPListHandlerLogic.h
 * SW-COMPONENT:  EMP_ListHandler
 * DESCRIPTION:  CMPListHandlerLogic.h is part of EMP_ListHandler
 * 				 This class is a thread class runs for processing CMP msg's
 * COPYRIGHT:  (c) 2020-21 	Robert Bosch Car Multimedia GmbH
 * HISTORY: 
 * AUTHOR:  Shivakumar J(RBEI/ECH2)  04.08.2021
 *				Initial version
 * The reproduction, distribution and utilization of this file as well as the
 * communication of its contents to others without express authorization is
 * prohibited. Offenders will be held liable for the payment of damages.
 * All rights reserved in the event of the grant of a patent, utility model or design.
 *
 *************************************************************************************** */
 
 
/*****************************************************************
| includes
|----------------------------------------------------------------*/

#include "CMPListHandlerLogic.h"
#include "ListHandlerTypes.h"
#include "AvdeccClientHandler.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_LOGIC
#define ETG_I_TRACE_CHANNEL     TR_TTFIS_NAVRES1
#include "trcGenProj/Header/CMPListHandlerLogic.cpp.trc.h"
#endif

CMPListHandlerLogic* CMPListHandlerLogic::m_poSelf = NULL;
/************************************************************************
*FUNCTION: 		getInstance()
*DESCRIPTION:   Static Function, Singleton implementation, return the ptr of the
*				Singleton class CMPListHandlerLogic
*PARAMETER:		None
*RETURNVALUE: 	CMPListHandlerLogic*
*History:		Initial version
*************************************************************************/
CMPListHandlerLogic* CMPListHandlerLogic::getInstance()
{
    ETG_TRACE_USR4(("CMPListHandlerLogic::getInstance()"));
   if (NULL == m_poSelf)
   {
      m_poSelf = new CMPListHandlerLogic();
   }
   return m_poSelf;
}
//todo Delete instance to be created
//delete instance to be called in the destructor of the NanoMsgMasterAppService

/************************************************************************
*FUNCTION: 		CMPListHandlerLogic()
*DESCRIPTION:   Constructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Initial version
*************************************************************************/
CMPListHandlerLogic::CMPListHandlerLogic()
{
    ETG_TRACE_USR4(("CMPListHandlerLogic::Constructor"));
}

/************************************************************************
*FUNCTION: 		~CMPListHandlerLogic()
*DESCRIPTION:   Destructor
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Initial version
*************************************************************************/
CMPListHandlerLogic::~CMPListHandlerLogic()
{
    ETG_TRACE_USR4(("CMPListHandlerLogic::Destructor"));
	if(m_poSelf != NULL)
		delete m_poSelf;
}

/************************************************************************
*FUNCTION: 		vDeleteInstance()
*DESCRIPTION:   Static Function, Singleton implementation, Deletes the Singleton Object 
*PARAMETER:		None
*RETURNVALUE: 	None
*History:		Initial version
*************************************************************************/
void CMPListHandlerLogic::vDeleteInstance()
{
   ETG_TRACE_USR4(("CMPListHandlerLogic::vDeleteInstance(), deleting the obj"));
   if (NULL != m_poSelf)
   {  
		delete m_poSelf;
		m_poSelf = NULL;
   }
}


/************************************************************************
*FUNCTION: 		vRequestMediaPlayerListSlice()
*DESCRIPTION:   Thread call back function will be called by parent class 
*				when msg is added to queue to send it to List handler
*PARAMETER:		stWindowSliceRequest
*RETURNVALUE: 	Bool
*History:		Initial version
*************************************************************************/
void CMPListHandlerLogic::vRequestMediaPlayerListSlice(stWindowSliceRequest listData)
{
	ETG_TRACE_USR4(("CMPListHandlerLogic::vRequestMediaPlayerListSlice "));

	// Get the List instance to update the size
	typename listHandlerTypes::mEMPDataMap::iterator listIterator = m_EMPList.find(listData.ListType);
	if(listIterator != m_EMPList.end())
	{
		tclListHandlerInterface* poListInstance  = listIterator->second;
		ETG_TRACE_USR4(("List Created  , List Size %d: ",poListInstance->u16GetTotalListSize() ));
        ETG_TRACE_USR4(("CMPListHandlerLogic::vRequestMediaPlayerListSlice() list source type %d: ",listData.SourceType ));
		if(ZERO != poListInstance->u16GetTotalListSize())
		{
			dbManagerTypes::ItemList curr_ListData = poListInstance->vReqListSlice(listData.startIndex, listData.windowSize, \
                                                                                    listData.SourceType, listData.FolderPath);
            vUpdateListSlice(curr_ListData, listData.ListType);
		}
		else
		{
			ETG_TRACE_ERR(("EMPTY LIST"));
			dbManagerTypes::ItemList Empty_ListData;
			vUpdateListSlice(Empty_ListData, listData.ListType);
		}

	}
	else
	{
		ETG_TRACE_ERR((" LIST NOT EXISITNG "));
		dbManagerTypes::ItemList Empty_ListData;
		vUpdateListSlice(Empty_ListData, listData.ListType);
	}
}

/************************************************************************
*FUNCTION: 		vRequestCreateMediaPlayerList()
*DESCRIPTION:   Thread call back function will be called by parent class 
*				when msg is added to queue to send it to List handler
*PARAMETER:		
*RETURNVALUE: 	Bool
*History:		Initial version
*************************************************************************/
void CMPListHandlerLogic::vRequestCreateMediaPlayerList(const EnumConst::entListType eListType,
													const EnumConst::entSourceType eSourceType,
													const uint8_t u8Region,
													std::string sFolderPath)
{
	ETG_TRACE_USR4(("vRequestCreateMediaPlayerList , eListType : %d ",eListType ));
    EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler* poAvdeccClientHandler= EMP_ListHandler::DbusComponent::EMPServer::AvdeccClientHandler::poGetInstance();
	EnumConst::entDownloadState en_bDBDownloadState;
    if(nullptr != poAvdeccClientHandler)
    {
        en_bDBDownloadState = poAvdeccClientHandler->en_getDBDownloadState(eSourceType);// send sourcetype and get the value from the pair/map
    }
	if(EnumConst::entDownloadState_Downloadsuccess == en_bDBDownloadState)
	{
		ETG_TRACE_USR4(("vRequestCreateMediaPlayerList , en_bDBDownloadState : %d ",en_bDBDownloadState ));
          	vHandleClearListData(eListType,eSourceType,u8Region);
	
                m_enRequestedListSourceType = eSourceType;
                m_u8RequestedListRegion = u8Region;
                m_enRequestedListType = eListType;
          
		//Condition check whether the requested list is already available
		typename listHandlerTypes::mEMPDataMap::iterator listIterator = m_EMPList.find(eListType);
		if(listIterator != m_EMPList.end())
		{
			tclListHandlerInterface* poListInstance  = listIterator->second;
			ETG_TRACE_USR4(("List available , List Size : %d ",poListInstance->u16GetTotalListSize() ));
			vUpdateListCount(poListInstance->u16GetTotalListSize(),poListInstance->eGetListType());//clear old data.

		}
		else
		{
			ETG_TRACE_USR4(("Creating new  List"));
			vCreateListhandlerInstance(m_enRequestedListType);
			vGetListCount(m_enRequestedListType, eSourceType, sFolderPath);
		}
	}
	else
	{
		ETG_TRACE_ERR(("ERROR - DBDownloadState : %d\n", en_bDBDownloadState));
        m_enRequestedListType = eListType;
        vUpdateListCount(0, m_enRequestedListType);
	}
}

/************************************************************************
*FUNCTION:      vUpdateListSlice
*DESCRIPTION:	Update the list slice data to HMI
*PARAMETER:     startindex : window size, EnumConst::entListType enListType
*RETURNVALUE:   NA
*
*HISTORY:
*Rev 0.1 Initial Revision.
***********************************************************************/
void CMPListHandlerLogic::vUpdateListSlice(dbManagerTypes::ItemList& ListData, EnumConst::entListType enListType)
{
	ETG_TRACE_USR4((" CMPListHandlerLogic::vUpdateListSlice List data size() %d",ListData.size()));
	if(ListData.size()>0)
	{
		
		dbManagerTypes::ItemList::iterator itr2;
		dbManagerTypes::ItemList vListData;
		vListData = ListData;
		ETG_TRACE_USR4((" CMPListHandlerLogic::vUpdateListSlice copying to local List data size() %d",vListData.size()));
		for (itr2 = ListData.begin(); itr2 != ListData.end() ; itr2++)
		{
			ETG_TRACE_USR4((" vUpdateListSlice  getFirstString : %s \n",itr2->getFirstString().c_str()));
			ETG_TRACE_USR4((" vUpdateListSlice  getSecondString : %s \n",itr2->getSecondString().c_str()));
			ETG_TRACE_USR4((" vUpdateListSlice  getAbsoluteIndex : %d \n",itr2->getAbsoluteIndex()));
			ETG_TRACE_USR4((" vUpdateListSlice  getVideoLanguage : %d \n",itr2->getVideoLanguage()));
			ETG_TRACE_USR4((" vUpdateListSlice  getFileType : %d \n",itr2->getFileType()));
		} 
		vUpdateMediaPlayerListSlice(vListData, EnumConst::entSourceType_CMP, enListType);
	}
	else
	{
		ETG_TRACE_USR4((" CMPListHandlerLogic:: vUpdateListSlice empty list"));
		vUpdateMediaPlayerListSlice(ListData, EnumConst::entSourceType_CMP, enListType);
	}
}