/* ***************************************************************************************
* FILE:          EmpListDbusService.cpp
* SW-COMPONENT: EMP_ListHandler
* DESCRIPTION:  EmpListDbusService.cpp is the application initialization class
* COPYRIGHT:  (c) 2020-2021 Robert Bosch Car Multimedia GmbH
* Author: Madhuree
* Date: 20/07/2020
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
****************************************************************************************/


#include "EmpListDbusService.h"
#include "tClAlbumArt.h"
#include "../../TTFisCmd/EmpListTTFisCmd.h"
#include "EMPFactory.h"

/* Header files required for Tracing out log statements */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_ASF
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES1
#include "trcGenProj/Header/EmpListDbusService.cpp.trc.h"
#endif

namespace EMP_ListHandler  {
	namespace DbusComponent {
		namespace EMPServer {


/************************************************************************
*FUNCTION: 		EmpListDbusService()
*DESCRIPTION: 	Constructor of the EmpListDbusService Class, Entry point to the Service,
*				Called by the ASF Main
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	
************************************************************************/
EmpListDbusService::EmpListDbusService()
{
	vInitPlatformEtg();
	bool bSendSdnotify = TRUE;
        ETG_TRACE_USR4(("EmpListDbusService::EmpListDbusService"));
    if(NULL == EMPFactory::getEmpFactoryReference())
	{
		ETG_TRACE_USR4(("EMPFactory::getEmpFactoryReference() Failed to create"));
        bSendSdnotify = FALSE;;
	}

	//Create the ASF EMPListHmi ServiceAdaptor Instance
	if (NULL == clAsfEmpListHmiServiceAdaptor::getInstance())
	{
		ETG_TRACE_USR4(("AsfEmpListHmiServiceAdaptor::getInstance() Failed to create"));
		bSendSdnotify = FALSE;
	}
         
    //Create the Avdecc client Instance
        _avdeccClientHandler = AvdeccClientHandler::poGetInstance();
    

    //Create the tClAlbumArt Instance
    if ( NULL == tClAlbumArt::poGetInstance() )
    {
       ETG_TRACE_USR4(("tClAlbumArt::poGetInstance() Failed to create"));
	   bSendSdnotify = FALSE;
    }  
     
    EmpListTTFisCmd::initialize();
    
	if (!bSendSdnotify)
	{
		//ETG_TRACE_FATAL(("bSendSdnotify is TRUE, Hence restart the Service"));
		//exit(-1); //to be commented out when we enable sd_notify
		//sd_notify(0, "ERRNO=2"); // No tested so far, so commented out
	}

	else {
		//ETG_TRACE_USR4(("Sending sd_notify Ready!"));

		//object of sender thread instance
		/* 		sd_notifyf(0, "READY=1\n" // Tells the init system that daemon startup is finished.
		// This is only used by systemd if the service definition file has Type=notify set.
		"STATUS=Processing requests...\n" // Passes a single-line status string back to the init system that describes the daemon state.
		// This is free-form and can be used for various purposes
		"MAINPID=%lu\nPARENTID=%lu",
		(unsigned long)getpid(),
		(unsigned long)getppid() ); */
	}
	//todo: reciever thread of core module and sender thread of core module;

}

/************************************************************************
*FUNCTION: 		~EmpListDbusService()
*DESCRIPTION: 	Destructor of the EmpListDbusService Class, Exit point to the Service,
*				Called by the ASF Main
*PARAMETER:		None
*RETURNVALUE: 	None
*HISTORY:
*revision 0.1	Madhuree
*************************************************************************/
EmpListDbusService::~EmpListDbusService()
{
	
	clAsfEmpListHmiServiceAdaptor::vDeleteInstance();
}
}
}
}//Namespace
