/* ***************************************************************************************
* FILE:          AsfEmpListHmiServiceAdaptor.h
* SW-COMPONENT:  DI_MIDDLEWARE_SERVER
 * DESCRIPTION:  AsfEmpListHmiServiceAdaptor.h is part of EMPListHMI DBUSsevrer
 * COPYRIGHT:  (c) 2020-21 Robert Bosch Car Multimedia GmbH
 * Author: Madhuree
 * Date: 20.07.2020
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef ASFEMPLISTHMISERVICEADAPTOR_H
#define ASFEMPLISTHMISERVICEADAPTOR_H

#include "HmiEmpListInterfaceStub.h"
#include "HmiEmpListInterfaceConst.h"
#include "ListHandlerLogic.h"
#include "clListHandlerCoreThread.h"
#include "EMPFactory.h"

using namespace ::bosch::cm::di::HmiEmpListInterface;

namespace EMP_ListHandler {
	namespace DbusComponent {
           namespace EMPServer {

		class clAsfEmpListHmiServiceAdaptor :  public HmiEmpListInterfaceStub
		{
		public:
			static clAsfEmpListHmiServiceAdaptor* getInstance();
			static clAsfEmpListHmiServiceAdaptor *p_AsfEmpListHmiInstance;
			static void vDeleteInstance();

			virtual ~clAsfEmpListHmiServiceAdaptor();

			//Method Start Messages
			virtual void onListSizeGet(const ::boost::shared_ptr< ListSizeGet >& payload);
			virtual void onReqMediaPlayerListSliceRequest (const ::boost::shared_ptr< ReqMediaPlayerListSliceRequest >& request);
			virtual void onReqMediaPlayerFolderListSliceRequest (const ::boost::shared_ptr< ReqMediaPlayerFolderListSliceRequest >& request);
			virtual void onReqCreateMediaPlayerListRequest (const ::boost::shared_ptr< ReqCreateMediaPlayerListRequest >& request);
			virtual void onReqCreateMediaPlayerFolderListRequest (const ::boost::shared_ptr< ReqCreateMediaPlayerFolderListRequest >& request);
            virtual void onReqDBDownloadRequest (const ::boost::shared_ptr< ReqDBDownloadRequest >& request);
            virtual void onSetMediaVideoLanguagesListRequest (const ::boost::shared_ptr< SetMediaVideoLanguagesListRequest >& request);
			//Broadcast Messages
			void sendSig_DBStateSignal(bosch::cm::di::HmiEmpListInterface::entDownloadState downloadState, bosch::cm::di::HmiEmpListInterface::entSourceType sourceType);
			void sendSig_AlbumArtStateSignal(bosch::cm::di::HmiEmpListInterface::entDownloadState downloadState, uint16 songId);
			void UpdateMediaPlayerListSliceResponse(dbManagerTypes::ItemList vecListData, const EnumConst::entSourceType eSourceType, EnumConst::entListType enListType);

			void setListSize(const uint16_t u16count, EnumConst::entListType enRequestedListType, \
                    EnumConst::entSourceType enRequestedListSourceType, uint8_t u8RequestedListRegion);
			void vSendSig_PlayableFlagSignal(bool isPlayableAudio, bool isPlayableVideo,  bosch::cm::di::HmiEmpListInterface::entSourceType sourceType );
            void vSendsig_CurrentTrackInfoSignal(bosch::cm::di::HmiEmpListInterface::entSourceType enSourceType, bosch::cm::di::HmiEmpListInterface::entListType enListType, \
                                                uint8 u8_Region, uint16 songId,  std::string sFolderPath);
            std::vector<uint16> vecGetSelectedLanguages(EnumConst::entSourceType enSourceType);
            void vReadDataPools();
            void vClearSelectedLanguages(EnumConst::entSourceType enSourceType);
            void setSelectedLanguages_CMRSize(uint16 Languages_CMRSize);
            uint16 getSelectedLanguages_CMRSize();
            void setSelectedLanguages_CMPSize(uint16 Languages_CMPSize);
            uint16 getSelectedLanguages_CMPSize();
            void RenameifInvalidUTF8isFound(std::string &Name);

		private:
			clAsfEmpListHmiServiceAdaptor();
            EMPFactory* m_poEmpFactory;
            map <EnumConst::entSourceType, std::vector<uint16>> mapSelectedLanguageIds;

		};
	}//Namespace  EMP_ListHandler
}
}
#endif // ASFEMPLISTHMISERVICEADAPTOR_H
