#include "AvdeccClientHandler.h"
#include "AsfEmpListHmiServiceAdaptor.h"
#include "TFTPClientBase.h"
#include "ListHandlerLogic.h"

#define PLUGIN_DBUS_PORT "PluginDbusServerPort"

/* Header files required for Tracing out log statements */
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_ASF
#include "trcGenProj/Header/AvdeccClientHandler.cpp.trc.h"
#endif


using namespace asf::core;
using namespace ::bosch::cm::ai::PluginDbusInterface;

namespace EMP_ListHandler {
	namespace DbusComponent {
           namespace EMPServer {

AvdeccClientHandler* AvdeccClientHandler::m_poSelfAvdeccClientHandler = NULL;

AvdeccClientHandler* AvdeccClientHandler::poGetInstance()
{
   /* No more than one instance of AvdeccClientHandler should be created */
   ETG_TRACE_USR4(("AvdeccClientHandler::poGetInstance()"));
   if (NULL == m_poSelfAvdeccClientHandler)
   {
      m_poSelfAvdeccClientHandler = new AvdeccClientHandler();
   }
   return m_poSelfAvdeccClientHandler;
}

AvdeccClientHandler::AvdeccClientHandler()
   : m_poPluginDbusProxy(PluginDbusInterfaceProxy::createProxy(PLUGIN_DBUS_PORT, *this))
{
   ETG_TRACE_USR4(("AvdeccClientHandler Constructor is called"));
   m_poAlbumArt = tClAlbumArt::poGetInstance();
   m_poEmpFactory = EMPFactory::getEmpFactoryReference();
   poSelectQueryDAO = SelectQueryDAO::getInstance();
   mapSourceData[EnumConst::entSourceType_CMP] = {EnumConst::entDbState_Unknown, EnumConst::entDownloadState_Default, false, false};
   mapSourceData[EnumConst::entSourceType_CMR] = {EnumConst::entDbState_Unknown, EnumConst::entDownloadState_Default, false, false};
   mapPlayBackModeData[EnumConst::enSubSourceType_CMP_AUDIO] = {EnumConst::Repeat_Off, REGION_DEFAULT_INVALID};
   mapPlayBackModeData[EnumConst::enSubSourceType_CMP_VIDEO] = {EnumConst::Repeat_Off, REGION_DEFAULT_INVALID};
   mapPlayBackModeData[EnumConst::enSubSourceType_CMR_AUDIO] = {EnumConst::Repeat_Off, REGION_DEFAULT_INVALID};
   mapPlayBackModeData[EnumConst::enSubSourceType_CMR_VIDEO] = {EnumConst::Repeat_Off, REGION_DEFAULT_INVALID};
}

AvdeccClientHandler::~AvdeccClientHandler()
{
   ETG_TRACE_USR4(("AvdeccClientHandler destructor is called"));
   if (NULL != m_poSelfAvdeccClientHandler)
   {
      delete m_poSelfAvdeccClientHandler;
      m_poSelfAvdeccClientHandler = NULL;
   }
}

void AvdeccClientHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::onAvailable()"));
   if (m_poPluginDbusProxy && m_poPluginDbusProxy == proxy)
   {
      m_poPluginDbusProxy->sendSig_PlayStatusRegister(*this);
      m_poPluginDbusProxy->sendSig_DBStatusRegister(*this);  
      m_poPluginDbusProxy->sendDBStateRegister(*this);
      m_poPluginDbusProxy->sendSig_ReqTrackIndexRegister(*this);
      m_poPluginDbusProxy->sendSig_CRCCheckStatusRegister(*this);
      m_poPluginDbusProxy->sendPlayBackModeRegister(*this);
      m_poPluginDbusProxy->sendDBStateGet(*this);
	  
   }
}

void AvdeccClientHandler::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::onUnavailable()"));
   if (m_poPluginDbusProxy.get() && m_poPluginDbusProxy == proxy)
   {
      m_poPluginDbusProxy->sendSig_PlayStatusDeregisterAll();
      m_poPluginDbusProxy->sendSig_DBStatusDeregisterAll();
      m_poPluginDbusProxy->sendSig_ReqTrackIndexDeregisterAll();
      m_poPluginDbusProxy->sendDBStateDeregisterAll();
      m_poPluginDbusProxy->sendSig_CRCCheckStatusDeregisterAll();
      m_poPluginDbusProxy->sendPlayBackModeDeregisterAll();
   }
}


void AvdeccClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("AvdeccClientHandler register property is called"));
}


void AvdeccClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("AvdeccClientHandler deregister property is called"));
}




void AvdeccClientHandler::onSig_PlayStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayStatusError >& error)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusError "));
}


void AvdeccClientHandler::onSig_PlayStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_PlayStatusSignal >& signal)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal "));
    Sig_PlayStatusSignalPlayStateStruct PlayStateStruct = signal->getPlayState();
    EnumConst::entPlayState playstatus = static_cast <EnumConst::entPlayState > ( PlayStateStruct.getElem1() ); 
    EnumConst::entSourceType sourceType= static_cast < EnumConst::entSourceType > ( PlayStateStruct.getElem2() );
    uint16 songId = PlayStateStruct.getElem3();
    EnumConst::entFileType enFileType = static_cast < EnumConst::entFileType > ( PlayStateStruct.getElem4() );
    EnumConst::entListType enListType = static_cast<EnumConst::entListType>(PlayStateStruct.getElem5());
    uint16 SubListFilter1 = PlayStateStruct.getElem6();
    uint16 SubListFilter2 = PlayStateStruct.getElem7();
    std::string FolderPath = PlayStateStruct.getElem8();
    tclListHandlerLogic* poListHandlerLogic = NULL;

    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal playstatus: %d", playstatus));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal sourceType: %d", sourceType));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal songId: %d", songId));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal ListType: %d", enListType));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal Sublist Filter1: %d", SubListFilter1));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal Sublist Filter2: %d", SubListFilter2));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal FolderPath: %s", FolderPath.c_str()));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_PlayStatusSignal FileType: %d", enFileType));
    if(NULL != m_poEmpFactory)
    {
         ETG_TRACE_USR4(("AvdeccClientHandler:: vCurrentTrackIndexUpdate %d ",songId));
         tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(sourceType);
         if(poListHandlerLogic != NULL)
         {
             poListHandlerLogic->vCurrentListTypeUpdate(enListType);
             poListHandlerLogic->vCurrentTrackIndexUpdate(songId, enFileType);
    
             //Send trackinfo to HMI
             EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor *poHMIServiceAdaptor = EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor::getInstance();
             if(nullptr != poHMIServiceAdaptor)
             {
             poHMIServiceAdaptor->vSendsig_CurrentTrackInfoSignal(static_cast <bosch::cm::di::HmiEmpListInterface::entSourceType>(sourceType), \
                                  static_cast <bosch::cm::di::HmiEmpListInterface::entListType>(enListType), \
                                  poListHandlerLogic->u8GetRegion(), songId, FolderPath);
             }
         }
     }

    if (playstatus == EnumConst::entPlayState_PlaySuccess)
    {
        if( m_poAlbumArt != NULL)
        {
            //ETG_TRACE_USR4(("AvdeccClientHandler:: send vSetTrackDetails "));
            m_poAlbumArt->vSetTrackDetails(sourceType,songId,enFileType);
        }
    }
}

void AvdeccClientHandler::onSig_DBStatusSignal(const ::boost::shared_ptr<PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStatusSignal >& signal)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::onSig_DBStatusSignal"));
   EnumConst::entDbState dbState = static_cast < EnumConst::entDbState > ( signal->getDbState() ); 
   EnumConst::entSourceType sourceType= static_cast <EnumConst::entSourceType> ( signal->getSourceType() ); 
   ETG_TRACE_USR4(("AvdeccClientHandler::onSig_DBStatusSignal(), sourcetype is:%d,Dbstate is :%d",sourceType,dbState));

  // vUpdateDBAvialabilityStatus(dbState,sourceType);
}


void AvdeccClientHandler::onSig_DBStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_DBStatusError >& error)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::onSig_DBStatusError"));
}

void AvdeccClientHandler::vsetListAbsoluteTrackIndex(bool isTrackIndexAvailable, uint32_t listAbsTrackIndex, uint16_t srcType, uint16_t FileType)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::setListAbsoluteTrackIndex(), absoulte index from list is :%d",listAbsTrackIndex));
    ListAbsoluteTrackIndexStruct mListAbsoluteTrackIndexStruct;
    if(isTrackIndexAvailable)
    {
        mListAbsoluteTrackIndexStruct.setElem1 ( listAbsTrackIndex );
        mListAbsoluteTrackIndexStruct.setElem2 ( srcType );
        mListAbsoluteTrackIndexStruct.setElem3 ( FileType );
        if(NULL != m_poPluginDbusProxy)
        {
            m_poPluginDbusProxy->sendListAbsoluteTrackIndexSet( mListAbsoluteTrackIndexStruct );
        }
    }
    else
    {
        ETG_TRACE_USR4(("AvdeccClientHandler::setListAbsoluteTrackIndex() Failed to fetch track index"));
        mListAbsoluteTrackIndexStruct.setElem1 ( TRACKINDEX_UNAVAILABLE );
        mListAbsoluteTrackIndexStruct.setElem2 ( srcType );
        if(NULL != m_poPluginDbusProxy)
        {
            m_poPluginDbusProxy->sendListAbsoluteTrackIndexSet( mListAbsoluteTrackIndexStruct );
        }
    }
}

void AvdeccClientHandler::onDBStateUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< DBStateUpdate >& update)
{
  ETG_TRACE_USR4(("AvdeccClientHandler::onDBStateUpdate "));
   DBStateStruct DBStruct = update->getDBState ();
   EnumConst::entDbState dbState = static_cast < EnumConst::entDbState > (DBStruct.getElem1() ); 
   EnumConst::entSourceType sourceType= static_cast <EnumConst::entSourceType> (DBStruct.getElem2() ); 
   ETG_TRACE_USR4(("AvdeccClientHandler::onDBStateUpdate(), sourcetype is:%d,Dbstate is :%d",sourceType,dbState));
   vUpdateDBAvialabilityStatus(dbState,sourceType);
}

void AvdeccClientHandler::onDBStateError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< DBStateError >& error)
{
  ETG_TRACE_USR4(("AvdeccClientHandler::onDBStateError"));
}

void AvdeccClientHandler::onSig_ReqTrackIndexError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_ReqTrackIndexError >& error)
{
	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexError"));
}

void AvdeccClientHandler::onSig_ReqTrackIndexSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_ReqTrackIndexSignal >& signal)
{
	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal"));

	//signal to update EMP_ListHandler to update the next,previous or current TrackIndex
	Sig_ReqTrackIndexSignalTrackReqInfoStruct TrackReqInfoStruct= signal->getTrackReqInfo();

	uint8_t l_u8TrackIndexAction = TrackReqInfoStruct.getElem1();
    EnumConst::entSourceType enSourceType = static_cast <EnumConst::entSourceType> ( TrackReqInfoStruct.getElem2() ); 
	uint16_t srcType = TrackReqInfoStruct.getElem2() ;
    EnumConst::entListType enListType = static_cast<EnumConst::entListType>(TrackReqInfoStruct.getElem3());
    uint16 SubListFilter1 = TrackReqInfoStruct.getElem4();
    uint16 SubListFilter2 = TrackReqInfoStruct.getElem5();
    uint32_t u32_Position = TrackReqInfoStruct.getElem6();
	uint8_t u8_Region = TrackReqInfoStruct.getElem7();
    std::string FolderPath = TrackReqInfoStruct.getElem8();

	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal TrackIndexAction: %d", l_u8TrackIndexAction));
	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal: sourceType: %d", srcType));
	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal: ListType: %d", enListType));
	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal: Position: %d", u32_Position));
	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal: Region: %d", u8_Region));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal Sublist Filter1: %d", SubListFilter1));
    ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal Sublist Filter2: %d", SubListFilter2));
	ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal: FolderPath: %s", FolderPath.c_str()));

    bool isRequestValid = true;
    if((enSourceType == EnumConst::entSourceType_DEFAULT) || (enListType == EnumConst::entListType_Invalid))
    {
        ETG_TRACE_USR4(("AvdeccClientHandler::onSig_ReqTrackIndexSignal: Error!! Invalid Request"));
        isRequestValid = false;
        vsetListAbsoluteTrackIndex(false, TRACKINDEX_UNAVAILABLE, srcType, static_cast<uint16_t>(EnumConst::entFileType_unknown));
    }

    if(NULL != m_poEmpFactory && isRequestValid)
    {
        if (static_cast<int>(entDownloadState_Downloadsuccess) == mapSourceData[enSourceType].en_DBDownloadState && mapSourceData[enSourceType].m_bIsDBInit)
        {
            tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(enSourceType);
            if(poListHandlerLogic != NULL)
            {
                poListHandlerLogic->vRequestTrackIndex(l_u8TrackIndexAction, srcType, enListType, FolderPath, u8_Region);
            }
        }
    }
}

void AvdeccClientHandler::onSig_CRCCheckStatusError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CRCCheckStatusError >& error)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::onSig_CRCCheckStatusError "));
}


void AvdeccClientHandler::onSig_CRCCheckStatusSignal(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_CRCCheckStatusSignal >& signal)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::onSig_CRCCheckStatusSignal "));
   EnumConst::entSourceType enSourceType = static_cast < EnumConst::entSourceType > ( signal->getSourceType() );
   mapSourceData[enSourceType].m_bCRCStatus = signal->getCRCStatus(); 
   ETG_TRACE_USR4(("AvdeccClientHandler:: CRCStatus  %d ", signal->getCRCStatus())); 
   ETG_TRACE_USR4(("AvdeccClientHandler:: SourceType  %d ", enSourceType)); 
   if(!(mapSourceData[enSourceType].m_bCRCStatus))
   {
        ETG_TRACE_USR4(("AvdeccClientHandler::onSig_CRCCheckStatusSignal clear datapools and members"));
        EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor *poHMIServiceAdaptor = EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor::getInstance();
        if(nullptr != poHMIServiceAdaptor)
        {
            poHMIServiceAdaptor->vClearSelectedLanguages(enSourceType);
        }
   }
}

void AvdeccClientHandler::vUpdateDBAvialabilityStatus(const EnumConst::entDbState eDBAvailStatus , const EnumConst::entSourceType enSourceType)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBAvialabilityStatus()"));
	mapSourceData[enSourceType].en_DBAvailability = eDBAvailStatus;
	ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBAvialabilityStatus() SourceType is : %d, DBstate is:%d",enSourceType, eDBAvailStatus));
	if ((EnumConst::entDownloadState_Downloadsuccess == mapSourceData[enSourceType].en_DBDownloadState) \
		 && ( ((enSourceType == EnumConst::entSourceType_CMP) \
				   && ((EnumConst::entDbState_DBInvalid == eDBAvailStatus) || (EnumConst::entDbState_USBDisconnected == eDBAvailStatus))) \
			   || ((enSourceType == EnumConst::entSourceType_CMR) \
				   && ((static_cast <EnumConst::entDbState> (CMR_INVALID_DB_STATE) == eDBAvailStatus) || (static_cast <EnumConst::entDbState> (CMR_INPREPARATION_DB_STATE) == eDBAvailStatus))) ) \
	   )
	{
		if(nullptr != m_poEmpFactory)
		{
			ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBAvialabilityStatus() DB remove request"));
			//deinit DB
            if(mapSourceData[enSourceType].m_bIsDBInit == true)
            {
                if(nullptr != poSelectQueryDAO)
                {
                    bool bDeInitReturnStatus = poSelectQueryDAO->deinit(static_cast < eSourceType >(enSourceType));
                    if(bDeInitReturnStatus)
                    {
                        mapSourceData[enSourceType].m_bIsDBInit = false;
                    }
                }
            }
			TFTPClientBase* poTftpClient = m_poEmpFactory->getTFTPClientreference(enSourceType);
            if(poTftpClient != NULL)
            {
                poTftpClient->RemoveDBFile(enSourceType);
                //clear listhandler members related to playback mode
                  tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(enSourceType);
                  if(poListHandlerLogic != NULL)
                  {
                      poListHandlerLogic->vClearShuffleList();
                      poListHandlerLogic->vClearFirstAndLastTrackIndex();
                  }
            }
            
			mapSourceData[enSourceType].en_DBDownloadState = EnumConst::entDownloadState_Default;
            mapSourceData[enSourceType].m_bIsDBInit = false;
            vUpdateDBDownloadState(mapSourceData[enSourceType].en_DBDownloadState, enSourceType);
		}
	}
    else if(  (EnumConst::entDbState_DBValid == eDBAvailStatus || EnumConst::entDbState_Same_USB_Drive == eDBAvailStatus ) && ( enSourceType == EnumConst::entSourceType_CMP  ) )
    {
		ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBAvialabilityStatus() DB  request for dbstate %d ", eDBAvailStatus ));
        bRequestDBDownload(enSourceType);
    }	
	else if ( enSourceType == EnumConst::entSourceType_CMR && eDBAvailStatus == static_cast <EnumConst::entDbState> (CMR_VALID_DB_STATE) )
	{
		ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBAvialabilityStatus() DB request for CMR"));
		bRequestDBDownload(enSourceType);
	}
	else
	{
	}
	

}

void AvdeccClientHandler::bRequestDBDownload(EnumConst::entSourceType enSourceType)
{
	ETG_TRACE_USR4(("AvdeccClientHandler::bRequestDBDownload()"));

    ETG_TRACE_USR4(("AvdeccClientHandler::bRequestDBDownload() DBDownloadState : %d\n", mapSourceData[enSourceType].en_DBDownloadState));
	/*TODO:BAE2COB -OPL: Need to check other download cases whether redownload DB allowed ?*/
	if(EnumConst::entDownloadState_ReqInProgress != mapSourceData[enSourceType].en_DBDownloadState)
	{
		if(nullptr != m_poEmpFactory)
		{
			/* Invoking method to start DB download from TFTP server */
			mapSourceData[enSourceType].en_DBDownloadState = EnumConst::entDownloadState_ReqInProgress;
			ETG_TRACE_USR4(("AvdeccClientHandler::bRequestDBDownload() DBDownloadState : %d\n", mapSourceData[enSourceType].en_DBDownloadState));
			TFTPClientBase* poTftpClient = m_poEmpFactory->getTFTPClientreference(enSourceType);
            if(poTftpClient != NULL)
            {
                mapSourceData[enSourceType].en_DBDownloadState = poTftpClient->reqDBDownload(enSourceType);
            }
		}
	} //download failure is not handled

    ETG_TRACE_USR4(("AvdeccClientHandler::bRequestDBDownload() DBDownloadState : %d\n", mapSourceData[enSourceType].en_DBDownloadState));
    vUpdateDBDownloadState(mapSourceData[enSourceType].en_DBDownloadState, enSourceType); //Update to HMI
}

void AvdeccClientHandler::vUpdateDBDownloadState(const EnumConst::entDownloadState enState,EnumConst::entSourceType enSourceType)
{
	ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBDownloadState"));
	ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBDownloadState enSourceType  : %d", enSourceType));
	ETG_TRACE_USR4(("AvdeccClientHandler::vUpdateDBDownloadState DBDownloadState : %d", enState));

	if(EnumConst::entDownloadState_Downloadsuccess == enState)
	{
        //init DB
        if(mapSourceData[enSourceType].m_bIsDBInit == false)
	    {
	    	if(nullptr != poSelectQueryDAO)
	    	{
	    		mapSourceData[enSourceType].m_bIsDBInit = poSelectQueryDAO->init(static_cast < eSourceType >(enSourceType));
                if(mapSourceData[enSourceType].m_bIsDBInit)
                {
                    //check for playable item
                    vCheckPlayableItem(enSourceType);
                }
            }
	    }
	}

	EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor *poHMIServiceAdaptor = EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor::getInstance();
	if(nullptr != poHMIServiceAdaptor)
	{
		poHMIServiceAdaptor->sendSig_DBStateSignal(static_cast<bosch::cm::di::HmiEmpListInterface::entDownloadState>(enState), static_cast<bosch::cm::di::HmiEmpListInterface::entSourceType>(enSourceType));
	}
	
}

void AvdeccClientHandler::vCheckPlayableItem(EnumConst::entSourceType enSourceType)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::vCheckPlayableItem()"));
    pair<bool,eSourceType> isPlayableAudio  {};
    pair<bool,eSourceType> isPlayableVideo  {};
    if(nullptr != poSelectQueryDAO)
    {
       isPlayableVideo = poSelectQueryDAO->hasPlayableVideoItem(static_cast <eSourceType > (enSourceType));
       isPlayableAudio = poSelectQueryDAO->hasPlayableAudioItem(static_cast <eSourceType > (enSourceType));
    }
    EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor *poHMIServiceAdaptor = EMP_ListHandler::DbusComponent::EMPServer::clAsfEmpListHmiServiceAdaptor::getInstance();
    if(nullptr != poHMIServiceAdaptor)
    {
       poHMIServiceAdaptor->vSendSig_PlayableFlagSignal( isPlayableAudio.first, isPlayableVideo.first , static_cast <bosch::cm::di::HmiEmpListInterface::entSourceType> (enSourceType) );
    }
}

EnumConst::entDbState AvdeccClientHandler::en_getDBAvailability(EnumConst::entSourceType enSourceType)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::en_getDBAvailability Sourcetype: %d", enSourceType));
   ETG_TRACE_USR4(("AvdeccClientHandler::en_getDBAvailability DBAvailability: %d", mapSourceData[enSourceType].en_DBAvailability));
   return mapSourceData[enSourceType].en_DBAvailability;
}

EnumConst::entDownloadState AvdeccClientHandler::en_getDBDownloadState(EnumConst::entSourceType enSourceType)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::en_getDBDownloadState Sourcetype: %d", enSourceType));
   ETG_TRACE_USR4(("AvdeccClientHandler::en_getDBDownloadState DBDownloadState: %d", mapSourceData[enSourceType].en_DBDownloadState));
    return mapSourceData[enSourceType].en_DBDownloadState;
}

bool AvdeccClientHandler::bgetCRCStatus(EnumConst::entSourceType enSourceType)
{
   ETG_TRACE_USR4(("AvdeccClientHandler::bgetCRCStatus Sourcetype: %d", enSourceType));
   ETG_TRACE_USR4(("AvdeccClientHandler::bgetCRCStatus CRCStatus: %d", mapSourceData[enSourceType].m_bCRCStatus));
    return mapSourceData[enSourceType].m_bCRCStatus;
}

void AvdeccClientHandler::onPlayBackModeError(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PlayBackModeError >& error)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::onPlayBackModeError"));
}

void AvdeccClientHandler::onPlayBackModeUpdate(const ::boost::shared_ptr< PluginDbusInterfaceProxy >& proxy, const ::boost::shared_ptr< PlayBackModeUpdate >& update)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::onPlayBackModeUpdate"));
    PlayBackModeStruct stPlayBackMode = update->getPlayBackMode();
    EnumConst::enPlayback_Modes enPlayMode = static_cast <EnumConst::enPlayback_Modes>(stPlayBackMode.getElem1());
    EnumConst::entSourceType enSourceType = static_cast <EnumConst::entSourceType>(stPlayBackMode.getElem2());
    uint16_t u16Region = stPlayBackMode.getElem3();
    EnumConst::enSubSourceType enSubSource = static_cast <EnumConst::enSubSourceType>(stPlayBackMode.getElem4());
    
    if((mapPlayBackModeData[enSubSource].enPlayBackMode == EnumConst::Shuffle_List) && (enPlayMode != EnumConst::Shuffle_List))
    {
            tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(enSourceType);
            if(poListHandlerLogic != NULL)
            {
                poListHandlerLogic->vClearShuffleList();
            }
    }
    if(((mapPlayBackModeData[enSubSource].enPlayBackMode == EnumConst::Repeat_List) && (enPlayMode != EnumConst::Repeat_List)) 
        || ((mapPlayBackModeData[enSubSource].enPlayBackMode == EnumConst::Repeat_Track) && (enPlayMode != EnumConst::Repeat_Track)))
    {
            tclListHandlerLogic* poListHandlerLogic = m_poEmpFactory->getListHandlerLogicReference(enSourceType);
            if(poListHandlerLogic != NULL)
            {
                poListHandlerLogic->vClearFirstAndLastTrackIndex();
            }
    }

    mapPlayBackModeData[enSubSource].enPlayBackMode = enPlayMode;
    mapPlayBackModeData[enSubSource].Region = u16Region;
    mapPlayBackModeData[enSubSource].enSource = enSourceType;

    ETG_TRACE_USR4(("AvdeccClientHandler::onPlayBackModeUpdate PlayBackMode: %d", mapPlayBackModeData[enSubSource].enPlayBackMode));
    ETG_TRACE_USR4(("AvdeccClientHandler::onPlayBackModeUpdate SourceType: %d", enSourceType));
    ETG_TRACE_USR4(("AvdeccClientHandler::onPlayBackModeUpdate Region: %d", mapPlayBackModeData[enSubSource].Region));
}

EnumConst::enPlayback_Modes AvdeccClientHandler::enGetPlayBackMode(EnumConst::enSubSourceType en_SubSource_Type)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::enGetPlayBackMode Sourcetype: %d", en_SubSource_Type));
    ETG_TRACE_USR4(("AvdeccClientHandler::enGetPlayBackMode PlayBackMode: %d", mapPlayBackModeData[en_SubSource_Type].enPlayBackMode));
    return mapPlayBackModeData[en_SubSource_Type].enPlayBackMode;
}

void AvdeccClientHandler::enSetPlayBackMode(EnumConst::enPlayback_Modes enPlayMode, 
                    uint16_t u16Region, EnumConst::entSourceType enSourceType, EnumConst::enSubSourceType enSubSource)
{
    ETG_TRACE_USR4(("AvdeccClientHandler::enSetPlayBackMode "));
    mapPlayBackModeData[enSubSource].enPlayBackMode = enPlayMode;
    mapPlayBackModeData[enSubSource].Region = u16Region;
    mapPlayBackModeData[enSubSource].enSource = enSourceType;
}

}
}
}
