/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : SelectQueryDAO.cpp
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 7.07.2020
 * Revision History    : 1.0
 * Date 24.07.2020     : Initial version
 *
*/

#include <SelectQueryDAO.h>
#include <iostream>
using namespace std;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_DBMANAGER
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES1
#include "trcGenProj/Header/SelectQueryDAO.cpp.trc.h" // cpp filename.cpp.trc.h
#endif


SelectQueryDAO* SelectQueryDAO::m_SelectQueryDAO = nullptr;


/*! ***********************************************************************
 *FUNCTION: 		SelectQueryDAO
 *@details: 		Constr
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		NA
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee		Reviewed
 ************************************************************************/
SelectQueryDAO::SelectQueryDAO()
{
    ETG_TRACE_USR4(("SelectQueryDAO::SelectQueryDAO"));
}

/*! ***********************************************************************
 *FUNCTION: 		SelectQueryDAO
 *@details: 		Destructor
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		NA
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee		Reviewed
 ************************************************************************/
SelectQueryDAO::~SelectQueryDAO()
{
    ETG_TRACE_USR4(("SelectQueryDAO::~SelectQueryDAO"));
    m_SelectQueryDAO = nullptr;
}


/*! ***********************************************************************
 *FUNCTION: 		getListCount
 *@details: 		get the List count
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		NA
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee		Reviewed
 ************************************************************************/
bool SelectQueryDAO::getListCount ( sRequestCount& vRequestCount, uint16_t& count )
{
    ETG_TRACE_USR4(("SelectQueryDAO::getListCount size %d ", vRequestCount.getLang().size()));
    bool status = false;

    // when language vector is empty HMI needs to display all the languages to handle
    // that below implementation
    if ( vRequestCount.getType() == entListType_Video && vRequestCount.getLang().empty() )
    {
        vRequestCount.setType ( entListType_Video_NoFilter );
        ETG_TRACE_USR4(("SelectQueryDAO::getListCount listType entListType_Video_NoFilter"));
    }

    string query = QueryManager::getInstance()->getSqlQueryCount ( vRequestCount );

    status = QueryManager::getInstance()->prepareQuery ( query, vRequestCount.getSourceType() );

    status = status ? QueryManager::getInstance()->prepareQueryCount ( vRequestCount ) : false;

    status = status ? QueryManager::getInstance()->fetchCount ( count, vRequestCount.getSourceType() ) : false ;

    ETG_TRACE_USR4(("SelectQueryDAO::getListCount and count is %d", count));

    return status ;
}

/*! ***********************************************************************
 *FUNCTION: 		getWindowListSliced
 *@details: 		get the window list
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

bool SelectQueryDAO::getWindowListSliced ( sRequestMessage& vRequestMessage, ItemList& vItemList )
{
    ETG_TRACE_USR4(("SelectQueryDAO::getWindowListSliced"));
    ETG_TRACE_USR4(("SelectQueryDAO::getListCount size %d ", vRequestMessage.getLang().size()));
    bool status = false;


    // when language vector is empty HMI needs to display all the languages to handle
    // that below implementation
    if ( vRequestMessage.getType() == entListType_Video && vRequestMessage.getLang().empty() )
    {
        vRequestMessage.setType ( entListType_Video_NoFilter );
        ETG_TRACE_USR4(("SelectQueryDAO::getWindowListSliced listType entListType_Video_NoFilter"));
    }

    string query = QueryManager::getInstance()->getSqlQuery ( vRequestMessage );

    status = QueryManager::getInstance()->prepareQuery ( query, vRequestMessage.getSourceType() );

    status = status ? QueryManager::getInstance()->prepareQueryData ( vRequestMessage ) : false;

    status = status ? QueryManager::getInstance()->fetchResult ( vItemList, vRequestMessage.getSourceType(), vRequestMessage.getType()  ) : false ;


    ETG_TRACE_USR4(("SelectQueryDAO::getWindowListSliced and size is %d", vItemList.size() ));
    return status ;
}

/*! ***********************************************************************
 *FUNCTION: 		getNextPreviousSongId
 *@details: 		get the song Id of next and previous song/video
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

bool SelectQueryDAO::getNextPreviousSongId ( sRequestSongId& vRequestSongId, sResponseSongInfo& vResponseSongInfo )
{
    ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId [ Csongid  %d  listtype %d getDirection () %d ]", vRequestSongId.getCurrentSongId (), vRequestSongId.getType () , vRequestSongId.getDirection () ));
    ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId [ listtype %d ]",  vRequestSongId.getType () ));
    ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId [ getDirection () %d ]",  vRequestSongId.getDirection () ));
    bool status = false;

    if ( vRequestSongId.getType() == entListType_Video && vRequestSongId.getLang().empty() )
    {
        vRequestSongId.setType ( entListType_Video_NoFilter );
        ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId listType entListType_Video_NoFilter"));
    }

    /*else if ( vRequestSongId.getType() == entListType_Video && !QueryManager::getInstance()->CheckIfSongIdExist ( vRequestSongId ) )
    {
        ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId fetching first song"));

        sRequestFrontRearSong vRequestFirstSong;

        vRequestFirstSong.setType ( vRequestSongId.getType() );

        vRequestFirstSong.setLang ( vRequestSongId.getLang());

        status = getFirstSongId ( vRequestFirstSong , vResponseSongInfo );

        return status;
    }*/



    string query = QueryManager::getInstance()->getQueryNextPrevious ( vRequestSongId );

    ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId [ query  %s ] ", query.c_str()));

    status = QueryManager::getInstance()->prepareQuery ( query, vRequestSongId.getSourceType() );

    status = status ? QueryManager::getInstance()->prepareQueryNextPrevious ( vRequestSongId ) : false;

    status = status ? QueryManager::getInstance()->updateSongId ( vResponseSongInfo, vRequestSongId.getSourceType() ) : false ;

    return status;

}



/*! ***********************************************************************
 *FUNCTION: 		hasPlayableVideoItem
 *@details: 		check if the db has video files
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

pair <bool,eSourceType> SelectQueryDAO::hasPlayableVideoItem ( eSourceType sourceType )
{
    ETG_TRACE_USR4(("SelectQueryDAO::hasPlayableItem"));
    bool status = false;

    sRequestCount vRequestCount ;

    vRequestCount.setType ( entListType_Video_NoFilter );

    vRequestCount.setSourceType ( sourceType );

    uint16_t count = 0;

    string query = QueryManager::getInstance()->getSqlQueryCount ( vRequestCount );

    status = QueryManager::getInstance()->prepareQuery ( query, sourceType );

    status = status ? QueryManager::getInstance()->prepareQueryCount ( vRequestCount ) : false;

    status = status ? QueryManager::getInstance()->fetchCount ( count, sourceType ) : false ;

    ETG_TRACE_USR4(("SelectQueryDAO::hasPlayableVideoItem and count is %d", count));

    return    {  ( count > 0 ) , sourceType  };
}

/*! ***********************************************************************
 *FUNCTION: 		hasPlayableAudioItem
 *@details: 		check if the db has audio files
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

pair <bool,eSourceType> SelectQueryDAO::hasPlayableAudioItem ( eSourceType sourceType  )
{
    ETG_TRACE_USR4(("SelectQueryDAO::hasPlayableAudioItem"));
    bool status = false;

    sRequestCount vRequestCount ;

    vRequestCount.setType ( entListType_Song );

    vRequestCount.setSourceType ( sourceType );

    uint16_t count = 0;

    string query = QueryManager::getInstance()->getSqlQueryCount ( vRequestCount );

    status = QueryManager::getInstance()->prepareQuery ( query, sourceType );

    status = status ? QueryManager::getInstance()->prepareQueryCount ( vRequestCount ) : false;

    status = status ? QueryManager::getInstance()->fetchCount ( count, sourceType ) : false ;

    ETG_TRACE_USR4(("SelectQueryDAO::hasPlayableAudioItem and count is %d", count));

    return   {  ( count > 0 ) , sourceType  };
}

/*! ***********************************************************************
 *FUNCTION: 		getFirstSongId
 *@details: 		get the First SongId for a particular listype
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/


bool SelectQueryDAO::getFirstSongId ( sRequestFrontRearSong& vRequestFirstSong , sResponseSongInfo& vResponseSongInfo )
{
    ETG_TRACE_USR4(("SelectQueryDAO::getFirstSongId listType %d  ", vRequestFirstSong.getType()));
    ETG_TRACE_USR4(("SelectQueryDAO::getFirstSongId sourceType %d  ", vRequestFirstSong.getSourceType()));

    bool status = false;

    if ( vRequestFirstSong.getType() == entListType_Video && vRequestFirstSong.getLang().empty() )
    {
        vRequestFirstSong.setType ( entListType_Video_NoFilter );
        ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId listType entListType_Video_NoFilter"));
    }

    string query = QueryManager::getInstance()->getFirstSongQuery ( vRequestFirstSong );

    status = QueryManager::getInstance()->prepareQuery ( query, vRequestFirstSong.getSourceType() );

    status = QueryManager::getInstance()->prepareQueryFirstSong ( vRequestFirstSong );


    status = status ? QueryManager::getInstance()->updateSongId ( vResponseSongInfo, vRequestFirstSong.getSourceType() ) : false ;


    ETG_TRACE_USR4(("SelectQueryDAO::getFirstSongId [ song id : %d ]", vResponseSongInfo.getUpdatedSongId() ));

    return status ;
}

/*! ***********************************************************************
 *FUNCTION: 		init
 *@details: 		init
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

bool SelectQueryDAO::init ( eSourceType sourceType )
{
    ETG_TRACE_USR4(("SelectQueryDAO::init"));
    bool status = QueryManager::getInstance()->init( sourceType );
    return status;
}

/*! ***********************************************************************
 *FUNCTION: 		deinit
 *@details: 		deinit
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

bool SelectQueryDAO::deinit ( eSourceType sourceType )
{
    ETG_TRACE_USR4(("SelectQueryDAO::deinit"));
    bool status = QueryManager::getInstance()->deInit ( sourceType );
    return status ;
}

/*! ***********************************************************************
 *FUNCTION: 		getListInfo
 *@details: 		get the complete list based on listType
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

bool SelectQueryDAO::getListInfo( sReqListInfoMessage& vReqListMessage, ItemList &vItemList )
{
    ETG_TRACE_USR4(("SelectQueryDAO::getVideoList"));

    bool status = false;

    if ( vReqListMessage.getType() == entListType_Video && vReqListMessage.getLang().empty() )
    {
        vReqListMessage.setType ( entListType_Video_NoFilter );
        ETG_TRACE_USR4(("SelectQueryDAO::getNextPreviousSongId listType entListType_Video_NoFilter"));
    }

    string query = QueryManager::getInstance()->getSqlQueryCompleteList ( vReqListMessage );

    status = QueryManager::getInstance()->prepareQuery ( query, vReqListMessage.getSourceType() );

    status = QueryManager::getInstance()->prepareQueryData (  vReqListMessage );


    status = status ? QueryManager::getInstance()->fetchResult ( vItemList, vReqListMessage.getSourceType(), vReqListMessage.getType() ) : false ;


    ETG_TRACE_USR4(("SelectQueryDAO::getVideoList and size is %d", vItemList.size() ));


    return status;
}


/*! ***********************************************************************
 *FUNCTION: 		getLastSongId
 *@details: 		get the lastSongId based on listType
 *REQUIREMENT ID:	NA
 *@param:		NA
 *@return: 		bool
 *@details
 *HISTORY:
 *05.28.2020		1.0		Monojit Chatterjee
 ************************************************************************/

bool SelectQueryDAO::getLastSongId ( sRequestFrontRearSong& vRequestLastSong , sResponseSongInfo& vResponseSongInfo  )
{
    bool status = false;
    uint16_t count = 0;

    if ( vRequestLastSong.getType() == entListType_Video && vRequestLastSong.getLang().empty() )
    {
        vRequestLastSong.setType ( entListType_Video_NoFilter );
        ETG_TRACE_USR4(("SelectQueryDAO::getLastSongId listType entListType_Video_NoFilter"));
    }
    sRequestCount vRequestCount;
    vRequestCount.setSourceType ( vRequestLastSong.getSourceType() );
    vRequestCount.setType ( vRequestLastSong.getType() );
    vRequestCount.setAbsoluteId_1 ( vRequestLastSong.getAbsoluteId_1());
    vRequestCount.setAbsoluteId_2 ( vRequestLastSong.getAbsoluteId_2());
    vRequestCount.setLang ( vRequestLastSong.getLang() );
    vRequestCount.setFolderPath ( vRequestLastSong.getFolderPath());

    status = getListCount ( vRequestCount ,  count);



    uint16_t vLastSongPrepareCount = count - 1;

    ETG_TRACE_USR4(("SelectQueryDAO::getLastSongId and count is %d", vLastSongPrepareCount ));

    if (status )
    {
        string query =  QueryManager::getInstance()->getSqlLastSongQuery ( vRequestLastSong ) ;

        status = QueryManager::getInstance()->prepareQuery ( query, vRequestLastSong.getSourceType() );

        status = status ? QueryManager::getInstance()->prepareQueryLastSong ( vRequestLastSong , vLastSongPrepareCount ) : false ;

        status = status ? QueryManager::getInstance()->updateSongId ( vResponseSongInfo, vRequestLastSong.getSourceType() ) : false ;


    }

    ETG_TRACE_USR4(("SelectQueryDAO::getLastSongId and lastSongId  is %d", vResponseSongInfo.getUpdatedSongId() ));

    return status ;


}






