/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : CMP_Source.h
 * COMPONENT Name      : EMP List - DBManager
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 23.07.2020
 * Revision History    : 1.0
 * Date 7.07.2020     : Initial version
 *
*/


#include <CMP_Source.h>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "EMPListTraceConfig.h" // For using the Trace Class ID
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LISTHANDLER_DBMANAGER
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_NAVRES1
#include "trcGenProj/Header/CMP_Source.cpp.trc.h" // cpp filename.cpp.trc.h
#endif


/*! ***********************************************************************
*FUNCTION: 		constructor
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*05.28.2020		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

CMP_Source::CMP_Source()
{
}

/*! ***********************************************************************
*FUNCTION: 		destructor
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

CMP_Source::~CMP_Source()
{
}

/*! ***********************************************************************
*FUNCTION: 		setDBPath
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

bool CMP_Source::setDBPath ( string dbPath )
{
    this->mdbPath = dbPath;
    return true;
}

/*! ***********************************************************************
*FUNCTION: 		getDBPath
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

string CMP_Source::getDBPath ()
{
    return this->mdbPath;
}

/*! ***********************************************************************
*FUNCTION: 		setDBStatus
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/
bool CMP_Source::setDBStatus ( bool dbStatus )
{
    this->dbStatus = dbStatus;
    return true;
}

/*! ***********************************************************************
*FUNCTION: 		getDBStatus
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

bool CMP_Source::getDBStatus ()
{
    return this->dbStatus;
}

/*! ***********************************************************************
*FUNCTION: 		setQueryStateMent
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

void CMP_Source::setQueryStateMent ( sqlite3_stmt *stmt )
{
    this->stmt = stmt;
}

/*! ***********************************************************************
*FUNCTION: 		getQueryStateMent
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

sqlite3_stmt* CMP_Source::getQueryStateMent ()
{
    return this->stmt;
}

/*! ***********************************************************************
*FUNCTION: 		init
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

bool CMP_Source::init ()
{


    bool status = false;

    if ( this->setDBPath ( CMP_DBPATH ) )
    {
        ETG_TRACE_USR4(("CMP_Source::init dbPath  %s", this->getDBPath().c_str() ));
        if ( openDB () )
        {
            ETG_TRACE_USR4(("CMP_Source::init openDB success  " ));
            status = true;

        }
    }

    ETG_TRACE_USR4(("CMP_Source::init status %d", status ));

    return status;
}


/*! ***********************************************************************
*FUNCTION: 		deInit
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

bool CMP_Source::deInit ()
{
    ETG_TRACE_USR4((" %s ", __FUNCTION__  ));
    ETG_TRACE_USR4((" %d", __LINE__ ));
    bool status = false;
    if ( getDBStatus () )
    {
        status = closeDB();
    }

    return status;
}

/*! ***********************************************************************
*FUNCTION: 		openDB
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

bool CMP_Source::openDB ()
{
    sqlite3 * dbCam;
    this -> setDBStatus ( false );
    rc = sqlite3_open( getDBPath ().c_str() , &dbCam);
    if ( ! rc )
    {
        this -> setDBStatus ( true );
        ETG_TRACE_USR4(("CMP_Source::openDB openDB success for dbPath %s success",  this->getDBPath ().c_str() ));
    }
    else
    {
        ETG_TRACE_USR4(("CMP_Source::openDB openDB success for dbPath %s failed ",  this->getDBPath ().c_str() ));
    }

    this->setDB ( dbCam );
    return this -> getDBStatus (  );
}

/*! ***********************************************************************
*FUNCTION: 		closeDB
*@details:
*REQUIREMENT ID:	NA
*@param:		void
*@return: 		void
*@details
*HISTORY:
*06.23.2021		1.0		Monojit Chatterjee		Reviewed
************************************************************************/

bool CMP_Source::closeDB ()
{
    ETG_TRACE_USR4((" %s ", __FUNCTION__  ));
    ETG_TRACE_USR4((" %d", __LINE__ ));
    sqlite3_close ( getDB() );
    this->setDBStatus ( false );
    return true ;
}
