/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : QueryManager.h
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 23.07.2020
 * Revision History    : 1.0
 * Date 7.07.2020     : Initial version
 *
*/


#ifndef QUERY_MANAGER_H_
#define QUERY_MANAGER_H_
#include <string>
#include <vector>
#include <map>
#include <unordered_map>
#include <dbManagerTypeDefs.h>
#include <dbManagerQueryTypes.h>
#include <SelectQueryDAO.h>
#include <IBaseSource.h>
#include <CMR_Source.h>
#include <CMP_Source.h>

using namespace dbManagerTypes;



class QueryManager
{
public:

    QueryManager() ;
    // singleton

    static QueryManager *getInstance();


    //destructor
    virtual ~QueryManager();

    virtual string getSqlQuery ( sRequestMessage& vRequestMessage);

    string  toString ( int queryData  )
    {
        querystream << queryData;
        return querystream.str();
    }

    static int  toInt ( string queryData  )
    {
        int data {} ;
        stringstream querystream(queryData);
        querystream >> data ;
        return data;
    }

    string getQueryWindowUpdate ();

    int countOccuances ( string sQuery );


    virtual bool fetchCount ( uint16_t&  count, eSourceType srcType );

    static ItemList getItemList ()
    {
        return mItemList;
    }

    static void clearCount ()
    {
        count = 0;
    }

    int getCount ()
    {
        return count;
    }

    virtual bool init( eSourceType& sourceType );

    virtual bool deInit( eSourceType& sourceType );

    bool ProcessResponseMessage ( ItemList vItemList );

    bool processCount ( int count ) ;

    virtual bool prepareQuery ( string query, eSourceType srcType );

    virtual bool fetchResult ( ItemList& vItemList, eSourceType srcType, eListType type );

    eListType getListType ()
    {
        return type;
    }

    void     setListType ( eListType type )
    {
        this->type = type;
    }


    string getNextQuery ( eListType listType ) ;

    string getPreviousQuery ( eListType listType );

    bool existNextPreviousQuery ( eListType listType );

    virtual string getQueryNextPrevious ( sRequestSongId& vRequestSongId );

    virtual bool prepareQueryNextPrevious ( sRequestSongId& vRequestSongId );

    virtual bool updateSongId ( sResponseSongInfo& vResponseSongInfo, eSourceType srcType );

    virtual bool prepareQueryCount ( sRequestCount& vRequestCount  );

    virtual bool prepareQueryData( sRequestMessage& vRequestMessage );

    virtual string getSqlQueryCount ( sRequestCount& vRequestCount );

    virtual string getFirstSongQuery ( sRequestFrontRearSong& vRequestFirstSong );

    virtual string getVideoFirstSongQuery ( string query, sRequestFrontRearSong& vRequestFirstSong );

    IBaseSource* getSourceFactory ( eSourceType srcType );

    virtual string getSqlQueryCompleteList ( sReqListInfoMessage& vReqListMessage );

    virtual string getVideoCompleteListQuery ( string query, sReqListInfoMessage& vReqListMessage );

    virtual string getSqlLastSongQuery ( sRequestFrontRearSong& vRequestLastSong );

    virtual string getVideoLastSongQuery ( string query, sRequestFrontRearSong& vRequestLastSong );

    virtual bool prepareQueryData( sReqListInfoMessage& vReqListMessage );

    virtual bool prepareQueryLastSong ( sRequestFrontRearSong& vRequestLastSong, uint16_t& vLastSongPrepareCount );

    virtual bool prepareQueryFirstSong ( sRequestFrontRearSong& vRequestLastSong );

    virtual bool fetchSliceVideoList ( ItemList& vItemList, eSourceType srcType );

    virtual bool fetchSliceFolderList ( ItemList& vItemList, eSourceType srcType );

    virtual string getQuerySliceVideoLangList ( sRequestMessage& vRequestMessage, string query );

    virtual string getQueryCountVideoLangList ( sRequestCount& vRequestCount, string query );

    string prepareParamList ( Langlist&         lang);

    bool prepareBind ( Langlist&         lang,  sqlite3_stmt *stmt, int& index   );

    bool prepareBindNextPrevious ( Langlist&         lang,  sqlite3_stmt *stmt, int& index   );

    bool CheckIfSongIdExist (  sRequestSongId& vRequestSongId );

    bool prepareQueryVideoIdExist ( sRequestSongId& vRequestSongId );

    bool fetchIdStatus ( eSourceType srcType );

    string getLangQuery ( string query, sRequestSongId& vRequestSongId );

    virtual bool prepareQueryVideoNextPrevious ( sRequestSongId& vRequestSongId );

    virtual bool prepareQueryVideo ( sRequestFrontRearSong& vRequestLastSong );

    bool updateRootFolderPath ( eSourceType& sourceType );

    bool  fetchRootPath ( eSourceType& sourceType, string& rootPath );

    virtual bool prepareQueryFolder ( eSourceType sourceType , string folderPath, int& paramIndex );

    virtual bool prepareQueryFolderNextPrevious ( sRequestSongId& vRequestSongId, int&  paramIndex );


    virtual bool prepareQueryFrontRearSong ( sRequestFrontRearSong& vRequestFrontRearSong , int& paramIndex );

    virtual bool prepareQueryCompleteList ( sReqListInfoMessage& vReqListMessage , int& paramIndex );

    bool updateLanguageTable ( eSourceType srcType );




private :

    string extractFolderRelativePath ( string AbsoluteFolderPath , eSourceType srcType  );

    // constructor
    
    static QueryManager* instance ;

    ostringstream querystream {} ;

    string mdbPath = "";

    sqlite3 *db{};

    bool dbStatus = false;

    static ItemList mItemList ;

    static int count ;

    int rc ;

    eListType type = entListType_Invalid;

    sqlite3_stmt *stmt{};

    map <eSourceType, IBaseSource* > mapSourceList {} ;


};
#endif /* QueryManager */
