/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : CMR_Source.h
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 23.06.2021
 * Revision History    : 1.0
 * Date 7.07.2020     : Initial version
 *
*/


#ifndef CMR_SOURCE_H_
#define CMR_SOURCE_H_
#include <string>
#include <vector>
#include <map>
#include <dbManagerTypeDefs.h>
#include <dbManagerQueryTypes.h>
#include <SelectQueryDAO.h>
#include <IBaseSource.h>

using namespace dbManagerTypes;



class CMR_Source : public IBaseSource
{
public:

    CMR_Source();

    ~CMR_Source() ;

    virtual bool setDBPath ( string dbPath ) ;

    virtual string getDBPath () ;

    virtual bool setDBStatus ( bool dbStatus ) ;

    virtual bool getDBStatus () ;

    virtual void setQueryStateMent ( sqlite3_stmt *stmt ) ;

    virtual sqlite3_stmt* getQueryStateMent () ;

    virtual bool init () ;

    virtual bool deInit () ;

    virtual bool openDB () ;

    virtual bool closeDB () ;

    sqlite3 * getDB ()
    {
        return db;
    }


    void setDB ( sqlite3 * db )
    {
        this->db = db;
    }
	
	void setAbsoluteFolderPath ( string requestFolderPath )
	{
		this->AbsoluteFolderPath = requestFolderPath;
	}
	
	string getAbsoluteFolderPath ()
	{
		return this->AbsoluteFolderPath;
	}


    void setRootFolderPath ( string rootPath )
    {
        this->rootPath = rootPath;
    }

    string getRootFolderPath ()
    {
        return rootPath;
    }



private :



    string mdbPath = "";

    string rootPath = "";
	
	string AbsoluteFolderPath = "";

    sqlite3 *db{};

    bool dbStatus = false;

    sqlite3_stmt *stmt{};

    int rc = -1;





};
#endif /* CMR_SOURCE_H_ */
