/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : DBManagerTypes.h
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 24.07.2020
 * Revision History    : 1.0
 * Date 24.07.2020     : Initial version
 *
*/


#ifndef DB_MANAGER_TYPES_H_
#define DB_MANAGER_TYPES_H_

#include <dbManagerTypeDefs.h>
#include <dbManagerQueryTypes.h>
#include <QueryConstant.h>
#include <cstring>
#include <cstdlib>
#include <string>
#include <vector>
#include <queue>
#include <thread>
#include <memory>
#include <mutex>


using namespace std;



typedef enum ListType
{
    entListType_Genre	                = 0,
    entListType_Artist	                = 1,
    entListType_Album	                = 2,
    entListType_Song                    =3,
    entListType_Artist_Album            = 11,
    entListType_Artist_Album_Song	    = 12,
    entListType_Artist_Song             = 13,
    entListType_Album_Song              = 14,
    entListType_Genre_Album             = 8,
    entListType_Genre_Album_Song        = 9,
    entListType_Genre_Song              = 10,
    entListType_Video                   = 26,
    entListType_Video_NoFilter          = -26,
    entListType_Video_episode           =27,
    entListType_Playlist                =28,
    entListType_Playlist_song           =29,
    entListType_Folder                  =31,
    entListType_Folder_file             = 32,
    entListType_Video_Languages         = 33,
    entListType_Invalid                 =255
} eListType;

typedef enum ColumnList
{
    eFILENAME,
    eID,
    eISO,
    eLANGNAME,
    eLANGID,
    eROOTPATH,
    eFILETYPE,
    eINDEX_ITEM,
    eINDEX_FILETYPE

} eColumnList;


typedef enum ParamPosition
{
    FIRST_PARAM = 1,
    SECOND_PARAM = 2,
    THIRD_PARAM = 3,
    FOURTH_PARAM = 4

} eParamPosition;

typedef enum SourceType
{
    entSourceType_DEFAULT  = 0x0000,
    entSourceType_CMP      = 0x0001,
    entSourceType_CMR	   = 0x0002

} eSourceType;


typedef enum Direction
{
    eNEXT     =     1,
    ePREVIOUS =     2,
    eINVALID  =     3

} eDirection;

typedef enum FileType
{
	eINVALID_FILETYPE        =     0,
    eVIDEOFILES              =     1,
    eAUDIOFILES              =     2,
    eFOLDER                  =     3
} eFileType;

typedef vector <uint16_t>         Langlist;

typedef struct RequestMessage
{
private :

    short                           startIndex;
    short                           windowSize;
    eListType                       type;
    uint32_t                        mAbsoluteId_1;
    uint32_t                        mAbsoluteId_2;
    eSourceType                     srcType;
    Langlist                        lang {};
    string                          folderPath;



public :
    RequestMessage () : mAbsoluteId_1 ( DEFAULT_VALUE ), mAbsoluteId_2 ( DEFAULT_VALUE ),startIndex ( DEFAULT_VALUE ) , windowSize ( DEFAULT_VALUE ), type ( entListType_Invalid ), srcType ( entSourceType_CMP ), folderPath ( "" ) {}


    inline short  getStartIndex () const
    {
        return startIndex;
    }
    inline short getWindowSize ()  const
    {
        return windowSize ;
    }
    inline eListType getType () const
    {
        return type ;
    }

    inline uint32_t getAbsoluteId_1 () const
    {
        return mAbsoluteId_1;
    }

    inline uint32_t getAbsoluteId_2 () const
    {
        return mAbsoluteId_2;
    }

    inline eSourceType getSourceType () const
    {
        return srcType;
    }

    inline Langlist& getLang ()
    {
        return lang;
    }

    inline string getFolderPath ()
    {
        return folderPath;
    }

    inline void setType ( eListType type )
    {
        this->type = type;
    }

    inline void setStartIndex ( short startIndex )
    {
        this->startIndex = startIndex;
    }
    inline void setWindowSize ( short windowSize )
    {
        this->windowSize = windowSize;
    }

    inline void setAbsoluteId_1 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_1 = vAbsoluteId;
    }

    inline void setAbsoluteId_2 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_2 = vAbsoluteId;
    }

    inline void setSourceType ( eSourceType srcType )
    {
        this->srcType = srcType;
    }

    inline void setLang ( Langlist lang )
    {
        this->lang = lang;
    }

    inline void setFolderPath ( string folderPath )
    {
        this->folderPath = folderPath;
    }



    virtual ~RequestMessage() {}



}  sRequestMessage;

typedef struct RequestCount
{
private :

    uint32_t               mAbsoluteId_1;

    uint32_t               mAbsoluteId_2;

    eListType           type;

    eSourceType         srcType;

    Langlist         lang {};

    string              folderPath;

public :

    RequestCount () : mAbsoluteId_1 ( DEFAULT_VALUE ),mAbsoluteId_2 ( DEFAULT_VALUE ), type ( entListType_Invalid ), srcType ( entSourceType_CMP ), folderPath ( "" )
    {
    }

    inline void setAbsoluteId_1 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_1 = vAbsoluteId;
    }

    inline uint32_t getAbsoluteId_1 ()
    {
        return mAbsoluteId_1;
    }

    inline void setAbsoluteId_2 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_2 = vAbsoluteId;
    }

    inline uint32_t getAbsoluteId_2 ()
    {
        return mAbsoluteId_2;
    }

    inline eSourceType getSourceType () const
    {
        return srcType;
    }

    inline eListType getType () const
    {
        return type ;
    }

    inline Langlist& getLang ()
    {
        return lang;
    }

    inline string getFolderPath ()
    {
        return folderPath;
    }

    inline void setType ( eListType type )
    {
        this->type = type;
    }

    inline void setSourceType ( eSourceType srcType )
    {
        this->srcType = srcType;
    }

    inline void setLang ( Langlist lang )
    {
        this->lang = lang;
    }


    inline void setFolderPath ( string folderPath )
    {
        this->folderPath = folderPath;
    }


    virtual ~RequestCount() {}

} sRequestCount;


typedef struct RequestFrontRearSong
{
private :

    uint32_t            mAbsoluteId_1;
    uint32_t            mAbsoluteId_2;

    eListType           type;

    eSourceType         srcType;

    Langlist         lang {};

    string           folderPath ;

public :

    RequestFrontRearSong () : mAbsoluteId_1 ( DEFAULT_VALUE ), mAbsoluteId_2 ( DEFAULT_VALUE ), type ( entListType_Invalid ), srcType ( entSourceType_CMP ), folderPath ("")
    {
    }

    inline void setAbsoluteId_1 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_1 = vAbsoluteId;
    }

    inline uint32_t getAbsoluteId_1 ()
    {
        return mAbsoluteId_1;
    }

    inline void setAbsoluteId_2 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_2 = vAbsoluteId;
    }

    inline uint32_t getAbsoluteId_2 ()
    {
        return mAbsoluteId_2;
    }

    inline eSourceType getSourceType () const
    {
        return srcType;
    }

    inline eListType getType () const
    {
        return type ;
    }

    inline Langlist& getLang ()
    {
        return lang;
    }

    inline string getFolderPath ()
    {
        return folderPath;
    }

    inline void setType ( eListType type )
    {
        this->type = type;
    }

    inline void setSourceType ( eSourceType srcType )
    {
        this->srcType = srcType;
    }

    inline void setLang ( Langlist lang )
    {
        this->lang = lang;
    }

    inline void setFolderPath ( string folderPath )
    {
        this->folderPath = folderPath;
    }


    virtual ~RequestFrontRearSong() {}

} sRequestFrontRearSong;

typedef struct ReqListInfoMessage
{
private :

    eListType           type;

    eSourceType         srcType;

    uint32_t            mAbsoluteId_1;

    uint32_t            mAbsoluteId_2;

    Langlist         lang {};

    string           folderPath ;

public :

    ReqListInfoMessage () : mAbsoluteId_1 ( DEFAULT_VALUE ),mAbsoluteId_2 ( DEFAULT_VALUE ), type ( entListType_Invalid ), srcType ( entSourceType_CMP ), folderPath ("")
    {
    }

    inline void setAbsoluteId_1 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_1 = vAbsoluteId;
    }

    inline uint32_t getAbsoluteId_1 ()
    {
        return mAbsoluteId_1;
    }

    inline void setAbsoluteId_2 ( uint32_t vAbsoluteId )
    {
        this->mAbsoluteId_2 = vAbsoluteId;
    }

    inline uint32_t getAbsoluteId_2 ()
    {
        return mAbsoluteId_2;
    }

    inline eSourceType getSourceType () const
    {
        return srcType;
    }

    inline eListType getType () const
    {
        return type ;
    }

    inline Langlist& getLang ()
    {
        return lang;
    }

    inline string getFolderPath ()
    {
        return folderPath;
    }

    inline void setType ( eListType type )
    {
        this->type = type;
    }

    inline void setSourceType ( eSourceType srcType )
    {
        this->srcType = srcType;
    }

    inline void setLang ( Langlist lang )
    {
        this->lang = lang;
    }

    inline void setFolderPath ( string folderPath )
    {
        this->folderPath = folderPath;
    }


    virtual ~ReqListInfoMessage() {}

} sReqListInfoMessage;

typedef struct ItemData
{

public :

    short absoluteIndex ;
    string firstString ;
    string secondString ;
    int lang;
    eFileType fileType;

    ItemData() : absoluteIndex ( -1 ), firstString ( "" ), secondString ( "" ), fileType (eINVALID_FILETYPE ), lang (-1) {}

    inline short getAbsoluteIndex () const
    {
        return absoluteIndex;
    }

    inline string getFirstString () const
    {
        return firstString;
    }

    inline string getSecondString () const
    {
        return secondString;
    }

    int getVideoLanguage ()
    {
        return lang;
    }

    eFileType getFileType ()
    {
        return fileType;
    }

    inline void setAbsoulteIndex ( short absoluteIndex )
    {
        this->absoluteIndex = absoluteIndex;
    }

    inline void setFirstString ( string firstString )
    {
        this-> firstString = firstString ;
    }

    inline void setSecondString ( string secondString )
    {
        this-> secondString = secondString ;
    }

    inline void setVideoLanguage ( int lang )
    {
        this->lang = lang;
    }

    inline void setFileType ( eFileType fileType )
    {
        this->fileType = fileType;
    }

    virtual ~ItemData () {}

} sItemData;

typedef struct RequestSongId
{

public :

    uint32_t               currentSongId ;
    eListType           type;
    eDirection          direction;
    eSourceType         srcType;
    Langlist         lang {};
    string           folderPath ;
    eFileType      fileType;


    RequestSongId() : currentSongId ( -1 ), type ( entListType_Invalid ), direction ( eINVALID ), srcType ( entSourceType_CMP ), folderPath(""), fileType ( eINVALID_FILETYPE ) {}

    inline uint32_t getCurrentSongId () const
    {
        return currentSongId;
    }



    inline eListType getType () const
    {
        return type ;
    }

    inline eDirection getDirection () const
    {
        return direction;
    }

    inline eSourceType getSourceType () const
    {
        return srcType;
    }

    eFileType getFileType ()
    {
        return fileType;
    }

    inline void setCurrentSongId ( uint32_t currentSongId )
    {
        this->currentSongId = currentSongId;
    }

    inline Langlist& getLang ()
    {
        return lang;
    }

    inline string getFolderPath ()
    {
        return folderPath;
    }



    inline void setType ( eListType type )
    {
        this->type = type;
    }

    inline void setDirection ( eDirection direction )
    {
        this->direction = direction;
    }

    inline void setSourceType ( eSourceType srcType )
    {
        this->srcType = srcType;
    }

    inline void setLang ( Langlist lang )
    {
        this->lang = lang;
    }

    inline void setFolderPath ( string folderPath )
    {
        this->folderPath = folderPath;
    }

    inline void setFileType ( eFileType fileType )
    {
        this->fileType = fileType;
    }



    virtual ~RequestSongId () {}

} sRequestSongId;

typedef struct ResponseSongInfo
{

public :


    uint32_t updatedSongId;

    eFileType fileType;


    ResponseSongInfo() : updatedSongId ( -1 ), fileType (eINVALID_FILETYPE ) {}

    inline uint32_t getUpdatedSongId () const
    {
        return updatedSongId;
    }

    inline eFileType getFileType ()
    {
        return fileType;
    }

    inline void setUpdatedSongInfo ( uint32_t updatedSongId )
    {
        this->updatedSongId = updatedSongId;
    }

    inline void setFileType ( eFileType fileType )
    {
        this->fileType = fileType;
    }

    virtual ~ResponseSongInfo () {}

} sResponseSongInfo;



struct QueryEnumClassHash
{
    template <typename T>
    std::size_t operator()(T t) const
    {
        return static_cast<std::size_t>(t);
    }
};


#endif

