/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : RequestTypeDefs.h
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 24.07.2020
 * Revision History    : 1.0
 * Date 24.07.2020     : Initial version
 *
*/


#ifndef DB_MANAGER_TYPE_DEFS_H_
#define DB_MANAGER_TYPE_DEFS_H_

#include <dbManagerTypes.h>
#include <dbManagerQueryTypes.h>

#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>
#include <cstring>
#include <cstdlib>
#include <string>
#include <vector>
#include <queue>
#include <thread>
#include <memory>
#include <mutex>
#include <sstream>
#include <condition_variable>
#include <map>


using namespace std;

namespace dbManagerTypes
{
typedef vector < sItemData > ItemList;

template <typename Key>
using HashType = typename std::conditional<std::is_enum<Key>::value, QueryEnumClassHash, std::hash<Key>>::type;

template <typename Key, typename T>
using QueryMap = unordered_map<Key, T, HashType<Key>>;




}

#endif

