/*
 * Copyright (C) Robert Bosch Car Multimedia GmbH, 2020
 * This software is property of Robert Bosch GmbH. Unauthorized
 * duplication and disclosure to third parties is prohibited.
 *
 * FILE                : QueryConstant.h
 * COMPONENT Name      : EMP Query Module
 * DESCRIPTION         :
 * AUTHOR              : Monojit Chatterjee
 * Date                : 12.05.2022
 * Revision History    : 1.0
 * Date 24.07.2020     : Initial version
 *
*/


#ifndef QUERY_CONSTANT_H_
#define QUERY_CONSTANT_H_

#include <dbManagerTypeDefs.h>
#include <dbManagerQueryTypes.h>
#include <cstring>
#include <cstdlib>
#include <string>
#include <vector>
#include <queue>
#include <thread>
#include <memory>
#include <mutex>


using namespace std;


/********************** Common Constant *****************/



#define CMP_DBPATH           "/tmp/CMP/Database/USB_DB.sqlite"
#define CMR_DBPATH           "/tmp/CMR/Database/USB_DB.sqlite"
#define DEFAULT_VALUE    -1
#define COUNT_COLUMN     "COUNT(*)"
#define QUERY_ID_EXIST   "SELECT EXISTS ( SELECT Id from VideoFiles  INNER JOIN Languages on VideoFiles.LangId = Languages.IdLanguage where  ( Playable=1 AND Id = ? ) AND ( ISO='und'  OR LangId  in ("
#define NEXT_EXT       ") ) ORDER BY Id DESC LIMIT 1"
#define PREVIOUS_EXT   ") ) ORDER BY Id DESC LIMIT 1"
#define FIRST_SONG_EXT ") )  LIMIT 0,1"
#define LAST_SONG_EXT  ") ) LIMIT ?,1"
#define ID_EXIST_EXT   ")))"
#define UPDATE_LANGUAGE_TABLE "UPDATE Languages SET Language = 'Undetermined Language',ISO=''  WHERE  ISO = 'und' OR ISO = 'UND'"



/********************************************************/

/********************** Folder related Queries *****************/


#define FOLDER_SLICE_REQUEST_QUERY "SELECT Paths.IdPath as Id, Paths.Path as Filename, 3 as \ FileType  FROM Paths \
 WHERE Paths.IdParentPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
 UNION ALL \
 SELECT AudioFiles.Id as Id, AudioFiles.Filename as Filename, 2 as FileType FROM AudioFiles \
 WHERE AudioFiles.IdPath IN \
 (SELECT Paths.IdPath From Paths Where Paths.path = ? ) \
 AND AudioFiles.Playable = 1 \
 UNION ALL \
 SELECT VideoFiles.Id as Id, VideoFiles.Filename as Filename, 1 as FileType FROM VideoFiles \
 WHERE VideoFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
 AND VideoFiles.Playable = 1 \
 LIMIT ?,? "

#define FOLDER_COUNT_REQUEST_QUERY "SELECT COUNT(*)  FROM Paths \
WHERE Paths.IdParentPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ?) \
UNION ALL \
SELECT COUNT(*) FROM AudioFiles \
WHERE AudioFiles.IdPath IN  \
(SELECT Paths.IdPath From Paths Where Paths.path = ? ) \
AND AudioFiles.Playable = 1 \
UNION ALL \
SELECT COUNT(*) FROM VideoFiles \
WHERE VideoFiles.IdPath IN  \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
AND VideoFiles.Playable = 1"

#define FOLDER_ROOT_PATH_QUERY "SELECT Path FROM Paths WHERE IdPath=1"

#define FOLDER_NEXT_QUERY "SELECT IndexItem,IndexFileType From ( \
Select id,  FileType, \
lead(id) OVER(ORDER BY row_number) as IndexItem, lead(FileType) OVER(ORDER BY row_number) \ as IndexFileType \
FROM( \
SELECT id, ROW_NUMBER() OVER() as row_number, \
FileType, filename \
FROM( \
SELECT AudioFiles.Id as id, AudioFiles.Filename as filename, 2 as FileType FROM AudioFiles \
WHERE AudioFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.path = ? ) \
AND AudioFiles.Playable = 1 \
UNION ALL \
SELECT VideoFiles.Id as id, VideoFiles.Filename as filename, 1 as FileType FROM VideoFiles \
WHERE VideoFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
AND VideoFiles.Playable = 1  \
))) WHERE id = ? AND FileType = ?"


#define FOLDER_PREVIOUS_QUERY "SELECT IndexItem,IndexFileType From ( \
Select id, FileType, \
lag(id) OVER(ORDER BY row_number) as IndexItem, lag(FileType) OVER(ORDER BY row_number) as  IndexFileType \
FROM( \
SELECT id, ROW_NUMBER() OVER() as row_number, \
FileType, filename \
FROM( \
SELECT AudioFiles.Id as id, AudioFiles.Filename as filename, 2 as FileType FROM AudioFiles \
WHERE AudioFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.path = ? ) \
AND AudioFiles.Playable = 1 \
UNION ALL \
SELECT VideoFiles.Id as id, VideoFiles.Filename as filename, 1 as FileType FROM VideoFiles \
WHERE VideoFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
AND VideoFiles.Playable = 1 \
))) WHERE id = ? AND FileType = ?"

#define FOLDER_LAST_SONG "SELECT AudioFiles.Id as IndexItem,  2 \ as  IndexFileType FROM AudioFiles \
WHERE AudioFiles.IdPath IN \
( SELECT Paths.IdPath From Paths Where Paths.path = ? ) \
AND AudioFiles.Playable = 1  \
UNION ALL  \
SELECT VideoFiles.Id as IndexItem,  1 as IndexFileType FROM VideoFiles \
WHERE VideoFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
AND VideoFiles.Playable = 1 LIMIT ?,1"

#define FOLDER_FIRST_SONG "SELECT AudioFiles.Id as IndexItem, 2 \ as IndexFileType FROM AudioFiles \
 WHERE AudioFiles.IdPath IN \
( SELECT Paths.IdPath From Paths Where Paths.path = ? ) \
 AND AudioFiles.Playable = 1 \
 UNION ALL \
 SELECT VideoFiles.Id as IndexItem,  1 as IndexFileType FROM VideoFiles \
 WHERE VideoFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
 AND VideoFiles.Playable = 1 LIMIT 0,1"

#define FOLDER_COMPLETE_LIST "SELECT AudioFiles.Id as Id, AudioFiles.Filename as   Filename,\ 2 as FileType FROM AudioFiles \
 WHERE AudioFiles.IdPath IN \
 ( SELECT Paths.IdPath From Paths Where Paths.path = ? ) \
 AND AudioFiles.Playable = 1 \
 UNION ALL \
 SELECT VideoFiles.Id as Id, VideoFiles.Filename as Filename, 1 as FileType FROM VideoFiles \
 WHERE VideoFiles.IdPath IN \
(SELECT Paths.IdPath From Paths Where Paths.Path = ? ) \
 AND VideoFiles.Playable = 1 \
 LIMIT -1"





/********************** Folder related Queries *****************/








#endif

