/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginServerComponent.cpp
* COMPONENT Name      : PluginServer
* DESCRIPTION         : ASF Plugin server component
* AUTHOR              : Preethi Alagappan
* Date                : 18.09.2018
* Revision History    : 0.1
* Date 18.09.2018     : Initial version
****************************************************************************/

/*****************************************************************
| includes
|----------------------------------------------------------------*/

// The below include files are needed for AC_CLIENT_PLUGIN_ENTRY()
#include <cstdint>
#include <iostream>
#include <iomanip>
#include <chrono>
#include "ACClientInterface.h"
#include "util.h"
#include "enumeration.h"

// The below include files are needed for launching the applications
#include "asf/core/ApplicationLauncher.h"
#include "asf/core/Application.h"

#include "PluginServer.h"
#include "PluginServerComponent.h"

//adding traces

#include "plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_APPUTILITIES_PLUGINSERVER
#include "trcGenProj/Header/PluginServerComponent.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN


/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

//'libname' must match library name as deployed in file system (w/o leading 'lib' and suffix '.so')
#ifndef PLUGIN_SERVER_LIB_NAME
#define PLUGIN_SERVER_LIB_NAME pluginserver_so
#endif

#define PLUGIN_SERVER_ENTRY(libname) AC_CLIENT_PLUGIN_ENTRY(libname)
#define PLUGIN_SERVER_EXIT(libname) AC_CLIENT_PLUGIN_EXIT(libname)

using namespace PluginServer;

::asf::core::ApplicationLauncher launcher;

extern "C" void* PLUGIN_SERVER_ENTRY(PLUGIN_SERVER_LIB_NAME)()
{
   try
   {
      printf("Plugin server entry\n");
      launcher.launch(PluginServer::executePluginServer);
   }
   catch(...)
   {
      printf("Plugin server entry : Caught exception\n");
   }

   return (void*) ::asf::core::Application::getApplication();
}

extern "C" void PLUGIN_SERVER_EXIT(PLUGIN_SERVER_LIB_NAME)(void *inst)
{
   launcher.shutdown();
} 

/************************************************************************
*NAME        : PluginServerComponent
*DESCRIPTION : Design section 8.2.4 - PluginServer
************************************************************************/
PluginServerComponent::PluginServerComponent()
{
   // Start Trace
   vInitPlatformEtg();
   ETG_TRACE_USR4(("PluginServerComponent::PluginServerComponent()"));
   poPluginServerHandler = PluginServerHandler::getInstance();
}

/************************************************************************
*NAME        : ~PluginServerComponent
*DESCRIPTION : Design section 8.2.4 - PluginServer
************************************************************************/
PluginServerComponent::~PluginServerComponent()
{
   ETG_TRACE_USR4(("PluginServerComponent::~PluginServerComponent()"));
}
