/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CommandToPlugin.h
* COMPONENT Name      :
* DESCRIPTION         : This class fire event for the corresponding plugin
* AUTHOR              : Dalabehera Ruchismita
* Date                : 27.09.2018
* Revision History    : 0.1
* Date 27.09.2018     : Initial version
* Revision History    : 0.2
* Date 20.11.2018     : creation of event and
****************************************************************************/


#ifndef _CMD_TO_CLASS_H_
#define _CMD_TO_CLASS_H_

#include "boost/shared_ptr.hpp"
#include "EventDataUtility.h"
#include "EventBus.hpp"

class CommandToPlugin : public Object
{
public:
   static CommandToPlugin* poGetInstance();

	~CommandToPlugin();
	void sendEventToPlugin(const string& plugInName,const string& controlBlockName,const boost::shared_ptr<EventDataUtility>& eData);
	void sendListEventToPlugin(const string& plugInName,
	                           const string& controlBlockName,
	                           const boost::shared_ptr<EventDataUtility>& eData,
	                           const boost::shared_ptr<EventListDataUtility>& eListData);
private:
   CommandToPlugin();
};


#endif
