/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : CommandToPlugin.h
* COMPONENT Name      :
* DESCRIPTION         : This class fire event for the corresponding plugin
* AUTHOR              : Dalabehera Ruchismita
* Date                : 27.09.2018
* Revision History    : 0.1
* Date 27.09.2018     : Initial version
* Revision History    : 0.2
* Date 20.11.2018     : creation of event and listener made generic
****************************************************************************/

#include "CommandToPlugin.h"
#include "clPluginBase.h"

#include "clCameraPlugin.h"
#include "clExternalMediaPlayerPlugin.h"
#include "clSettingsPlugin.h"
#include "clMasterControlPlugin.h"
#include "clRouterPlugin.h"
#include "PluginConstants.h"

#include "plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_APPUTILITIES_COMMANDUTILITIES
#include "trcGenProj/Header/CommandToPlugin.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

/************************************************************************
*NAME        : CommandToPlugin
*DESCRIPTION : Design section 8.3.6 - CommandToPlugin
************************************************************************/
CommandToPlugin::CommandToPlugin()
{
   ETG_TRACE_USR4(("CommandToPlugin::CommandToPlugin()"));
}

/************************************************************************
*NAME        : ~CommandToPlugin
*DESCRIPTION : Design section 8.3.6 - CommandToPlugin
************************************************************************/
CommandToPlugin::~CommandToPlugin()
{
   ETG_TRACE_USR4(("CommandToPlugin::~CommandToPlugin()"));
}

/************************************************************************
*NAME        : poGetInstance
*DESCRIPTION : Design section 8.3.6 - CommandToPlugin
************************************************************************/
CommandToPlugin* CommandToPlugin::poGetInstance()
{
   ETG_TRACE_USR4(("CommandToPlugin::poGetInstance()"));
   static CommandToPlugin cmdToPluginInstance;

   return &cmdToPluginInstance;
}

/************************************************************************
*NAME        : sendEventToPlugin
*DESCRIPTION : Design section 8.3.6 - CommandToPlugin
************************************************************************/
void CommandToPlugin::sendEventToPlugin(const string& plugInName,const string& controlBlockName,const boost::shared_ptr<EventDataUtility>& eValue)
{
   ETG_TRACE_USR4(("CommandToPlugin::sendEventToPlugin(), Plugin name: %s", plugInName.c_str()));
   ETG_TRACE_USR4(("CommandToPlugin::sendEventToPlugin(), Control block name: %s", controlBlockName.c_str()));


	if(strcmp(plugInName.c_str(),"Camera") == 0)
   {
		clCameraPlugin *ptr  = clCameraPlugin::getInstance();
		if(ptr == NULL)
		{
			ETG_TRACE_USR4(("CommandToPlugin::Plugin Instance is NULL"));
			return;
		}
		ETG_TRACE_USR4(("CommandToPlugin::sendEventToPlugin(), Sending events to camera plugin"));
        pthread_mutex_lock(&m_thMutexLock);
		std::unique_ptr<HandlerRegistration>handler(std::move(ptr->addPluginEventHandler()));
		std::unique_ptr<Event> pluginEvent(ptr->getPluginEvent(this,controlBlockName,eValue));
		EventBus::FireEvent(*pluginEvent.get());
		handler->removeHandler();
        pthread_mutex_unlock(&m_thMutexLock);
	}
	else if( strcmp(plugInName.c_str(),"Media") == 0)
	{
		clExternalMediaPlayerPlugin *ptr  = clExternalMediaPlayerPlugin::getInstance();
		if(ptr == NULL)
		{
			ETG_TRACE_USR4(("CommandToPlugin::Plugin Instance is NULL"));
			return;
		}
        pthread_mutex_lock(&m_thMutexLock);
        std::unique_ptr<HandlerRegistration>handler(std::move(ptr->addPluginEventHandler()));
		std::unique_ptr<Event> pluginEvent(ptr->getPluginEvent(this,controlBlockName,eValue));
		EventBus::FireEvent(*pluginEvent.get());
		handler->removeHandler();
        pthread_mutex_unlock(&m_thMutexLock);
	}
	else if( strcmp(plugInName.c_str(),"Settings") == 0)
	{
		clSettingsPlugin *ptr  = clSettingsPlugin::getInstance();
		if(ptr == NULL)
		{
			ETG_TRACE_USR4(("CommandToPlugin::Plugin Instance is NULL"));
			return;
		}
        pthread_mutex_lock(&m_thMutexLock);
        std::unique_ptr<HandlerRegistration>handler(std::move(ptr->addPluginEventHandler()));
		std::unique_ptr<Event> pluginEvent(ptr->getPluginEvent(this,controlBlockName,eValue));
		EventBus::FireEvent(*pluginEvent.get());
		handler->removeHandler();
        pthread_mutex_unlock(&m_thMutexLock);
	}
	else if( strcmp(plugInName.c_str(),"Master") == 0)
	{
		clMasterControlPlugin *ptr  = clMasterControlPlugin::getInstance();
		if(ptr == NULL)
		{
			ETG_TRACE_USR4(("CommandToPlugin::Plugin Instance is NULL"));
			return;
		}
        pthread_mutex_lock(&m_thMutexLock);
        std::unique_ptr<HandlerRegistration>handler(std::move(ptr->addPluginEventHandler()));
		std::unique_ptr<Event> pluginEvent(ptr->getPluginEvent(this,controlBlockName,eValue));
		EventBus::FireEvent(*pluginEvent.get());
		handler->removeHandler();
        pthread_mutex_unlock(&m_thMutexLock);
	}
	else if( strcmp(plugInName.c_str(),"Router") == 0)
	{
		clRouterPlugin *ptr  = clRouterPlugin::getInstance();
		if(ptr == NULL)
		{
			ETG_TRACE_USR4(("CommandToPlugin::Plugin Instance is NULL"));
			return;
		}
        pthread_mutex_lock(&m_thMutexLock);
        std::unique_ptr<HandlerRegistration>handler(std::move(ptr->addPluginEventHandler()));
		std::unique_ptr<Event> pluginEvent(ptr->getPluginEvent(this,controlBlockName,eValue));
		EventBus::FireEvent(*pluginEvent.get());
		handler->removeHandler();
        pthread_mutex_unlock(&m_thMutexLock);
	}
	else{
		ETG_TRACE_USR4(("Plugin String CMP Failed"));
	}

	//}
	//}
}

/************************************************************************
*NAME        : sendListEventToPlugin
*DESCRIPTION : Design section 8.3.6 - CommandToPlugin
************************************************************************/
void CommandToPlugin::sendListEventToPlugin
(
   const string& plugInName,
   const string& controlBlockName,
   const boost::shared_ptr<EventDataUtility>& eData,
   const boost::shared_ptr<EventListDataUtility>& eListData
)
{
   ETG_TRACE_USR4(("CommandToPlugin::sendListEventToPlugin(), Plugin name: %s", plugInName.c_str()));
   ETG_TRACE_USR4(("CommandToPlugin::sendListEventToPlugin(), Control block name: %s", controlBlockName.c_str()));

}

