/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginConstants.h
* COMPONENT NAME      : PluginClientHandler
* DESCRIPTION         : Plugin and control block names
* AUTHOR              : Preethi Alagappan
* Date                : 14.09.2018
* Revision History    : 0.1
* Date 14.09.2018     : Initial version
****************************************************************************/

#ifndef PLUGIN_CONSTANTS_HEADER
#define PLUGIN_CONSTANTS_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

#define PLUGIN_NAME_MEDIA "Media"
#define PLUGIN_NAME_AUDIO "Audio"
#define PLUGIN_NAME_CAMERA "Camera"
#define PLUGIN_NAME_MASTER "Master"
#define PLUGIN_NAME_SETTINGS "Settings"
#define PLUGIN_NAME_ROUTER "Router"
#define STATION_LIST_DATA "StationList"
#define ENTITY_LIST_DATA "EntityList"

#define CTRLBLOCK_NAME_MEDIA_PLAYBACKACTION  "PlaybackAction"
#define CTRBLOCK_NAME_BEEP_VOLUME "BeepVolume"
#define CTRBLOCK_NAME_BEEP_OUTPUT "BeepOutput"

#define CTRLBLOCK_STATION_DATA  "StationData"
#define CTRLBLOCK_ENTITY_DATA  "EntityData"


#define CTRLBLOCK_NAME_AUDIO_CONNECT "Connect"
#define CTRLBLOCK_NAME_AUDIO_DISCONNECT "Disconnect"

#define CTRLBLOCK_NAME_CAMERA_CONNECT "Connect"
#define CTRLBLOCK_NAME_CAMERA_DISCONNECT "Disconnect"
#define CTRLBLOCK_NAME_CAMERA_SPLITVIEW_SEL "CabinSplitViewSel"

#define CTRLBLOCK_NAME_MIX_SOURCE_CHANGE "MixSource"
#define CTRLBLOCK_NAME_MASTER_STREAM_SELECT "StreamSelect"

#define CTRLBLOCK_NAME_SETTINGS_SWIVELUPDOWN "SwivelUpDown"

#define CTRLBLOCK_NAME_SETTINGS_GLASSLCD "GlassLcdOnOff" //Glass  LCD Plugin 

#define CTRLBLOCK_NAME_SETTINGS_CABINAGLASSES "CabinAGlasses"

#define CTRLBLOCK_NAME_SETTINGS_CABINBGLASSES "CabinBGlasses"

#define CTRLBLOCK_NAME_SETTINGS_SWIVELCALIBRATION "SwivelCalibration"

#define CTRLBLOCK_NAME_SETTINGS_FADERSETTINGS "FaderSetting"

#define CTRLBLOCK_NAME_CABIN_VOLUME_CHANGE  "OnVolumeControl"

#define CTRBLOCK_NAME_PRESENTATION_TIME_OFFSET "SetPresentationTimeOffset"
#define CTRBLOCK_NAME_MAX_TRANSIT_TIME "SetMaxTransitTime"
#define CMP "CMP"
#define CMA "CMA"
#define CMG "CMG"
#define CMR "CMR"

enum entSourceType
    {		
		entSourceType_CMP   = 1,
		entSourceType_CMR 	= 2,
		
    };
	
enum entSubSourceType
{		
	entSubSourceType_CMP_AUDIO   = 1,
	entSubSourceType_CMP_VIDEO 	= 2,
	entSubSourceType_CMR_AUDIO 	= 3,
	entSubSourceType_CMR_VIDEO 	= 4,
	
};

enum entDbState
    {	
         USB_Disconnected = 0,
         USB_Connected = 1,
         DB_Invalid = 2,
         DB_InPreparation = 3,
		 DB_Valid = 4,	
		
    };
	
enum entPlayState
    {		
		entPlayState_PlayError   = 1,
		entPlayState_PlaySuccess 	= 2,
    };

#endif
