/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : VariantReader.cpp
* COMPONENT Name      : dbus_variant_helper
* DESCRIPTION         : Wrapper class for MessageIterReader. Reads data from variant
* AUTHOR              : Preethi Alagappan
* Date                : 10.09.2018
* Revision History    : 0.1
* Date 10.09.2018     : Initial version
* Revision History    : 0.2
* Date 25.10.2018     : Dynamic memory allocation for sub iterator
*                     : Modified method signature for container related functions
*                     : Added new method get_array_uint8() and get_double()
****************************************************************************/

#include "VariantReader.h"
#include "VariantReader.h"
#include "../plugin_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS  TR_CLASS_APPUTILITIES_DBUSVARIANTHANDLER
#include "trcGenProj/Header/VariantReader.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN

/************************************************************************
*NAME        : VariantReader
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
VariantReader::VariantReader()
{
   ETG_TRACE_USR4(("VariantReader::VariantReader()"));
}

/************************************************************************
*NAME        : VariantReader
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
VariantReader::VariantReader(::asf::dbus::DBusVariant& variant)
{
	ETG_TRACE_USR4(("VariantReader::VariantReader()"));
	DBusMessageIter *readItser = variant.getReadIterator();
	MessageIterReader *iter = new MessageIterReader(readItser);
	stackIter.push(iter);
}

/************************************************************************
*NAME        : ~VariantReader
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
VariantReader::~VariantReader()
{
	ETG_TRACE_USR4(("VariantReader::~VariantReader()"));
	while(false == stackIter.empty())
	{
		MessageIterReader* iter = stackIter.top();
		stackIter.pop();
		if(NULL != iter)
		{
			delete iter;
		}
	}
}

/************************************************************************
*NAME        : at_end
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::at_end()
{
	ETG_TRACE_USR4(("VariantReader::at_end()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->at_end();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_bool
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_bool(bool* value)
{
	ETG_TRACE_USR4(("VariantReader::get_bool()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_bool(value);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_uint8
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_uint8(uint8* value)
{
	ETG_TRACE_USR4(("VariantReader::get_uint8()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_uint8(value);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_uint16
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_uint16(uint16* value)
{
	ETG_TRACE_USR4(("VariantReader::get_uint16()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_uint16(value);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_uint32
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_uint32(uint32* value)
{
	ETG_TRACE_USR4(("VariantReader::get_uint32()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_uint32(value);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_uint64
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_uint64(uint64* value)
{
   ETG_TRACE_USR4(("VariantReader::get_uint64()"));
   bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      retVal = iter->get_uint64(value);
      iter->goto_next();
   }
   return retVal;
}

/************************************************************************
*NAME        : get_double
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_double(double* value)
{
   ETG_TRACE_USR4(("VariantReader::get_double()"));
   bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      retVal = iter->get_double(value);
      iter->goto_next();
   }
   return retVal;
}

/************************************************************************
*NAME        : get_string
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_string(std::string* value)
{
	ETG_TRACE_USR4(("VariantReader::get_string()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_string(value);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_array_uint8
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_array_uint8(uint8** values, int* numElems)
{
	ETG_TRACE_USR4(("VariantReader::get_array_uint8()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_array_uint8(values, numElems);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_array_uint16
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_array_uint16(uint16** values, int* numElems)
{
	ETG_TRACE_USR4(("VariantReader::get_array_uint16()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_array_uint16(values, numElems);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_array_uint32
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_array_uint32(uint32** values, int* numElems)
{
	ETG_TRACE_USR4(("VariantReader::get_array_uint32()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_array_uint32(values, numElems);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : get_array_uint8
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_array_uint8(std::vector<uint8>* values)
{
   ETG_TRACE_USR4(("VariantReader::get_array_uint8()"));
   bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      retVal = iter->get_array_uint8(values);
      iter->goto_next();
   }
   return retVal;
}

/************************************************************************
*NAME        : get_array_uint16
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_array_uint16(std::vector<uint16>* values)
{
   ETG_TRACE_USR4(("VariantReader::get_array_uint16()"));
   bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      retVal = iter->get_array_uint16(values);
      iter->goto_next();
   }
   return retVal;
}

/************************************************************************
*NAME        : get_array_uint32
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_array_uint32(std::vector<uint32>* values)
{
   ETG_TRACE_USR4(("VariantReader::get_array_uint32()"));
   bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      retVal = iter->get_array_uint32(values);
      iter->goto_next();
   }
   return retVal;
}

/************************************************************************
*NAME        : get_array_string
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::get_array_string(std::vector<std::string>* values)
{
	ETG_TRACE_USR4(("VariantReader::get_array_string()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		retVal = iter->get_array_string(values);
		iter->goto_next();
	}
	return retVal;
}

/************************************************************************
*NAME        : open_array
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::open_array()
{
	ETG_TRACE_USR4(("VariantReader::open_array()"));
	bool retVal = false;
	MessageIterReader* iter = stackIter.top();
	if(NULL != iter)
	{
		MessageIterReader* subIter = new MessageIterReader();
		if(NULL != subIter)
		{
		   retVal = iter->open_array(subIter);
         if(true == retVal)
         {
            stackIter.push(subIter);
         }
         else
         {
            delete subIter;
            subIter = NULL;
         }
		}
	}
	return retVal;
}

/************************************************************************
*NAME        : open_variant
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::open_variant()
{
   ETG_TRACE_USR4(("VariantReader::open_variant()"));
   bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      MessageIterReader* subIter = new MessageIterReader();
      if(NULL != subIter)
      {
         retVal = iter->open_variant(subIter);
         if(true == retVal)
         {
            stackIter.push(subIter);
         }
         else
         {
            delete subIter;
            subIter = NULL;
         }
      }
   }
   return retVal;
}

/************************************************************************
*NAME        : open_struct
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::open_struct()
{
   ETG_TRACE_USR4(("VariantReader::open_struct()"));
   bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      MessageIterReader* subIter = new MessageIterReader();
      if(NULL != subIter)
      {
         retVal = iter->open_struct(subIter);
         if(true == retVal)
         {
            stackIter.push(subIter);
         }
         else
         {
            delete subIter;
            subIter = NULL;
         }
      }
   }
   return retVal;
}

/************************************************************************
*NAME        : open_dict_entry
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
bool VariantReader::open_dict_entry()
{
	ETG_TRACE_USR4(("VariantReader::open_dict_entry()"));
	bool retVal = false;
   MessageIterReader* iter = stackIter.top();
   if(NULL != iter)
   {
      MessageIterReader* subIter = new MessageIterReader();
      if(NULL != subIter)
      {
         retVal = iter->open_dict_entry(subIter);
         if(true == retVal)
         {
            stackIter.push(subIter);
         }
         else
         {
            delete subIter;
            subIter = NULL;
         }
      }
   }
   return retVal;
}

/************************************************************************
*NAME        : close_array
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
void VariantReader::close_array()
{
	ETG_TRACE_USR4(("VariantReader::close_array()"));
	close_container();
}

/************************************************************************
*NAME        : close_variant
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
void VariantReader::close_variant()
{
	ETG_TRACE_USR4(("VariantReader::close_variant()"));
	close_container();
}

/************************************************************************
*NAME        : close_struct
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
void VariantReader::close_struct()
{
	ETG_TRACE_USR4(("VariantReader::close_struct()"));
	close_container();
}

/************************************************************************
*NAME        : close_dict_entry
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/
void VariantReader::close_dict_entry()
{
	ETG_TRACE_USR4(("VariantReader::close_dict_entry()"));
	close_container();
}

/************************************************************************
*NAME        : close_container
*DESCRIPTION : Design section 8.2.2.2 - VariantReader
************************************************************************/	
void VariantReader::close_container()
{
	ETG_TRACE_USR4(("VariantReader::close_container()"));
	MessageIterReader* subIter = stackIter.top();
	stackIter.pop();
	if(NULL != subIter)
   {
      delete subIter;
      subIter = NULL;
   }

	MessageIterReader* iter = stackIter.top();
	if((NULL != iter) && (false == iter->at_end()))
	{
      iter->goto_next();
	}
}
