/************************************************************************
 * FILE:         regBPRegistry.cpp
 * PROJECT:      VASCO
 * SW-COMPONENT: REG
 *----------------------------------------------------------------------
 * DESCRIPTION:  Encapsulation of Blaupunkt's BR211 CE-Registry
 *
 *               The registry is needed for initialisation of BR211
 *               message queues at system setup (see scd-library).
 *----------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 03.04.01  |   Initial revision                     | Bruns,EFG32
 *
 *************************************************************************/

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define SYSTEM_S_IMPORT_INTERFACE_REGISTRY
#include "system_pif.h"
#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"


//-----------------------------------------------------------------------------
// reg_tclService
//-----------------------------------------------------------------------------
reg_tclService::reg_tclService()
{
}


reg_tclService::reg_tclService(const reg_tclRegKey &oOrigin)
: reg_tclRegKey(oOrigin)
{
}


reg_tclService::~reg_tclService()
{
   reg_tclRegKey::vClose(); //lint !e1551: Function may throw exception
}



tBool reg_tclService::bGetName(tChar *pcBuffer, tU32 u32MaxLen) const
{
   return bGetLastKeyName(pcBuffer, u32MaxLen);
}



tBool reg_tclService::bGetID(tU32 *u32SvcID)
{
   return bQueryU32(REGVALUE_SERVICEID, u32SvcID);
}

//-----------------------------------------------------------------------------
// reg_tclApplication
//-----------------------------------------------------------------------------
reg_tclApplication::reg_tclApplication()
{
}


reg_tclApplication::reg_tclApplication(const reg_tclRegKey &oOrigin)
: reg_tclRegKey(oOrigin)
{
}


reg_tclApplication::~reg_tclApplication()
{
   reg_tclRegKey::vClose(); //lint !e1551: Function may throw exception
}


tBool reg_tclApplication::bAddService(const tChar *pcocSvcName, tU32 u32SvcID) const
{
   tBool bSuccess = FALSE;

   reg_tclApplication oTempAppKey;
   // assign parent key (this)
   oTempAppKey.bOpen(*this);

   if(oTempAppKey.bRelCreate(REGKEY_SERVICES) == TRUE)
   {
      if(oTempAppKey.bRelCreate(pcocSvcName) == TRUE)
      {
         bSuccess  = oTempAppKey.bSetU32(REGVALUE_SERVICEID, u32SvcID);
      }
   }
   
   return bSuccess;
}

tBool reg_tclApplication::bSetConfig (tU16 u16AppID,  tU32 u32MaxCount)
{
   tBool bSuccess = FALSE;
   reg_tclRegKey oTempKey;
   bSuccess  = bSetU32(REGVALUE_MAXMCOUNT,u32MaxCount);

   bSuccess = bSuccess && bSetU32(REGVALUE_APPID, u16AppID);
   return bSuccess;
}


tBool reg_tclApplication::bGetName(tChar *pcBuffer, tU32 u32MaxLen) const
{
   return bGetLastKeyName(pcBuffer, u32MaxLen);
}


tBool reg_tclApplication::bGetID(tU16 *u16AppID)
{
   tU32 u32LocAppID=0;
   tBool bLocRetVal;
   bLocRetVal = bQueryU32(REGVALUE_APPID, &u32LocAppID);
   *u16AppID  = (tU16)u32LocAppID;
   return(bLocRetVal);
}

tBool reg_tclApplication::bGetType(tU16 *u16AppType)
{
   tU32 u32LocAppType=0;
   tBool bLocRetVal;
   bLocRetVal  = bQueryU32(REGVALUE_APPTYPE, &u32LocAppType);
   *u16AppType = (tU16)u32LocAppType;
   return(bLocRetVal);
}

tBool reg_tclApplication::bGetMaxMCount (tU32 *u32MaxMCount)
{
   tBool bLocRetVal;
   bLocRetVal = bQueryU32(REGVALUE_MAXMCOUNT, u32MaxMCount);
   return(bLocRetVal);
}

tBool reg_tclApplication::bGetMaxMSize (tU32 *u32MaxMSize)
{
   (*u32MaxMSize) = sizeof(OSAL_trMessage);
   return TRUE;
}

//-----------------------------------------------------------------------------
// reg_tclAppConfig
//-----------------------------------------------------------------------------


reg_tclAppConfig::reg_tclAppConfig()
{
}


reg_tclAppConfig::reg_tclAppConfig(const reg_tclRegKey &oOrigin)
: reg_tclRegKey() //-- do not copy oOrigin to base object. That would open the 
                  //   root (oOrigin) path instead of the config path
{
   (tVoid)reg_tclRegKey::bOpen(oOrigin, REGKEY_AIF_CONFIG); //-- open the config path directly
}


reg_tclAppConfig::~reg_tclAppConfig()
{
   reg_tclRegKey::vClose(); //lint !e1551: Function may throw exception
}

tBool  reg_tclAppConfig::bSetConfig (tU32 u32WdgTime,
                                     tU32 u32IBoxCount)
{
   tBool bSuccess = FALSE;
   reg_tclRegKey oTempKey;

   bSuccess = bSetU32(REGVALUE_WATCHDOG_INTERVALL, u32WdgTime);
   bSuccess = bSuccess && bSetU32(REGVALUE_MSG_COUNT_INTERMEDIATE_MBX,   u32IBoxCount);

   return bSuccess;
}

tBool reg_tclAppConfig::bGetMsgCountIMbx (tU32 *u32StackSize)
{
  return bQueryU32(REGVALUE_MSG_COUNT_INTERMEDIATE_MBX, u32StackSize);
}

tBool reg_tclAppConfig::bGetWatchdogInterval (tU32 *u32StackSize)
{
  return bQueryU32(REGVALUE_WATCHDOG_INTERVALL, u32StackSize);
}

/*****************************************************************************
 * reg_tclProcess
 *
 * "HKEY_LOCAL_MACHINE\\SOFTWARE\\BLAUPUNKT\\PROCESS"
 *****************************************************************************/
reg_tclProcess::reg_tclProcess()
{
}


reg_tclProcess::reg_tclProcess(const reg_tclRegKey &oOrigin)
: reg_tclRegKey(oOrigin)
{
}


reg_tclProcess::~reg_tclProcess()
{
   reg_tclRegKey::vClose(); //lint !e1551: Function may throw exception
}


tBool reg_tclProcess::bGetName(tChar *pcBuffer, tU32 u32MaxLen) const
{
   return bGetLastKeyName(pcBuffer, u32MaxLen);
}


tBool reg_tclProcess::bGetVersion(tU32 *u32Version)
{
   return bQueryU32(REGKEY_VERSION, u32Version);
}

tBool reg_tclProcess::bAddApp(reg_tclApplication *pAppKey,
                              const tChar *pcocAppName) const
{
   tBool bSuccess = FALSE;

   // current key "pProcKey" is set to "HKEY_LOCAL_MACHINE" by default constructor
   // create subkey named "pcProcName"
   if(pAppKey->bCreate(pcocAppName) == TRUE)
   {
      bSuccess = TRUE;
   }
   return bSuccess;
}


