/*****************************************************************************
 * FILE:         reg_BR211Registry.h
 *
 * PROJECT:      VASCO
 *
 * SW-COMPONENT: REG (completely OSAL based module)
 *
 *----------------------------------------------------------------------------
 * DESCRIPTION:  Encapsulation of Blaupunkt's Registry
 *
 *               The registry is needed for initialisation of
 *               message queues at system setup (see scd-library).
 *
 * REMARK:       description of registry can (currently) be found in 
 *               V:\Vasco\Docs\Teams\SystemManagement&Middleware\specs\
 *               inBearbeitung\persistenteKonzepte\registry.xls
 *
 *----------------------------------------------------------------------------
 * COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
 * HISTORY:      
 * Date      |   Modification                         | Author
 * 03.04.01  |   Initial revision                     | Bruns,EFG32
 * 10.07.01  |   Fixed definitions of reg keys        | Bruns,EFG32
 * 01.04.03  |   defines moved to system_registry.h   | Fischer, CM-DI/ESA1
 *           |    reg_tclBR211Registry deleted        |
 * 02.04.03  |   priority and stacksize deleted from  | Fischer, CM-DI/ESA1
 *           |    reg_tclAppConfig                    |
 *****************************************************************************/

#ifndef REG_BR211REGISTRY_H
   #define REG_BR211REGISTRY_H


//-----------------------------------------------------------------------------
// reg_tclService
//
// information held in registry for every "Service"
//-----------------------------------------------------------------------------
class reg_tclService : public reg_tclRegKey
{
public:
                        reg_tclService ();
                        reg_tclService (const reg_tclRegKey &oOrigin);
   virtual              ~reg_tclService ();
   tBool                bGetName       (tChar *pcBuffer, tU32 u32MaxLen) const;
   tBool                bGetID         (tU32 *u32SvcID);
};

//-----------------------------------------------------------------------------
// reg_tclAppConfig
//
// information held in registry for every "AIL_CONFIG"
//-----------------------------------------------------------------------------
class reg_tclAppConfig : public reg_tclRegKey
{
public:
                        reg_tclAppConfig     ();
                        reg_tclAppConfig     (const reg_tclRegKey &oOrigin);
   virtual              ~reg_tclAppConfig     ();
   tBool                bGetMsgCountIMbx     (tU32 *u32Count);
   tBool                bGetWatchdogInterval (tU32 *u32WdgTime);
   tBool                bSetConfig           (tU32 u32WdgTime,
												          tU32 u32IBoxCount);
};



//-----------------------------------------------------------------------------
// reg_tclApplication
//
// information held in registry for every "Application"
//-----------------------------------------------------------------------------
class reg_tclApplication : public reg_tclRegKey
{
public:
                        reg_tclApplication   ();
                        reg_tclApplication   (const reg_tclRegKey &oOrigin);
   virtual              ~reg_tclApplication   ();

   tBool                bGetName             (tChar *pcBuffer, tU32 u32MaxLen) const;
   tBool                bGetID               (tU16 *u16AppID);
   tBool                bGetType             (tU16 *u16AppType);

   tBool                bGetMaxMCount        (tU32 *u32MaxMCount);
   tBool                bGetMaxMSize         (tU32 *u32MaxMSize);
   tBool                bSetConfig           (tU16 u16AppID, tU32 u32MaxCount);

   tBool                bAddService          (const tChar *pcocSvcName, tU32 u32SvcID) const;
};



//-----------------------------------------------------------------------------
// reg_tclProcess
//
// information held in registry for every "Process"
//-----------------------------------------------------------------------------
class reg_tclProcess : public reg_tclRegKey
{
public:
                        reg_tclProcess ();
                        reg_tclProcess (const reg_tclRegKey &oOrigin);
   virtual              ~reg_tclProcess ();
   tBool                bGetName       (tChar *pcBuffer, tU32 u32MaxLen) const;
   tBool                bGetVersion    (tU32 *u32Version);
   tBool                bAddApp        (reg_tclApplication *pAppKey,
                                        const tChar *pcocAppName) const;

};


#endif //REG_BR211REGISTRY_H

