/************************************************************************
 
 *FILE:           alltypes.cpp
 
 *SW-COMPONENT:   FI Functional Interface
 
 *DESCRIPTION:    Interface fuer alle Typdefinitionen
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 ************************************************************************/

#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#if !defined(FI_S_NO_STRING_ACCESS_METHODS) || !defined(FI_S_UTFMODE_TRANSPARENT)
   #define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
   #include "utf_if.h"
#endif

#define FW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "fw_fi_if.h"
fi_tclOutContext& fw_fi_tclU8::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u8Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclU8::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u8Value);
  return oIn;
}

tBool fw_fi_tclU8::operator==(const fw_fi_tclU8& rfoCmp) const
{
   return rfoCmp.u8Value == u8Value;
}

tU32 fw_fi_tclU8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclOutContext& fw_fi_tclS8::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s8Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclS8::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s8Value);
  return oIn;
}

tBool fw_fi_tclS8::operator==(const fw_fi_tclS8& rfoCmp) const
{
   return rfoCmp.s8Value == s8Value;
}

tU32 fw_fi_tclS8::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclOutContext& fw_fi_tclU16::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u16Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclU16::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u16Value);
  return oIn;
}

tBool fw_fi_tclU16::operator==(const fw_fi_tclU16& rfoCmp) const
{
   return rfoCmp.u16Value == u16Value;
}

tU32 fw_fi_tclU16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclOutContext& fw_fi_tclS16::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s16Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclS16::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s16Value);
  return oIn;
}

tBool fw_fi_tclS16::operator==(const fw_fi_tclS16& rfoCmp) const
{
   return rfoCmp.s16Value == s16Value;
}

tU32 fw_fi_tclS16::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclOutContext& fw_fi_tclU24::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u24Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclU24::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u24Value);
  return oIn;
}

tBool fw_fi_tclU24::operator==(const fw_fi_tclU24& rfoCmp) const
{
   return rfoCmp.u24Value == u24Value; //lint !e1702
}

tU32 fw_fi_tclU24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclOutContext& fw_fi_tclS24::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s24Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclS24::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s24Value);
  return oIn;
}

tBool fw_fi_tclS24::operator==(const fw_fi_tclS24& rfoCmp) const
{
   return rfoCmp.s24Value == s24Value; //lint !e1702
}

tU32 fw_fi_tclS24::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclOutContext& fw_fi_tclU32::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u32Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclU32::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u32Value);
  return oIn;
}

tBool fw_fi_tclU32::operator==(const fw_fi_tclU32& rfoCmp) const
{
   return rfoCmp.u32Value == u32Value;
}

tU32 fw_fi_tclU32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fw_fi_tclU64::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(u64Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclU64::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(u64Value);
  return oIn;
}

tBool fw_fi_tclU64::operator==(const fw_fi_tclU64& rfoCmp) const
{
   return rfoCmp.u64Value == u64Value;
}

tU32 fw_fi_tclU64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclOutContext& fw_fi_tclS32::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s32Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclS32::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s32Value);
  return oIn;
}

tBool fw_fi_tclS32::operator==(const fw_fi_tclS32& rfoCmp) const
{
   return rfoCmp.s32Value == s32Value;
}

tU32 fw_fi_tclS32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fw_fi_tclS64::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(s64Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclS64::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(s64Value);
  return oIn;
}

tBool fw_fi_tclS64::operator==(const fw_fi_tclS64& rfoCmp) const
{
   return rfoCmp.s64Value == s64Value;
}

tU32 fw_fi_tclS64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclOutContext& fw_fi_tclF32::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(f32Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclF32::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(f32Value);
  return oIn;
}

tBool fw_fi_tclF32::operator==(const fw_fi_tclF32& rfoCmp) const
{
   return rfoCmp.f32Value == f32Value; //lint !e777
}

tU32 fw_fi_tclF32::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fw_fi_tclF64::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(f64Value);
  return oOut;
}

fi_tclInContext& fw_fi_tclF64::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(f64Value);
  return oIn;
}

tBool fw_fi_tclF64::operator==(const fw_fi_tclF64& rfoCmp) const
{
   return rfoCmp.f64Value == f64Value; //lint !e777
}

tU32 fw_fi_tclF64::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 8;
}

fi_tclOutContext& fw_fi_tclBool::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(bValue);
  return oOut;
}

fi_tclInContext& fw_fi_tclBool::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(bValue);
  return oIn;
}

tBool fw_fi_tclBool::operator==(const fw_fi_tclBool& rfoCmp) const
{
   return rfoCmp.bValue == bValue;
}

tU32 fw_fi_tclBool::u32GetSize(tU16 /*u16MajorVersion*/) const
{
  return 1;
}

fi_tclOutContext& fw_fi_tclString::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(szValue);
  return oOut;
}

tVoid fw_fi_tclString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tclString::~fw_fi_tclString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

fw_fi_tclString& fw_fi_tclString::operator=(const fw_fi_tclString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

fw_fi_tclString::fw_fi_tclString(const fw_fi_tclString& coRef):fw_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& fw_fi_tclString::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(szValue);
  return oIn;
}

tBool fw_fi_tclString::operator==(const fw_fi_tclString& rfoCmp) const
{
   if ((szValue == OSAL_NULL) || (rfoCmp.szValue == OSAL_NULL))
   {
      if (szValue == rfoCmp.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(rfoCmp.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,rfoCmp.szValue));
   }
}

tU32 fw_fi_tclString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
fw_fi_tclString& fw_fi_tclString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = (tString)(const_cast<char*>(coszString));
#endif
   return *this;
}

//fi_tclString::fi_tclString(const tString& coszString) // ADDED (changed from const tString to const tString&)
fw_fi_tclString::fw_fi_tclString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool fw_fi_tclString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

fw_fi_tclString::operator tString&() // ADDED
{
   return szValue;
}

fw_fi_tclString::operator const tChar* () const // ADDED
{
   return szValue;
}

static tChar fw_FI_C_U8_NULLCHAR = '\0';

tChar* fw_fi_tclString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* fw_fi_tclString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* fw_fi_tclString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& fw_fi_tclString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return fw_FI_C_U8_NULLCHAR;
}

tChar& fw_fi_tclString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return fw_FI_C_U8_NULLCHAR;
}

tChar& fw_fi_tclString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return fw_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool fw_fi_tclString::bSet(const fw_fi_tclString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool fw_fi_tclString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
case FI_EN_ISO8859_1M :
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = util_u32ConvertISO8859_1Mod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            util_u32ConvertISO8859_1Mod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
   return bSuccess;
}

tString fw_fi_tclString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

fi_tclOutContext& fw_fi_tclList::oWrite(fi_tclOutContext& oOut) const 
{
   // --Schreibe die Listenlaenge in den Kontext
   oOut.oWrite(u32ListSize);
   return oOut;
}

fi_tclInContext& fw_fi_tclList::oRead(fi_tclInContext& oIn) 
{
  // --Lese die Listenlaenge aus dem Kontext
  oIn.oRead(u32ListSize);
  return oIn;
}

tBool fw_fi_tclList::operator==(const fw_fi_tclList& rfoCmp) const
{
   return rfoCmp.u32ListSize == u32ListSize;
}

tU32 fw_fi_tclList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclOutContext& fw_fi_tclMultiLanguageString::oWrite(fi_tclOutContext& oOut) const 
{
  oOut.oWrite(szValue);
  return oOut;
}

tVoid fw_fi_tclMultiLanguageString::vDestroy() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tclMultiLanguageString::~fw_fi_tclMultiLanguageString() 
{
  OSAL_DELETE[] szValue;
  szValue = OSAL_NULL;
}

fw_fi_tclMultiLanguageString& fw_fi_tclMultiLanguageString::operator=(const fw_fi_tclMultiLanguageString& coRef)
{
   if (this == &coRef) return *this;

   OSAL_DELETE[] szValue;
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
	  if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
   return *this;
}

fw_fi_tclMultiLanguageString::fw_fi_tclMultiLanguageString(const fw_fi_tclMultiLanguageString& coRef):fw_fi_tclVisitableTypeBase(coRef)
{
   if (coRef.szValue != OSAL_NULL)
   {
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coRef.szValue) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue != OSAL_NULL)
      {
         (void)OSAL_szStringCopy(szValue,coRef.szValue);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
}
#endif

fi_tclInContext& fw_fi_tclMultiLanguageString::oRead(fi_tclInContext& oIn) 
{
  oIn.oRead(szValue);
  return oIn;
}

tBool fw_fi_tclMultiLanguageString::operator==(const fw_fi_tclMultiLanguageString& rfoCmp) const
{
   if ((szValue == OSAL_NULL) || (rfoCmp.szValue == OSAL_NULL))
   {
      if (szValue == rfoCmp.szValue)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(rfoCmp.szValue) == 0);
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,rfoCmp.szValue));
   }
}

tU32 fw_fi_tclMultiLanguageString::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return FI_u32StringLength(szValue) + 1;
}

#ifndef FI_DO_NOT_USE_TSTRING
fw_fi_tclMultiLanguageString& fw_fi_tclMultiLanguageString::operator=(tCString coszString) // ADDED
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      // nothing to convert, just copy (UTF-8) string into member field
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coszString) + 1;
      OSAL_DELETE[] szValue;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }
#else
   szValue = (tString)(const_cast<char*>(coszString));
#endif
   return *this;
}

//fi_tclMultiLanguageString::fi_tclMultiLanguageString(const tString& coszString) // ADDED (changed from const tString to const tString&)
fw_fi_tclMultiLanguageString::fw_fi_tclMultiLanguageString(tCString coszString) // ADDED (changed from const tString& to tCString)
{
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   if (coszString != OSAL_NULL)
   {
      tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coszString) + 1;
      szValue = OSAL_NEW tChar[u32UTFStringLength];
      if (szValue)
      {
         (void)OSAL_szStringCopy(szValue,coszString);
      }
   }
   else
   {
      szValue = OSAL_NULL;
   }
#else
   szValue = const_cast<tString>(coszString);
#endif
}

tBool fw_fi_tclMultiLanguageString::operator==(tCString coszString) const // ADDED
{
   if ((szValue == OSAL_NULL) || (coszString == OSAL_NULL))
   {
      if (szValue == coszString)
      {
         return TRUE;
      }
      else
      {
         if (szValue == OSAL_NULL)
         {
            return (OSAL_u32StringLength(coszString) == 0); //lint !e668 : same constellation as in other compare operator, which is ok for LINT
         }
         else
         {
            return (OSAL_u32StringLength(szValue) == 0);
         }
      }
   }
   else
   {
      return (0 == strcmp(szValue,coszString));
   }
}

fw_fi_tclMultiLanguageString::operator tString&() // ADDED
{
   return szValue;
}

fw_fi_tclMultiLanguageString::operator const tChar* () const // ADDED
{
   return szValue;
}

// I don't understand this != operator and as we get this compiler warning 
//   => "warning : cast to pointer from integer of different size [-Wint-to-pointer-cast]"
// I remove the entire operator method as it doesn't seems to be used.
#if 0
tBool fw_fi_tclMultiLanguageString::operator!=(intptr_t iNULL) const// ADDED
{
   return szValue != (char*)iNULL;
}
#endif

tChar* fw_fi_tclMultiLanguageString::operator+(int iOffset) // ADDED
{
   if (szValue)
      return szValue + iOffset;
   else
      return OSAL_NULL;
}

tChar* fw_fi_tclMultiLanguageString::operator+(tU8  u8Offset) // ADDED
{
   if (szValue)
      return szValue + u8Offset;
   else
      return OSAL_NULL;
}

tChar* fw_fi_tclMultiLanguageString::operator+(tU32 u32Offset) // ADDED
{
   if (szValue)
      return szValue + u32Offset;
   else
      return OSAL_NULL;
}

tChar& fw_fi_tclMultiLanguageString::operator[](tU16 u16Index) //ADDED
{
   if (szValue)
      return szValue[u16Index];
   else
      return fw_FI_C_U8_NULLCHAR;
}

tChar& fw_fi_tclMultiLanguageString::operator[](tU32 u32Index) //ADDED
{
   if (szValue)
      return szValue[u32Index];
   else
      return fw_FI_C_U8_NULLCHAR;
}

tChar& fw_fi_tclMultiLanguageString::operator[](tS32 s32Index) //ADDED
{
   if (szValue)
      return szValue[s32Index];
   else
      return fw_FI_C_U8_NULLCHAR;
}
#endif

#ifndef FI_S_NO_STRING_ACCESS_METHODS

tBool fw_fi_tclMultiLanguageString::bSet(const fw_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet)
{
   return bSet(corfoInit.szValue, enCharSet);
}

//tBool figroup_fi_tclMultiLanguageString::bSet(const tString& coszInit, tenCharSet enCharSet)
tBool fw_fi_tclMultiLanguageString::bSet(tCString coszInit, tenCharSet enCharSet)
{
   tBool bSuccess = true;
   if (coszInit != OSAL_NULL)
   {
   switch (enCharSet)
   {
   case FI_EN_UTF8:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // nothing to convert, just copy UTF-8 string into member field
         tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#else
         // input is UTF8, FI assumes ISO-Mod internally, thus convert input
         tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(coszInit) + 1;
         tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
            0,
            0,
            coszInit,
            u32UTFStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            utfutil_u32ConvertUTF82ISOMod(
               szValue,
               u32ISOStringLength,
               coszInit,
               u32UTFStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_ISO8859_15M:
      {
#ifdef FI_S_UTFMODE_TRANSPARENT
         // input is ISO-Mod, FI assumes UTF8 internally, thus convert input
         tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(coszInit) + 1;
         tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
            0,
            0,
            coszInit,
            u32ISOStringLength
         );
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32UTFStringLength];
         if (szValue)
         {
            utfutil_u32ConvertISOMod2UTF8(
               szValue,
               u32UTFStringLength,
               coszInit,
               u32ISOStringLength
               );
         }
         else
         {
            bSuccess = false;
         }
#else
         // nothing to convert, just copy ISO-Mod string into member field
         tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(coszInit) + 1;
         OSAL_DELETE[] szValue;
         szValue = OSAL_NEW tChar[u32ISOStringLength];
         if (szValue)
         {
            (void)OSAL_szStringCopy(szValue,coszInit);
         }
         else
         {
            bSuccess = false;
         }
#endif
      } break;
   case FI_EN_UNDEFINED:
   default:
      bSuccess = false;
   }
   }
   else
   {
      OSAL_DELETE[] szValue;
      szValue = OSAL_NULL;
   }

   return bSuccess;
}

tString fw_fi_tclMultiLanguageString::szGet(tenCharSet enCharSet) const
{
   tString szRetVal = 0;
   if (OSAL_NULL != szValue)
   {
      switch (enCharSet)
      {
      case FI_EN_UTF8:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // nothing to convert, just copy internal member value
            tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#else
            // internal member is ISO-Mod, export as UTF8
            tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(szValue) + 1;
            tU32 u32UTFStringLength = utfutil_u32ConvertISOMod2UTF8(
               0,
               0,
               szValue,
               u32ISOStringLength
               );
            szRetVal = OSAL_NEW tChar[u32UTFStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertISOMod2UTF8(
                  szRetVal,
                  u32UTFStringLength,
                  szValue,
                  u32ISOStringLength
                  );
            }
#endif
         } break;
      case FI_EN_ISO8859_15M:
         {
#ifdef FI_S_UTFMODE_TRANSPARENT
            // internal member is UTF8, export as ISO-Mod
            tU32 u32UTFStringLength = (tU32)OSAL_u32StringLength(szValue) + 1;
            tU32 u32ISOStringLength = utfutil_u32ConvertUTF82ISOMod(
               0,
               0,
               szValue,
               u32UTFStringLength
               );
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               utfutil_u32ConvertUTF82ISOMod(
                  szRetVal,
                  u32ISOStringLength,
                  szValue,
                  u32UTFStringLength
                  );
            }
#else
            // nothing to convert, just copy internal member value
            tU32 u32ISOStringLength = (tU32)OSAL_u32StringLength(szValue) + 1;
            szRetVal = OSAL_NEW tChar[u32ISOStringLength];
            if (szRetVal)
            {
               (void)OSAL_szStringCopy(szRetVal,szValue);
            }
#endif
         } break;
      case FI_EN_UNDEFINED:
      default:
         szRetVal = OSAL_NULL;
      }
   }
   return szRetVal;
}
#endif

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_BinContainer::fw_fi_tcl_BinContainer(const fw_fi_tcl_BinContainer& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   ContainerDataList = coRef.ContainerDataList;
}
fw_fi_tcl_BinContainer& fw_fi_tcl_BinContainer::operator=(const fw_fi_tcl_BinContainer& coRef)
{
   if (this == &coRef) return *this;
   ContainerDataList = coRef.ContainerDataList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_BinContainer::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_BINCONTAINER;
}

tVoid fw_fi_tcl_BinContainer::vDestroy()
{
   ContainerDataList.clear();
}

tU32 fw_fi_tcl_BinContainer::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return (tU32)(4+ContainerDataList.size()*1);
}

fi_tclInContext& fw_fi_tcl_BinContainer::oRead(fi_tclInContext& oIn)
{
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      ContainerDataList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> ContainerDataList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_BinContainer::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << (tU32)ContainerDataList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < ContainerDataList.size(); ++u32Idx)
         (tVoid) (oOut << ContainerDataList[u32Idx]);
   }
   return oOut;
}

tBool fw_fi_tcl_BinContainer::operator==(const fw_fi_tcl_BinContainer& rfoCmp) const
{
   tBool bResult = true;
      bResult = bResult && (ContainerDataList.size() == rfoCmp.ContainerDataList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < ContainerDataList.size()); ++u32Idx)
            bResult = bResult && (ContainerDataList[u32Idx] == rfoCmp.ContainerDataList[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_Reserved::fw_fi_tcl_Reserved(const fw_fi_tcl_Reserved& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
}
fw_fi_tcl_Reserved& fw_fi_tcl_Reserved::operator=(const fw_fi_tcl_Reserved& coRef)
{
   (tVoid)coRef;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_Reserved::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_RESERVED;
}

tU32 fw_fi_tcl_Reserved::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 0;
}

fi_tclInContext& fw_fi_tcl_Reserved::oRead(fi_tclInContext& oIn)
{
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_Reserved::oWrite(fi_tclOutContext& oOut) const
{
   return oOut;
}

tBool fw_fi_tcl_Reserved::operator==(const fw_fi_tcl_Reserved& /* rfoCmp */) const
{
   tBool bResult = true;
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_u8_Percent::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_U8_PERCENT;
}

tU32 fw_fi_tcl_u8_Percent::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& fw_fi_tcl_u8_Percent::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fw_fi_tcl_u8_Percent::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tBool fw_fi_tcl_u8_Percent::operator==(const fw_fi_tcl_u8_Percent& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_PerThousand::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_PERTHOUSAND;
}

tU32 fw_fi_tcl_s16_PerThousand::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_PerThousand::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_PerThousand::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_PerThousand::operator==(const fw_fi_tcl_s16_PerThousand& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_u16_IndexInReferenceList::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_U16_INDEXINREFERENCELIST;
}

tU32 fw_fi_tcl_u16_IndexInReferenceList::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_u16_IndexInReferenceList::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fw_fi_tcl_u16_IndexInReferenceList::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tBool fw_fi_tcl_u16_IndexInReferenceList::operator==(const fw_fi_tcl_u16_IndexInReferenceList& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_u16_ErrorCode::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_U16_ERRORCODE;
}

tU32 fw_fi_tcl_u16_ErrorCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_u16_ErrorCode::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fw_fi_tcl_u16_ErrorCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tBool fw_fi_tcl_u16_ErrorCode::operator==(const fw_fi_tcl_u16_ErrorCode& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Kilogram::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_KILOGRAM;
}

tU32 fw_fi_tcl_s32_Kilogram::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Kilogram::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Kilogram::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Kilogram::operator==(const fw_fi_tcl_s32_Kilogram& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Pound::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_POUND;
}

tU32 fw_fi_tcl_s32_Pound::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Pound::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Pound::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Pound::operator==(const fw_fi_tcl_s32_Pound& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_Meter::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_METER;
}

tU32 fw_fi_tcl_s16_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_Meter::operator==(const fw_fi_tcl_s16_Meter& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Meter::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_METER;
}

tU32 fw_fi_tcl_s32_Meter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Meter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Meter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Meter::operator==(const fw_fi_tcl_s32_Meter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Yards::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_YARDS;
}

tU32 fw_fi_tcl_s32_Yards::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Yards::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Yards::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Yards::operator==(const fw_fi_tcl_s32_Yards& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Centimeter::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_CENTIMETER;
}

tU32 fw_fi_tcl_s32_Centimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Centimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Centimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Centimeter::operator==(const fw_fi_tcl_s32_Centimeter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Inch::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_INCH;
}

tU32 fw_fi_tcl_s32_Inch::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Inch::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Inch::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Inch::operator==(const fw_fi_tcl_s32_Inch& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Millimeter::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_MILLIMETER;
}

tU32 fw_fi_tcl_s32_Millimeter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Millimeter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Millimeter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Millimeter::operator==(const fw_fi_tcl_s32_Millimeter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Microliter::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_MICROLITER;
}

tU32 fw_fi_tcl_s32_Microliter::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Microliter::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Microliter::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Microliter::operator==(const fw_fi_tcl_s32_Microliter& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Second::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_SECOND;
}

tU32 fw_fi_tcl_s32_Second::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Second::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Second::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Second::operator==(const fw_fi_tcl_s32_Second& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_u16_MilliSecond::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_U16_MILLISECOND;
}

tU32 fw_fi_tcl_u16_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_u16_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fw_fi_tcl_u16_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tBool fw_fi_tcl_u16_MilliSecond::operator==(const fw_fi_tcl_u16_MilliSecond& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_MilliSecond::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_MILLISECOND;
}

tU32 fw_fi_tcl_s32_MilliSecond::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_MilliSecond::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_MilliSecond::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_MilliSecond::operator==(const fw_fi_tcl_s32_MilliSecond& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_POSIXTime::fw_fi_tcl_POSIXTime(const fw_fi_tcl_POSIXTime& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   Time = coRef.Time;
}
fw_fi_tcl_POSIXTime& fw_fi_tcl_POSIXTime::operator=(const fw_fi_tcl_POSIXTime& coRef)
{
   if (this == &coRef) return *this;
   Time = coRef.Time;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_POSIXTime::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_POSIXTIME;
}

tU32 fw_fi_tcl_POSIXTime::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_POSIXTime::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Time);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_POSIXTime::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Time);
   return oOut;
}

tBool fw_fi_tcl_POSIXTime::operator==(const fw_fi_tcl_POSIXTime& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (Time == rfoCmp.Time);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_e8_DST_State::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_E8_DST_STATE;
}

tU32 fw_fi_tcl_e8_DST_State::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& fw_fi_tcl_e8_DST_State::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_e8_DST_State::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tBool fw_fi_tcl_e8_DST_State::operator==(const fw_fi_tcl_e8_DST_State& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_TimeZoneElement::fw_fi_tcl_TimeZoneElement(const fw_fi_tcl_TimeZoneElement& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
}
fw_fi_tcl_TimeZoneElement& fw_fi_tcl_TimeZoneElement::operator=(const fw_fi_tcl_TimeZoneElement& coRef)
{
   if (this == &coRef) return *this;
   Abbreviation_StandardTime = coRef.Abbreviation_StandardTime;
   Abbreviation_DST_in_effect = coRef.Abbreviation_DST_in_effect;
   TimeZoneDifference = coRef.TimeZoneDifference;
   DST_State = coRef.DST_State;
   DSTDifference = coRef.DSTDifference;
   DST_TimeDomain = coRef.DST_TimeDomain;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_TimeZoneElement::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_TIMEZONEELEMENT;
}

tVoid fw_fi_tcl_TimeZoneElement::vDestroy()
{
   Abbreviation_StandardTime.vDestroy();
   Abbreviation_DST_in_effect.vDestroy();
   DST_TimeDomain.clear();
}

tU32 fw_fi_tcl_TimeZoneElement::u32GetSize(tU16 u16MajorVersion) const
{
   return (tU32)(13+Abbreviation_StandardTime.u32GetSize(u16MajorVersion)+Abbreviation_DST_in_effect.u32GetSize(u16MajorVersion)+DST_TimeDomain.size()*1);
}

fi_tclInContext& fw_fi_tcl_TimeZoneElement::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Abbreviation_StandardTime);
   (tVoid) (oIn >> Abbreviation_DST_in_effect);
   (tVoid) (oIn >> TimeZoneDifference);
   (tVoid) (oIn >> DST_State);
   (tVoid) (oIn >> DSTDifference);
   {
      tU32 u32Length;
      tU32 u32Idx;
      (tVoid) (oIn >> u32Length);
      DST_TimeDomain.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> DST_TimeDomain[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_TimeZoneElement::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Abbreviation_StandardTime);
   (tVoid) (oOut << Abbreviation_DST_in_effect);
   (tVoid) (oOut << TimeZoneDifference);
   (tVoid) (oOut << DST_State);
   (tVoid) (oOut << DSTDifference);
   (tVoid) (oOut << (tU32)DST_TimeDomain.size());
   {
      for (tU32 u32Idx = 0; u32Idx < DST_TimeDomain.size(); ++u32Idx)
         (tVoid) (oOut << DST_TimeDomain[u32Idx]);
   }
   return oOut;
}

tBool fw_fi_tcl_TimeZoneElement::operator==(const fw_fi_tcl_TimeZoneElement& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (Abbreviation_StandardTime == rfoCmp.Abbreviation_StandardTime);
   bResult = bResult && (Abbreviation_DST_in_effect == rfoCmp.Abbreviation_DST_in_effect);
   bResult = bResult && (TimeZoneDifference == rfoCmp.TimeZoneDifference);
   bResult = bResult && (DST_State == rfoCmp.DST_State);
   bResult = bResult && (DSTDifference == rfoCmp.DSTDifference);
      bResult = bResult && (DST_TimeDomain.size() == rfoCmp.DST_TimeDomain.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < DST_TimeDomain.size()); ++u32Idx)
            bResult = bResult && (DST_TimeDomain[u32Idx] == rfoCmp.DST_TimeDomain[u32Idx]);
      }
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_KmPerHour::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_KMPERHOUR;
}

tU32 fw_fi_tcl_s16_KmPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_KmPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_KmPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_KmPerHour::operator==(const fw_fi_tcl_s16_KmPerHour& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_MilesPerHour::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_MILESPERHOUR;
}

tU32 fw_fi_tcl_s16_MilesPerHour::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_MilesPerHour::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_MilesPerHour::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_MilesPerHour::operator==(const fw_fi_tcl_s16_MilesPerHour& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_Kelvin::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_KELVIN;
}

tU32 fw_fi_tcl_s16_Kelvin::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_Kelvin::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_Kelvin::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_Kelvin::operator==(const fw_fi_tcl_s16_Kelvin& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Pascal::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_PASCAL;
}

tU32 fw_fi_tcl_s32_Pascal::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Pascal::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Pascal::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Pascal::operator==(const fw_fi_tcl_s32_Pascal& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_FIVersion::fw_fi_tcl_FIVersion(const fw_fi_tcl_FIVersion& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
}
fw_fi_tcl_FIVersion& fw_fi_tcl_FIVersion::operator=(const fw_fi_tcl_FIVersion& coRef)
{
   if (this == &coRef) return *this;
   MajorVersion = coRef.MajorVersion;
   MinorVersion = coRef.MinorVersion;
   PatchVersion = coRef.PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_FIVersion::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_FIVERSION;
}

tU32 fw_fi_tcl_FIVersion::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 3;
}

fi_tclInContext& fw_fi_tcl_FIVersion::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> MajorVersion);
   (tVoid) (oIn >> MinorVersion);
   (tVoid) (oIn >> PatchVersion);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_FIVersion::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << MajorVersion);
   (tVoid) (oOut << MinorVersion);
   (tVoid) (oOut << PatchVersion);
   return oOut;
}

tBool fw_fi_tcl_FIVersion::operator==(const fw_fi_tcl_FIVersion& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (MajorVersion == rfoCmp.MajorVersion);
   bResult = bResult && (MinorVersion == rfoCmp.MinorVersion);
   bResult = bResult && (PatchVersion == rfoCmp.PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Longitude::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_LONGITUDE;
}

tU32 fw_fi_tcl_s32_Longitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Longitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Longitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Longitude::operator==(const fw_fi_tcl_s32_Longitude& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s32_Latitude::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S32_LATITUDE;
}

tU32 fw_fi_tcl_s32_Latitude::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_s32_Latitude::oRead(fi_tclInContext& oIn)
{
   return oIn >> s32Value;
}

fi_tclOutContext& fw_fi_tcl_s32_Latitude::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s32Value;
}

tBool fw_fi_tcl_s32_Latitude::operator==(const fw_fi_tcl_s32_Latitude& rfoCmp) const
{
   return s32Value == rfoCmp.s32Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_PositionWGS84::fw_fi_tcl_PositionWGS84(const fw_fi_tcl_PositionWGS84& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
}
fw_fi_tcl_PositionWGS84& fw_fi_tcl_PositionWGS84::operator=(const fw_fi_tcl_PositionWGS84& coRef)
{
   if (this == &coRef) return *this;
   Longitude = coRef.Longitude;
   Latitude = coRef.Latitude;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_PositionWGS84::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_POSITIONWGS84;
}

tU32 fw_fi_tcl_PositionWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 8;
}

fi_tclInContext& fw_fi_tcl_PositionWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> Longitude);
   (tVoid) (oIn >> Latitude);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_PositionWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << Longitude);
   (tVoid) (oOut << Latitude);
   return oOut;
}

tBool fw_fi_tcl_PositionWGS84::operator==(const fw_fi_tcl_PositionWGS84& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (Longitude == rfoCmp.Longitude);
   bResult = bResult && (Latitude == rfoCmp.Latitude);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_RectangleWGS84::fw_fi_tcl_RectangleWGS84(const fw_fi_tcl_RectangleWGS84& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
}
fw_fi_tcl_RectangleWGS84& fw_fi_tcl_RectangleWGS84::operator=(const fw_fi_tcl_RectangleWGS84& coRef)
{
   if (this == &coRef) return *this;
   LongitudeMin = coRef.LongitudeMin;
   LatitudeMin = coRef.LatitudeMin;
   LongitudeMax = coRef.LongitudeMax;
   LatitudeMax = coRef.LatitudeMax;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_RectangleWGS84::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_RECTANGLEWGS84;
}

tU32 fw_fi_tcl_RectangleWGS84::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 16;
}

fi_tclInContext& fw_fi_tcl_RectangleWGS84::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> LongitudeMin);
   (tVoid) (oIn >> LatitudeMin);
   (tVoid) (oIn >> LongitudeMax);
   (tVoid) (oIn >> LatitudeMax);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_RectangleWGS84::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << LongitudeMin);
   (tVoid) (oOut << LatitudeMin);
   (tVoid) (oOut << LongitudeMax);
   (tVoid) (oOut << LatitudeMax);
   return oOut;
}

tBool fw_fi_tcl_RectangleWGS84::operator==(const fw_fi_tcl_RectangleWGS84& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (LongitudeMin == rfoCmp.LongitudeMin);
   bResult = bResult && (LatitudeMin == rfoCmp.LatitudeMin);
   bResult = bResult && (LongitudeMax == rfoCmp.LongitudeMax);
   bResult = bResult && (LatitudeMax == rfoCmp.LatitudeMax);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_e16_ISOCountryCode::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_E16_ISOCOUNTRYCODE;
}

tU32 fw_fi_tcl_e16_ISOCountryCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_e16_ISOCountryCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_e16_ISOCountryCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tBool fw_fi_tcl_e16_ISOCountryCode::operator==(const fw_fi_tcl_e16_ISOCountryCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_e16_ISOLanguageCode::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_E16_ISOLANGUAGECODE;
}

tU32 fw_fi_tcl_e16_ISOLanguageCode::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_e16_ISOLanguageCode::oRead(fi_tclInContext& oIn)
{
   tU16 u16Value;
   (tVoid) (oIn >> u16Value);
   enType = (tenType)u16Value;
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_e16_ISOLanguageCode::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU16)enType);
}

tBool fw_fi_tcl_e16_ISOLanguageCode::operator==(const fw_fi_tcl_e16_ISOLanguageCode& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_LanguageID::fw_fi_tcl_LanguageID(const fw_fi_tcl_LanguageID& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
}
fw_fi_tcl_LanguageID& fw_fi_tcl_LanguageID::operator=(const fw_fi_tcl_LanguageID& coRef)
{
   if (this == &coRef) return *this;
   ISO639_LanguageCode = coRef.ISO639_LanguageCode;
   ISO3166_CountryCode = coRef.ISO3166_CountryCode;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_LanguageID::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_LANGUAGEID;
}

tU32 fw_fi_tcl_LanguageID::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 4;
}

fi_tclInContext& fw_fi_tcl_LanguageID::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> ISO639_LanguageCode);
   (tVoid) (oIn >> ISO3166_CountryCode);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_LanguageID::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << ISO639_LanguageCode);
   (tVoid) (oOut << ISO3166_CountryCode);
   return oOut;
}

tBool fw_fi_tcl_LanguageID::operator==(const fw_fi_tcl_LanguageID& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (ISO639_LanguageCode == rfoCmp.ISO639_LanguageCode);
   bResult = bResult && (ISO3166_CountryCode == rfoCmp.ISO3166_CountryCode);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_u8_DirectionAbsolute::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_U8_DIRECTIONABSOLUTE;
}

tU32 fw_fi_tcl_u8_DirectionAbsolute::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& fw_fi_tcl_u8_DirectionAbsolute::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fw_fi_tcl_u8_DirectionAbsolute::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tBool fw_fi_tcl_u8_DirectionAbsolute::operator==(const fw_fi_tcl_u8_DirectionAbsolute& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_u8_DirectionRelative::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_U8_DIRECTIONRELATIVE;
}

tU32 fw_fi_tcl_u8_DirectionRelative::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& fw_fi_tcl_u8_DirectionRelative::oRead(fi_tclInContext& oIn)
{
   return oIn >> u8Value;
}

fi_tclOutContext& fw_fi_tcl_u8_DirectionRelative::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u8Value;
}

tBool fw_fi_tcl_u8_DirectionRelative::operator==(const fw_fi_tcl_u8_DirectionRelative& rfoCmp) const
{
   return u8Value == rfoCmp.u8Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_CentiDegree::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_CENTIDEGREE;
}

tU32 fw_fi_tcl_s16_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_CentiDegree::operator==(const fw_fi_tcl_s16_CentiDegree& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_Degree::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_DEGREE;
}

tU32 fw_fi_tcl_s16_Degree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_Degree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_Degree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_Degree::operator==(const fw_fi_tcl_s16_Degree& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_u16_DirectionAbsolute_CentiDegree::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_U16_DIRECTIONABSOLUTE_CENTIDEGREE;
}

tU32 fw_fi_tcl_u16_DirectionAbsolute_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_u16_DirectionAbsolute_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> u16Value;
}

fi_tclOutContext& fw_fi_tcl_u16_DirectionAbsolute_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << u16Value;
}

tBool fw_fi_tcl_u16_DirectionAbsolute_CentiDegree::operator==(const fw_fi_tcl_u16_DirectionAbsolute_CentiDegree& rfoCmp) const
{
   return u16Value == rfoCmp.u16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_s16_DirectionRelative_CentiDegree::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_S16_DIRECTIONRELATIVE_CENTIDEGREE;
}

tU32 fw_fi_tcl_s16_DirectionRelative_CentiDegree::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 2;
}

fi_tclInContext& fw_fi_tcl_s16_DirectionRelative_CentiDegree::oRead(fi_tclInContext& oIn)
{
   return oIn >> s16Value;
}

fi_tclOutContext& fw_fi_tcl_s16_DirectionRelative_CentiDegree::oWrite(fi_tclOutContext& oOut) const
{
   return oOut << s16Value;
}

tBool fw_fi_tcl_s16_DirectionRelative_CentiDegree::operator==(const fw_fi_tcl_s16_DirectionRelative_CentiDegree& rfoCmp) const
{
   return s16Value == rfoCmp.s16Value;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_e8_FuelType::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_E8_FUELTYPE;
}

tU32 fw_fi_tcl_e8_FuelType::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 1;
}

fi_tclInContext& fw_fi_tcl_e8_FuelType::oRead(fi_tclInContext& oIn)
{
   tU8 u8Value;
   (tVoid) (oIn >> u8Value);
   enType = (tenType)u8Value;
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_e8_FuelType::oWrite(fi_tclOutContext& oOut) const
{
   return oOut.oWrite((tU8)enType);
}

tBool fw_fi_tcl_e8_FuelType::operator==(const fw_fi_tcl_e8_FuelType& rfoCmp) const
{
   return enType == rfoCmp.enType;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_ServiceRegistry::fw_fi_tcl_ServiceRegistry(const fw_fi_tcl_ServiceRegistry& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   u16RegisterId = coRef.u16RegisterId;
   u16ServiceId = coRef.u16ServiceId;
   u16ClientAppId = coRef.u16ClientAppId;
   u16ClientSubId = coRef.u16ClientSubId;
   u8ServiceState = coRef.u8ServiceState;
   u16MajorVersion = coRef.u16MajorVersion;
   u16MinorVersion = coRef.u16MinorVersion;
   u16PatchVersion = coRef.u16PatchVersion;
}
fw_fi_tcl_ServiceRegistry& fw_fi_tcl_ServiceRegistry::operator=(const fw_fi_tcl_ServiceRegistry& coRef)
{
   if (this == &coRef) return *this;
   u16RegisterId = coRef.u16RegisterId;
   u16ServiceId = coRef.u16ServiceId;
   u16ClientAppId = coRef.u16ClientAppId;
   u16ClientSubId = coRef.u16ClientSubId;
   u8ServiceState = coRef.u8ServiceState;
   u16MajorVersion = coRef.u16MajorVersion;
   u16MinorVersion = coRef.u16MinorVersion;
   u16PatchVersion = coRef.u16PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_ServiceRegistry::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_SERVICEREGISTRY;
}

tU32 fw_fi_tcl_ServiceRegistry::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& fw_fi_tcl_ServiceRegistry::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16RegisterId);
   (tVoid) (oIn >> u16ServiceId);
   (tVoid) (oIn >> u16ClientAppId);
   (tVoid) (oIn >> u16ClientSubId);
   (tVoid) (oIn >> u8ServiceState);
   (tVoid) (oIn >> u16MajorVersion);
   (tVoid) (oIn >> u16MinorVersion);
   (tVoid) (oIn >> u16PatchVersion);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_ServiceRegistry::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16RegisterId);
   (tVoid) (oOut << u16ServiceId);
   (tVoid) (oOut << u16ClientAppId);
   (tVoid) (oOut << u16ClientSubId);
   (tVoid) (oOut << u8ServiceState);
   (tVoid) (oOut << u16MajorVersion);
   (tVoid) (oOut << u16MinorVersion);
   (tVoid) (oOut << u16PatchVersion);
   return oOut;
}

tBool fw_fi_tcl_ServiceRegistry::operator==(const fw_fi_tcl_ServiceRegistry& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (u16RegisterId == rfoCmp.u16RegisterId);
   bResult = bResult && (u16ServiceId == rfoCmp.u16ServiceId);
   bResult = bResult && (u16ClientAppId == rfoCmp.u16ClientAppId);
   bResult = bResult && (u16ClientSubId == rfoCmp.u16ClientSubId);
   bResult = bResult && (u8ServiceState == rfoCmp.u8ServiceState);
   bResult = bResult && (u16MajorVersion == rfoCmp.u16MajorVersion);
   bResult = bResult && (u16MinorVersion == rfoCmp.u16MinorVersion);
   bResult = bResult && (u16PatchVersion == rfoCmp.u16PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_ServiceReference::fw_fi_tcl_ServiceReference(const fw_fi_tcl_ServiceReference& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   u16RegisterId = coRef.u16RegisterId;
   u16ServiceId = coRef.u16ServiceId;
   u16ServerAppId = coRef.u16ServerAppId;
   u16ServerSubId = coRef.u16ServerSubId;
   u8ServiceState = coRef.u8ServiceState;
   u16MajorVersion = coRef.u16MajorVersion;
   u16MinorVersion = coRef.u16MinorVersion;
   u16PatchVersion = coRef.u16PatchVersion;
}
fw_fi_tcl_ServiceReference& fw_fi_tcl_ServiceReference::operator=(const fw_fi_tcl_ServiceReference& coRef)
{
   if (this == &coRef) return *this;
   u16RegisterId = coRef.u16RegisterId;
   u16ServiceId = coRef.u16ServiceId;
   u16ServerAppId = coRef.u16ServerAppId;
   u16ServerSubId = coRef.u16ServerSubId;
   u8ServiceState = coRef.u8ServiceState;
   u16MajorVersion = coRef.u16MajorVersion;
   u16MinorVersion = coRef.u16MinorVersion;
   u16PatchVersion = coRef.u16PatchVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_ServiceReference::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_SERVICEREFERENCE;
}

tU32 fw_fi_tcl_ServiceReference::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 15;
}

fi_tclInContext& fw_fi_tcl_ServiceReference::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16RegisterId);
   (tVoid) (oIn >> u16ServiceId);
   (tVoid) (oIn >> u16ServerAppId);
   (tVoid) (oIn >> u16ServerSubId);
   (tVoid) (oIn >> u8ServiceState);
   (tVoid) (oIn >> u16MajorVersion);
   (tVoid) (oIn >> u16MinorVersion);
   (tVoid) (oIn >> u16PatchVersion);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_ServiceReference::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16RegisterId);
   (tVoid) (oOut << u16ServiceId);
   (tVoid) (oOut << u16ServerAppId);
   (tVoid) (oOut << u16ServerSubId);
   (tVoid) (oOut << u8ServiceState);
   (tVoid) (oOut << u16MajorVersion);
   (tVoid) (oOut << u16MinorVersion);
   (tVoid) (oOut << u16PatchVersion);
   return oOut;
}

tBool fw_fi_tcl_ServiceReference::operator==(const fw_fi_tcl_ServiceReference& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (u16RegisterId == rfoCmp.u16RegisterId);
   bResult = bResult && (u16ServiceId == rfoCmp.u16ServiceId);
   bResult = bResult && (u16ServerAppId == rfoCmp.u16ServerAppId);
   bResult = bResult && (u16ServerSubId == rfoCmp.u16ServerSubId);
   bResult = bResult && (u8ServiceState == rfoCmp.u8ServiceState);
   bResult = bResult && (u16MajorVersion == rfoCmp.u16MajorVersion);
   bResult = bResult && (u16MinorVersion == rfoCmp.u16MinorVersion);
   bResult = bResult && (u16PatchVersion == rfoCmp.u16PatchVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_ServiceRequest::fw_fi_tcl_ServiceRequest(const fw_fi_tcl_ServiceRequest& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   u16ClientSubId = coRef.u16ClientSubId;
   u16ServiceMajorVersion = coRef.u16ServiceMajorVersion;
   u16ServiceMinorVersion = coRef.u16ServiceMinorVersion;
}
fw_fi_tcl_ServiceRequest& fw_fi_tcl_ServiceRequest::operator=(const fw_fi_tcl_ServiceRequest& coRef)
{
   if (this == &coRef) return *this;
   u16ClientSubId = coRef.u16ClientSubId;
   u16ServiceMajorVersion = coRef.u16ServiceMajorVersion;
   u16ServiceMinorVersion = coRef.u16ServiceMinorVersion;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_ServiceRequest::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_SERVICEREQUEST;
}

tU32 fw_fi_tcl_ServiceRequest::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return 6;
}

fi_tclInContext& fw_fi_tcl_ServiceRequest::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16ClientSubId);
   (tVoid) (oIn >> u16ServiceMajorVersion);
   (tVoid) (oIn >> u16ServiceMinorVersion);
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_ServiceRequest::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16ClientSubId);
   (tVoid) (oOut << u16ServiceMajorVersion);
   (tVoid) (oOut << u16ServiceMinorVersion);
   return oOut;
}

tBool fw_fi_tcl_ServiceRequest::operator==(const fw_fi_tcl_ServiceRequest& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (u16ClientSubId == rfoCmp.u16ClientSubId);
   bResult = bResult && (u16ServiceMajorVersion == rfoCmp.u16ServiceMajorVersion);
   bResult = bResult && (u16ServiceMinorVersion == rfoCmp.u16ServiceMinorVersion);
   return bResult;
}

//=============================================================================

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
fw_fi_tcl_ServerApplication::fw_fi_tcl_ServerApplication(const fw_fi_tcl_ServerApplication& coRef)
   : fw_fi_tclVisitableTypeBase(coRef)
{
   u16AppId = coRef.u16AppId;
   u16ServiceId = coRef.u16ServiceId;
   bDedicatedServer = coRef.bDedicatedServer;
   u8ServerAppState = coRef.u8ServerAppState;
   oServiceRequestList = coRef.oServiceRequestList;
}
fw_fi_tcl_ServerApplication& fw_fi_tcl_ServerApplication::operator=(const fw_fi_tcl_ServerApplication& coRef)
{
   if (this == &coRef) return *this;
   u16AppId = coRef.u16AppId;
   u16ServiceId = coRef.u16ServiceId;
   bDedicatedServer = coRef.bDedicatedServer;
   u8ServerAppState = coRef.u8ServerAppState;
   oServiceRequestList = coRef.oServiceRequestList;
   return *this;
}
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

tS32 fw_fi_tcl_ServerApplication::s32GetTypeId() const
{
   return (tS32) fw_typesfi_tclToken::EN_SERVERAPPLICATION;
}

tVoid fw_fi_tcl_ServerApplication::vDestroy()
{
   {
      for (tU32 u32Idx = 0; u32Idx < oServiceRequestList.size(); ++u32Idx)
         oServiceRequestList[u32Idx].vDestroy();
   }
   oServiceRequestList.clear();
}

tU32 fw_fi_tcl_ServerApplication::u32GetSize(tU16 /*u16MajorVersion*/) const
{
   return (tU32)(10+oServiceRequestList.size()*6);
}

fi_tclInContext& fw_fi_tcl_ServerApplication::oRead(fi_tclInContext& oIn)
{
   (tVoid) (oIn >> u16AppId);
   (tVoid) (oIn >> u16ServiceId);
   (tVoid) (oIn >> bDedicatedServer);
   (tVoid) (oIn >> u8ServerAppState);
   {
      tU32 u32Length;
      tU32 u32Idx;
#ifndef VARIANT_S_FTR_ENABLE_DEEP_COPY
      for (u32Idx = 0; u32Idx < oServiceRequestList.size(); ++u32Idx)
      {
         oServiceRequestList[u32Idx].vDestroy();
      }
#endif // !VARIANT_S_FTR_ENABLE_DEEP_COPY
      (tVoid) (oIn >> u32Length);
      oServiceRequestList.resize(u32Length);
      for (u32Idx = 0; u32Idx < u32Length; ++u32Idx)
      {
         (tVoid) (oIn >> oServiceRequestList[u32Idx]);
      }
   }
   return oIn;
}

fi_tclOutContext& fw_fi_tcl_ServerApplication::oWrite(fi_tclOutContext& oOut) const
{
   (tVoid) (oOut << u16AppId);
   (tVoid) (oOut << u16ServiceId);
   (tVoid) (oOut << bDedicatedServer);
   (tVoid) (oOut << u8ServerAppState);
   (tVoid) (oOut << (tU32)oServiceRequestList.size());
   {
      for (tU32 u32Idx = 0; u32Idx < oServiceRequestList.size(); ++u32Idx)
         (tVoid) (oOut << oServiceRequestList[u32Idx]);
   }
   return oOut;
}

tBool fw_fi_tcl_ServerApplication::operator==(const fw_fi_tcl_ServerApplication& rfoCmp) const
{
   tBool bResult = true;
   bResult = bResult && (u16AppId == rfoCmp.u16AppId);
   bResult = bResult && (u16ServiceId == rfoCmp.u16ServiceId);
   bResult = bResult && (bDedicatedServer == rfoCmp.bDedicatedServer);
   bResult = bResult && (u8ServerAppState == rfoCmp.u8ServerAppState);
      bResult = bResult && (oServiceRequestList.size() == rfoCmp.oServiceRequestList.size());
      if (bResult)
      {
         for (tU32 u32Idx = 0; bResult && (u32Idx < oServiceRequestList.size()); ++u32Idx)
            bResult = bResult && (oServiceRequestList[u32Idx] == rfoCmp.oServiceRequestList[u32Idx]);
      }
   return bResult;
}

