#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_TYPES
#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_SERVICEINFO
#include "fw_fi_if.h"

#include "alltypefactory.h"

fi_tclTypeBase* fw_fi_poGetFIObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclTypeBase *poRetType = OSAL_NULL;
   fi_tclMessageBase* poType = OSAL_NULL;
   poType = fw_fi_poGetMessageBaseObject(u16ServiceId, u16FunctionId, u8Opcode);
   if (poType)
   {
      poRetType = &poType->rfoGetTypeBase();
   }
   return poRetType;
}

fi_tclMessageBase* fw_fi_poGetMessageBaseObject(tU16 u16ServiceId, tU16 u16FunctionId, tU8 u8Opcode)
{
   fi_tclMessageBase* poRetType = OSAL_NULL;
   switch(u16ServiceId)
   {
   case FW_AILFI_C_U16_SERVICE_ID:
      switch ((u16FunctionId << 16u) + (u8Opcode << 8u))
      {
      case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTSTATUS:
         poRetType = OSAL_NEW fw_ailfi_tclMsgServiceRegistryListStatus;
         break;
      case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTGET:
         poRetType = OSAL_NEW fw_ailfi_tclMsgServiceRegistryListGet;
         break;
      case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTSTATUS:
         poRetType = OSAL_NEW fw_ailfi_tclMsgServiceReferenceListStatus;
         break;
      case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTGET:
         poRetType = OSAL_NEW fw_ailfi_tclMsgServiceReferenceListGet;
         break;
      case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTSTATUS:
         poRetType = OSAL_NEW fw_ailfi_tclMsgServerApplicationListStatus;
         break;
      case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTGET:
         poRetType = OSAL_NEW fw_ailfi_tclMsgServerApplicationListGet;
         break;
      default: 
         poRetType = OSAL_NULL;
      }
      break;
   default: 
      poRetType = OSAL_NULL;
   }
   return poRetType;
}

