/************************************************************************
 
 *FILE:           alltypes.h
 
 *SW-COMPONENT:   FI, framework for Functional Interface
 
 *DESCRIPTION:    Interface for all types defined in the different FIs
                  
 *AUTHOR:         Jochen Bruns (CM-DI/ENS41)
 
 *COPYRIGHT:      (c) 2001 Blaupunkt GmbH
 
 *HISTORY:
           $ Log $
 * 
 *    Rev 1.0   Oct 7 2001 17:16:00   bnj2hi
 * Initial revision
 *  
 ************************************************************************/

#ifndef FW_ALLFITYPES_HEADER
#define FW_ALLFITYPES_HEADER

#include <vector>


class fw_fi_tclVisitorBase;

const tU16 FW_FI_C_U16_ERROR_INTERNALFAILURE = 1;
const tU16 FW_FI_C_U16_ERROR_INVALIDBINCONTAINERWRONGVERSION = 2;
const tU16 FW_FI_C_U16_ERROR_INVALIDBINCONTAINERUNEXPECTEDDATA = 3;

class fw_fi_tclTypeBase : public fi_tclTypeBase
{
public:
  fw_fi_tclTypeBase() {}
  virtual ~fw_fi_tclTypeBase() {}
   
  virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& /*oVisitor*/) {}
};

class fw_fi_tclVisitableTypeBase :public fw_fi_tclTypeBase
{
public:
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& /*oVisitor*/) {}
};

class fw_fi_tclU8 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclU8():u8Value(0) {}
   tU8 u8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclU8& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_U8;}
};

class fw_fi_tclS8 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclS8():s8Value(0) {}
   tS8 s8Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclS8& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_S8;}
};

class fw_fi_tclU16 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclU16():u16Value(0) {}
   tU16 u16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclU16& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_U16;}
};

class fw_fi_tclS16 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclS16():s16Value(0) {}
   tS16 s16Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclS16& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_S16;}
};

class fw_fi_tclU24 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclU24():u24Value(0) {}
   tU24 u24Value;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclU24& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_U24;}
};

class fw_fi_tclS24 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclS24():s24Value(0) {}
   tS24 s24Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclS24& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_S24;}
};

class fw_fi_tclU32 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclU32():u32Value(0) {}
   tU32 u32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclU32& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_U32;}
};

class fw_fi_tclS32 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclS32():s32Value(0) {}
   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclS32& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_S32;}
};

class fw_fi_tclU64 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclU64():u64Value(0) {}
   tU64 u64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclU64& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_U64;}
};

class fw_fi_tclS64 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclS64():s64Value(0) {}
   tS64 s64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclS64& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_S64;}
};

class fw_fi_tclF32 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclF32():f32Value(0) {}
   tFloat f32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclF32& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_F32;}
};

class fw_fi_tclF64 : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclF64():f64Value(0) {}
   tDouble f64Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclF64& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_F64;}
};

class fw_fi_tclBool : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclBool():bValue(0) {}
   tBool bValue;

   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclBool& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_BOOL;}
};

class fw_fi_tclString : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tclString(const fw_fi_tclString& coRef);
   fw_fi_tclString& operator=(const fw_fi_tclString& coRef);
   virtual ~fw_fi_tclString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclString& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   fw_fi_tclString& operator=(tCString coszString); // ADDED
   fw_fi_tclString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(int iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8,
      FI_EN_ISO8859_1M
   };
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const fw_fi_tclString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};

class fw_fi_tclList : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclList():u32ListSize(0) {}
   tU32 u32ListSize;
   
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclList& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oIn);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_LIST;}
};

class fw_fi_tclMultiLanguageString : public fw_fi_tclVisitableTypeBase
{
public:
   fw_fi_tclMultiLanguageString():szValue(0) {}
#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tclMultiLanguageString(const fw_fi_tclMultiLanguageString& coRef);
   fw_fi_tclMultiLanguageString& operator=(const fw_fi_tclMultiLanguageString& coRef);
   virtual ~fw_fi_tclMultiLanguageString();
#endif

   tString szValue;

   virtual void vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion = 0) const;
   virtual tBool operator==(const fw_fi_tclMultiLanguageString& oCmp) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& oOutContext) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& oOutContext);
   virtual void vTakeVisitor(fw_fi_tclVisitorBase& oVisitor);
#ifndef FI_DO_NOT_USE_TSTRING
   fw_fi_tclMultiLanguageString& operator=(tCString coszString); // ADDED
   fw_fi_tclMultiLanguageString(tCString coszInit); //ADDED
   tBool operator==(tCString coszString) const; // ADDED
   operator const tChar* () const; // ADDED
   operator tString&(); // ADDED
   tBool operator!=(intptr_t iNULL) const; // ADDED
   tChar* operator+(int iOffset); // ADDED
   tChar* operator+(tU8  u8Offset); // ADDED
   tChar* operator+(tU32 u32Offset); // ADDED
   tChar& operator[](tU16 u16Index); //ADDED
   tChar& operator[](tU32 u32Index); //ADDED
   tChar& operator[](tS32 s32Index); //ADDED
#endif
   enum tenCharSet {
      FI_EN_UNDEFINED = 0,
      FI_EN_ISO8859_15M,
      FI_EN_UTF8
   };
   virtual tS32 s32GetTypeId() const { return fw_typesfi_tclToken::EN_STRING;}
   /* The following functions are used to import string values into FI-objects
    * and to export strings from FI-Objects.
    * The character encoding (ISO-Modified or UTF8) is provided as parameter
    * Attention: string values are copied by these functions, thus incoming and/or
    * outgoing strings have to be deleted externally.
    */
   tBool bSet(const fw_fi_tclMultiLanguageString& corfoInit, tenCharSet enCharSet);
   tBool bSet(tCString coszInit, tenCharSet enCharSet);
   tString szGet(tenCharSet enCharSet) const;
};
class fw_fi_tcl_BinContainer;
class fw_fi_tcl_Reserved;
class fw_fi_tcl_u8_Percent;
class fw_fi_tcl_s16_PerThousand;
class fw_fi_tcl_u16_IndexInReferenceList;
class fw_fi_tcl_u16_ErrorCode;
class fw_fi_tcl_s32_Kilogram;
class fw_fi_tcl_s32_Pound;
class fw_fi_tcl_s16_Meter;
class fw_fi_tcl_s32_Meter;
class fw_fi_tcl_s32_Yards;
class fw_fi_tcl_s32_Centimeter;
class fw_fi_tcl_s32_Inch;
class fw_fi_tcl_s32_Millimeter;
class fw_fi_tcl_s32_Microliter;
class fw_fi_tcl_s32_Second;
class fw_fi_tcl_u16_MilliSecond;
class fw_fi_tcl_s32_MilliSecond;
class fw_fi_tcl_POSIXTime;
class fw_fi_tcl_e8_DST_State;
class fw_fi_tcl_TimeZoneElement;
class fw_fi_tcl_s16_KmPerHour;
class fw_fi_tcl_s16_MilesPerHour;
class fw_fi_tcl_s16_Kelvin;
class fw_fi_tcl_s32_Pascal;
class fw_fi_tcl_FIVersion;
class fw_fi_tcl_s32_Longitude;
class fw_fi_tcl_s32_Latitude;
class fw_fi_tcl_PositionWGS84;
class fw_fi_tcl_RectangleWGS84;
class fw_fi_tcl_e16_ISOCountryCode;
class fw_fi_tcl_e16_ISOLanguageCode;
class fw_fi_tcl_LanguageID;
class fw_fi_tcl_u8_DirectionAbsolute;
class fw_fi_tcl_u8_DirectionRelative;
class fw_fi_tcl_s16_CentiDegree;
class fw_fi_tcl_s16_Degree;
class fw_fi_tcl_u16_DirectionAbsolute_CentiDegree;
class fw_fi_tcl_s16_DirectionRelative_CentiDegree;
class fw_fi_tcl_e8_FuelType;
class fw_fi_tcl_ServiceRegistry;
class fw_fi_tcl_ServiceReference;
class fw_fi_tcl_ServiceRequest;
class fw_fi_tcl_ServerApplication;
class fw_fi_tcl_BinContainer : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_BinContainer() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_BinContainer& operator=(const fw_fi_tcl_BinContainer& coRef);
   fw_fi_tcl_BinContainer(const fw_fi_tcl_BinContainer& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   std::vector<tU8, std::allocator<tU8> > ContainerDataList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_BinContainer& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_Reserved : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_Reserved() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_Reserved& operator=(const fw_fi_tcl_Reserved& coRef);
   fw_fi_tcl_Reserved(const fw_fi_tcl_Reserved& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY


   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_Reserved& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_u8_Percent : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_u8_Percent(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_u8_Percent& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_PerThousand : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_PerThousand(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_PerThousand& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_u16_IndexInReferenceList : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_u16_IndexInReferenceList(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_u16_IndexInReferenceList& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_u16_ErrorCode : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_u16_ErrorCode(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_u16_ErrorCode& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Kilogram : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Kilogram(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Kilogram& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Pound : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Pound(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Pound& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_Meter : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_Meter(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_Meter& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Meter : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Meter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Meter& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Yards : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Yards(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Yards& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Centimeter : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Centimeter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Centimeter& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Inch : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Inch(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Inch& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Millimeter : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Millimeter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Millimeter& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Microliter : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Microliter(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Microliter& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Second : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Second(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Second& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_u16_MilliSecond : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_u16_MilliSecond(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_u16_MilliSecond& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_MilliSecond : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_MilliSecond(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_MilliSecond& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_POSIXTime : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_POSIXTime():Time(0) {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_POSIXTime& operator=(const fw_fi_tcl_POSIXTime& coRef);
   fw_fi_tcl_POSIXTime(const fw_fi_tcl_POSIXTime& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tS32 Time;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_POSIXTime& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_e8_DST_State : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_e8_DST_State():enType(FI_EN_T_STANDARDTIME) {}

   enum tenType {
      FI_EN_T_STANDARDTIME = 0UL,
      FI_EN_T_DAYLIGHTSAVINGTIME = 1UL,
      FI_EN_T_EVALUATIONNECESSARY = 2UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_e8_DST_State& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_TimeZoneElement : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_TimeZoneElement():Abbreviation_StandardTime(0),Abbreviation_DST_in_effect(0),TimeZoneDifference(),DST_State(),DSTDifference() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_TimeZoneElement& operator=(const fw_fi_tcl_TimeZoneElement& coRef);
   fw_fi_tcl_TimeZoneElement(const fw_fi_tcl_TimeZoneElement& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   fw_fi_tclMultiLanguageString Abbreviation_StandardTime;
   fw_fi_tclMultiLanguageString Abbreviation_DST_in_effect;
   fw_fi_tcl_s32_Second TimeZoneDifference;
   fw_fi_tcl_e8_DST_State DST_State;
   fw_fi_tcl_s32_Second DSTDifference;
   std::vector<tU8, std::allocator<tU8> > DST_TimeDomain;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_TimeZoneElement& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_KmPerHour : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_KmPerHour(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_KmPerHour& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_MilesPerHour : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_MilesPerHour(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_MilesPerHour& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_Kelvin : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_Kelvin(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_Kelvin& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Pascal : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Pascal(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Pascal& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_FIVersion : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_FIVersion():MajorVersion(0),MinorVersion(0),PatchVersion(0) {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_FIVersion& operator=(const fw_fi_tcl_FIVersion& coRef);
   fw_fi_tcl_FIVersion(const fw_fi_tcl_FIVersion& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU8 MajorVersion;
   tU8 MinorVersion;
   tU8 PatchVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_FIVersion& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Longitude : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Longitude(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Longitude& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s32_Latitude : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s32_Latitude(tS32 _s32Value = 0):s32Value(_s32Value) {} 

   tS32 s32Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s32_Latitude& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_PositionWGS84 : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_PositionWGS84():Longitude(),Latitude() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_PositionWGS84& operator=(const fw_fi_tcl_PositionWGS84& coRef);
   fw_fi_tcl_PositionWGS84(const fw_fi_tcl_PositionWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   fw_fi_tcl_s32_Longitude Longitude;
   fw_fi_tcl_s32_Latitude Latitude;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_PositionWGS84& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_RectangleWGS84 : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_RectangleWGS84():LongitudeMin(),LatitudeMin(),LongitudeMax(),LatitudeMax() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_RectangleWGS84& operator=(const fw_fi_tcl_RectangleWGS84& coRef);
   fw_fi_tcl_RectangleWGS84(const fw_fi_tcl_RectangleWGS84& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   fw_fi_tcl_s32_Longitude LongitudeMin;
   fw_fi_tcl_s32_Latitude LatitudeMin;
   fw_fi_tcl_s32_Longitude LongitudeMax;
   fw_fi_tcl_s32_Latitude LatitudeMax;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_RectangleWGS84& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_e16_ISOCountryCode : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_e16_ISOCountryCode():enType(FI_EN_ISO_ALPHA_3_UNDEFINED) {}

   enum tenType {
      FI_EN_ISO_ALPHA_3_UNDEFINED = 0UL,
      FI_EN_ISO_ALPHA_3_AFG = 1223UL,
      FI_EN_ISO_ALPHA_3_ALB = 1410UL,
      FI_EN_ISO_ALPHA_3_DZA = 4929UL,
      FI_EN_ISO_ALPHA_3_ASM = 1645UL,
      FI_EN_ISO_ALPHA_3_AND = 1476UL,
      FI_EN_ISO_ALPHA_3_AGO = 1263UL,
      FI_EN_ISO_ALPHA_3_AIA = 1313UL,
      FI_EN_ISO_ALPHA_3_ATG = 1671UL,
      FI_EN_ISO_ALPHA_3_ARG = 1607UL,
      FI_EN_ISO_ALPHA_3_ARM = 1613UL,
      FI_EN_ISO_ALPHA_3_ABW = 1111UL,
      FI_EN_ISO_ALPHA_3_AUS = 1715UL,
      FI_EN_ISO_ALPHA_3_AUT = 1716UL,
      FI_EN_ISO_ALPHA_3_AZE = 1861UL,
      FI_EN_ISO_ALPHA_3_BHS = 2323UL,
      FI_EN_ISO_ALPHA_3_BHR = 2322UL,
      FI_EN_ISO_ALPHA_3_BGD = 2276UL,
      FI_EN_ISO_ALPHA_3_BRB = 2626UL,
      FI_EN_ISO_ALPHA_3_BLR = 2450UL,
      FI_EN_ISO_ALPHA_3_BEL = 2220UL,
      FI_EN_ISO_ALPHA_3_BLZ = 2458UL,
      FI_EN_ISO_ALPHA_3_BEN = 2222UL,
      FI_EN_ISO_ALPHA_3_BMU = 2485UL,
      FI_EN_ISO_ALPHA_3_BTN = 2702UL,
      FI_EN_ISO_ALPHA_3_BOL = 2540UL,
      FI_EN_ISO_ALPHA_3_BIH = 2344UL,
      FI_EN_ISO_ALPHA_3_BWA = 2785UL,
      FI_EN_ISO_ALPHA_3_BRA = 2625UL,
      FI_EN_ISO_ALPHA_3_BRN = 2638UL,
      FI_EN_ISO_ALPHA_3_BGR = 2290UL,
      FI_EN_ISO_ALPHA_3_BFA = 2241UL,
      FI_EN_ISO_ALPHA_3_BDI = 2185UL,
      FI_EN_ISO_ALPHA_3_KHM = 11533UL,
      FI_EN_ISO_ALPHA_3_CMR = 3506UL,
      FI_EN_ISO_ALPHA_3_CAN = 3118UL,
      FI_EN_ISO_ALPHA_3_CPV = 3606UL,
      FI_EN_ISO_ALPHA_3_CYM = 3885UL,
      FI_EN_ISO_ALPHA_3_CAF = 3110UL,
      FI_EN_ISO_ALPHA_3_TCD = 20580UL,
      FI_EN_ISO_ALPHA_3_CHL = 3340UL,
      FI_EN_ISO_ALPHA_3_CHN = 3342UL,
      FI_EN_ISO_ALPHA_3_COL = 3564UL,
      FI_EN_ISO_ALPHA_3_COM = 3565UL,
      FI_EN_ISO_ALPHA_3_COG = 3559UL,
      FI_EN_ISO_ALPHA_3_COD = 3556UL,
      FI_EN_ISO_ALPHA_3_COK = 3563UL,
      FI_EN_ISO_ALPHA_3_CRI = 3657UL,
      FI_EN_ISO_ALPHA_3_CIV = 3382UL,
      FI_EN_ISO_ALPHA_3_HRV = 8790UL,
      FI_EN_ISO_ALPHA_3_CUB = 3746UL,
      FI_EN_ISO_ALPHA_3_CYP = 3888UL,
      FI_EN_ISO_ALPHA_3_CZE = 3909UL,
      FI_EN_ISO_ALPHA_3_DNK = 4555UL,
      FI_EN_ISO_ALPHA_3_DJI = 4425UL,
      FI_EN_ISO_ALPHA_3_DMA = 4513UL,
      FI_EN_ISO_ALPHA_3_DOM = 4589UL,
      FI_EN_ISO_ALPHA_3_ECU = 5237UL,
      FI_EN_ISO_ALPHA_3_EGY = 5369UL,
      FI_EN_ISO_ALPHA_3_SLV = 19862UL,
      FI_EN_ISO_ALPHA_3_GNQ = 7633UL,
      FI_EN_ISO_ALPHA_3_ERI = 5705UL,
      FI_EN_ISO_ALPHA_3_EST = 5748UL,
      FI_EN_ISO_ALPHA_3_ETH = 5768UL,
      FI_EN_ISO_ALPHA_3_FLK = 6539UL,
      FI_EN_ISO_ALPHA_3_FRO = 6735UL,
      FI_EN_ISO_ALPHA_3_FJI = 6473UL,
      FI_EN_ISO_ALPHA_3_FIN = 6446UL,
      FI_EN_ISO_ALPHA_3_FRA = 6721UL,
      FI_EN_ISO_ALPHA_3_GUF = 7846UL,
      FI_EN_ISO_ALPHA_3_PYF = 17190UL,
      FI_EN_ISO_ALPHA_3_GAB = 7202UL,
      FI_EN_ISO_ALPHA_3_GMB = 7586UL,
      FI_EN_ISO_ALPHA_3_GEO = 7343UL,
      FI_EN_ISO_ALPHA_3_DEU = 4277UL,
      FI_EN_ISO_ALPHA_3_GHA = 7425UL,
      FI_EN_ISO_ALPHA_3_GIB = 7458UL,
      FI_EN_ISO_ALPHA_3_GRC = 7747UL,
      FI_EN_ISO_ALPHA_3_GRL = 7756UL,
      FI_EN_ISO_ALPHA_3_GRD = 7748UL,
      FI_EN_ISO_ALPHA_3_GLP = 7568UL,
      FI_EN_ISO_ALPHA_3_GUM = 7853UL,
      FI_EN_ISO_ALPHA_3_GTM = 7821UL,
      FI_EN_ISO_ALPHA_3_GIN = 7470UL,
      FI_EN_ISO_ALPHA_3_GNB = 7618UL,
      FI_EN_ISO_ALPHA_3_GUY = 7865UL,
      FI_EN_ISO_ALPHA_3_HTI = 8841UL,
      FI_EN_ISO_ALPHA_3_VAT = 22580UL,
      FI_EN_ISO_ALPHA_3_HND = 8644UL,
      FI_EN_ISO_ALPHA_3_HKG = 8551UL,
      FI_EN_ISO_ALPHA_3_HUN = 8878UL,
      FI_EN_ISO_ALPHA_3_ISL = 9836UL,
      FI_EN_ISO_ALPHA_3_IND = 9668UL,
      FI_EN_ISO_ALPHA_3_IDN = 9358UL,
      FI_EN_ISO_ALPHA_3_INT = 9684UL,
      FI_EN_ISO_ALPHA_3_IRN = 9806UL,
      FI_EN_ISO_ALPHA_3_IRQ = 9809UL,
      FI_EN_ISO_ALPHA_3_IRL = 9804UL,
      FI_EN_ISO_ALPHA_3_ISR = 9842UL,
      FI_EN_ISO_ALPHA_3_ITA = 9857UL,
      FI_EN_ISO_ALPHA_3_JAM = 10285UL,
      FI_EN_ISO_ALPHA_3_JPN = 10766UL,
      FI_EN_ISO_ALPHA_3_JOR = 10738UL,
      FI_EN_ISO_ALPHA_3_KAZ = 11322UL,
      FI_EN_ISO_ALPHA_3_KEN = 11438UL,
      FI_EN_ISO_ALPHA_3_KIR = 11570UL,
      FI_EN_ISO_ALPHA_3_PRK = 16971UL,
      FI_EN_ISO_ALPHA_3_KOR = 11762UL,
      FI_EN_ISO_ALPHA_3_KWT = 12020UL,
      FI_EN_ISO_ALPHA_3_KGZ = 11514UL,
      FI_EN_ISO_ALPHA_3_LAO = 12335UL,
      FI_EN_ISO_ALPHA_3_LVA = 12993UL,
      FI_EN_ISO_ALPHA_3_LBN = 12366UL,
      FI_EN_ISO_ALPHA_3_LSO = 12911UL,
      FI_EN_ISO_ALPHA_3_LBR = 12370UL,
      FI_EN_ISO_ALPHA_3_LBY = 12377UL,
      FI_EN_ISO_ALPHA_3_LIE = 12581UL,
      FI_EN_ISO_ALPHA_3_LTU = 12949UL,
      FI_EN_ISO_ALPHA_3_LUX = 12984UL,
      FI_EN_ISO_ALPHA_3_MAC = 13347UL,
      FI_EN_ISO_ALPHA_3_MKD = 13668UL,
      FI_EN_ISO_ALPHA_3_MDG = 13447UL,
      FI_EN_ISO_ALPHA_3_MWI = 14057UL,
      FI_EN_ISO_ALPHA_3_MYS = 14131UL,
      FI_EN_ISO_ALPHA_3_MDV = 13462UL,
      FI_EN_ISO_ALPHA_3_MLI = 13705UL,
      FI_EN_ISO_ALPHA_3_MLT = 13716UL,
      FI_EN_ISO_ALPHA_3_MHL = 13580UL,
      FI_EN_ISO_ALPHA_3_MTQ = 13969UL,
      FI_EN_ISO_ALPHA_3_MRT = 13908UL,
      FI_EN_ISO_ALPHA_3_MUS = 14003UL,
      FI_EN_ISO_ALPHA_3_MYT = 14132UL,
      FI_EN_ISO_ALPHA_3_MEX = 13496UL,
      FI_EN_ISO_ALPHA_3_FSM = 6765UL,
      FI_EN_ISO_ALPHA_3_MDA = 13441UL,
      FI_EN_ISO_ALPHA_3_MCO = 13423UL,
      FI_EN_ISO_ALPHA_3_MNG = 13767UL,
      FI_EN_ISO_ALPHA_3_MNE = 13765UL,
      FI_EN_ISO_ALPHA_3_MSR = 13938UL,
      FI_EN_ISO_ALPHA_3_MAR = 13362UL,
      FI_EN_ISO_ALPHA_3_MOZ = 13818UL,
      FI_EN_ISO_ALPHA_3_MMR = 13746UL,
      FI_EN_ISO_ALPHA_3_NAM = 14381UL,
      FI_EN_ISO_ALPHA_3_NRU = 14933UL,
      FI_EN_ISO_ALPHA_3_NPL = 14860UL,
      FI_EN_ISO_ALPHA_3_NLD = 14724UL,
      FI_EN_ISO_ALPHA_3_ANT = 1492UL,
      FI_EN_ISO_ALPHA_3_NCL = 14444UL,
      FI_EN_ISO_ALPHA_3_NZL = 15180UL,
      FI_EN_ISO_ALPHA_3_NIC = 14627UL,
      FI_EN_ISO_ALPHA_3_NER = 14514UL,
      FI_EN_ISO_ALPHA_3_NGA = 14561UL,
      FI_EN_ISO_ALPHA_3_NIU = 14645UL,
      FI_EN_ISO_ALPHA_3_NFK = 14539UL,
      FI_EN_ISO_ALPHA_3_MNP = 13776UL,
      FI_EN_ISO_ALPHA_3_NOR = 14834UL,
      FI_EN_ISO_ALPHA_3_PSE = 16997UL,
      FI_EN_ISO_ALPHA_3_OMN = 15790UL,
      FI_EN_ISO_ALPHA_3_PAK = 16427UL,
      FI_EN_ISO_ALPHA_3_PLW = 16791UL,
      FI_EN_ISO_ALPHA_3_PAN = 16430UL,
      FI_EN_ISO_ALPHA_3_PNG = 16839UL,
      FI_EN_ISO_ALPHA_3_PRY = 16985UL,
      FI_EN_ISO_ALPHA_3_PER = 16562UL,
      FI_EN_ISO_ALPHA_3_PHL = 16652UL,
      FI_EN_ISO_ALPHA_3_PCN = 16494UL,
      FI_EN_ISO_ALPHA_3_POL = 16876UL,
      FI_EN_ISO_ALPHA_3_PRT = 16980UL,
      FI_EN_ISO_ALPHA_3_PRI = 16969UL,
      FI_EN_ISO_ALPHA_3_QAT = 17460UL,
      FI_EN_ISO_ALPHA_3_REU = 18613UL,
      FI_EN_ISO_ALPHA_3_ROU = 18933UL,
      FI_EN_ISO_ALPHA_3_RUS = 19123UL,
      FI_EN_ISO_ALPHA_3_RWA = 19169UL,
      FI_EN_ISO_ALPHA_3_KNA = 11713UL,
      FI_EN_ISO_ALPHA_3_LCA = 12385UL,
      FI_EN_ISO_ALPHA_3_VCT = 22644UL,
      FI_EN_ISO_ALPHA_3_WSM = 24173UL,
      FI_EN_ISO_ALPHA_3_SMR = 19890UL,
      FI_EN_ISO_ALPHA_3_STP = 20112UL,
      FI_EN_ISO_ALPHA_3_SAU = 19509UL,
      FI_EN_ISO_ALPHA_3_SEN = 19630UL,
      FI_EN_ISO_ALPHA_3_SRB = 20034UL,
      FI_EN_ISO_ALPHA_3_SYC = 20259UL,
      FI_EN_ISO_ALPHA_3_SLE = 19845UL,
      FI_EN_ISO_ALPHA_3_SGP = 19696UL,
      FI_EN_ISO_ALPHA_3_SVK = 20171UL,
      FI_EN_ISO_ALPHA_3_SVN = 20174UL,
      FI_EN_ISO_ALPHA_3_SLB = 19842UL,
      FI_EN_ISO_ALPHA_3_SOM = 19949UL,
      FI_EN_ISO_ALPHA_3_ZAF = 26662UL,
      FI_EN_ISO_ALPHA_3_ESP = 5744UL,
      FI_EN_ISO_ALPHA_3_LKA = 12641UL,
      FI_EN_ISO_ALPHA_3_SHN = 19726UL,
      FI_EN_ISO_ALPHA_3_SPM = 19981UL,
      FI_EN_ISO_ALPHA_3_SDN = 19598UL,
      FI_EN_ISO_ALPHA_3_SUR = 20146UL,
      FI_EN_ISO_ALPHA_3_SJM = 19789UL,
      FI_EN_ISO_ALPHA_3_SWZ = 20218UL,
      FI_EN_ISO_ALPHA_3_SWE = 20197UL,
      FI_EN_ISO_ALPHA_3_CHE = 3333UL,
      FI_EN_ISO_ALPHA_3_SYR = 20274UL,
      FI_EN_ISO_ALPHA_3_TWN = 21230UL,
      FI_EN_ISO_ALPHA_3_TJK = 20811UL,
      FI_EN_ISO_ALPHA_3_TZA = 21313UL,
      FI_EN_ISO_ALPHA_3_THA = 20737UL,
      FI_EN_ISO_ALPHA_3_TLS = 20883UL,
      FI_EN_ISO_ALPHA_3_TGO = 20719UL,
      FI_EN_ISO_ALPHA_3_TKL = 20844UL,
      FI_EN_ISO_ALPHA_3_TON = 20974UL,
      FI_EN_ISO_ALPHA_3_TTO = 21135UL,
      FI_EN_ISO_ALPHA_3_TUN = 21166UL,
      FI_EN_ISO_ALPHA_3_TUR = 21170UL,
      FI_EN_ISO_ALPHA_3_TKM = 20845UL,
      FI_EN_ISO_ALPHA_3_TCA = 20577UL,
      FI_EN_ISO_ALPHA_3_TUV = 21174UL,
      FI_EN_ISO_ALPHA_3_UGA = 21729UL,
      FI_EN_ISO_ALPHA_3_UKR = 21874UL,
      FI_EN_ISO_ALPHA_3_ARE = 1605UL,
      FI_EN_ISO_ALPHA_3_GBR = 7250UL,
      FI_EN_ISO_ALPHA_3_USA = 22113UL,
      FI_EN_ISO_ALPHA_3_URY = 22105UL,
      FI_EN_ISO_ALPHA_3_UZB = 22338UL,
      FI_EN_ISO_ALPHA_3_VUT = 23220UL,
      FI_EN_ISO_ALPHA_3_VEN = 22702UL,
      FI_EN_ISO_ALPHA_3_VNM = 22989UL,
      FI_EN_ISO_ALPHA_3_VGB = 22754UL,
      FI_EN_ISO_ALPHA_3_VIR = 22834UL,
      FI_EN_ISO_ALPHA_3_WLF = 23942UL,
      FI_EN_ISO_ALPHA_3_ESH = 5736UL,
      FI_EN_ISO_ALPHA_3_YEM = 25773UL,
      FI_EN_ISO_ALPHA_3_YUG = 26279UL,
      FI_EN_ISO_ALPHA_3_ZMB = 27042UL,
      FI_EN_ISO_ALPHA_3_ZWE = 27365UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_e16_ISOCountryCode& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_e16_ISOLanguageCode : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_e16_ISOLanguageCode():enType(FI_EN_ISO_639_1_UNDEFINED) {}

   enum tenType {
      FI_EN_ISO_639_1_UNDEFINED = 0UL,
      FI_EN_ISO_639_1_AA = 24929UL,
      FI_EN_ISO_639_1_AB = 24930UL,
      FI_EN_ISO_639_1_AE = 24933UL,
      FI_EN_ISO_639_1_AF = 24934UL,
      FI_EN_ISO_639_1_AK = 24939UL,
      FI_EN_ISO_639_1_AM = 24941UL,
      FI_EN_ISO_639_1_AN = 24942UL,
      FI_EN_ISO_639_1_AR = 24946UL,
      FI_EN_ISO_639_1_AS = 24947UL,
      FI_EN_ISO_639_1_AV = 24950UL,
      FI_EN_ISO_639_1_AY = 24953UL,
      FI_EN_ISO_639_1_AZ = 24954UL,
      FI_EN_ISO_639_1_BA = 25185UL,
      FI_EN_ISO_639_1_BE = 25189UL,
      FI_EN_ISO_639_1_BG = 25191UL,
      FI_EN_ISO_639_1_BH = 25192UL,
      FI_EN_ISO_639_1_BI = 25193UL,
      FI_EN_ISO_639_1_BM = 25197UL,
      FI_EN_ISO_639_1_BN = 25198UL,
      FI_EN_ISO_639_1_BO = 25199UL,
      FI_EN_ISO_639_1_BR = 25202UL,
      FI_EN_ISO_639_1_BS = 25203UL,
      FI_EN_ISO_639_1_CA = 25441UL,
      FI_EN_ISO_639_1_CE = 25445UL,
      FI_EN_ISO_639_1_CH = 25448UL,
      FI_EN_ISO_639_1_CN = 25454UL,
      FI_EN_ISO_639_1_CO = 25455UL,
      FI_EN_ISO_639_1_CR = 25458UL,
      FI_EN_ISO_639_1_CS = 25459UL,
      FI_EN_ISO_639_1_CU = 25461UL,
      FI_EN_ISO_639_1_CV = 25462UL,
      FI_EN_ISO_639_1_CY = 25465UL,
      FI_EN_ISO_639_1_DA = 25697UL,
      FI_EN_ISO_639_1_DE = 25701UL,
      FI_EN_ISO_639_1_DV = 25718UL,
      FI_EN_ISO_639_1_DZ = 25722UL,
      FI_EN_ISO_639_1_EE = 25957UL,
      FI_EN_ISO_639_1_EL = 25964UL,
      FI_EN_ISO_639_1_EN = 25966UL,
      FI_EN_ISO_639_1_EO = 25967UL,
      FI_EN_ISO_639_1_ES = 25971UL,
      FI_EN_ISO_639_1_ET = 25972UL,
      FI_EN_ISO_639_1_EU = 25973UL,
      FI_EN_ISO_639_1_FA = 26209UL,
      FI_EN_ISO_639_1_FF = 26214UL,
      FI_EN_ISO_639_1_FI = 26217UL,
      FI_EN_ISO_639_1_FJ = 26218UL,
      FI_EN_ISO_639_1_FO = 26223UL,
      FI_EN_ISO_639_1_FR = 26226UL,
      FI_EN_ISO_639_1_FY = 26233UL,
      FI_EN_ISO_639_1_GA = 26465UL,
      FI_EN_ISO_639_1_GD = 26468UL,
      FI_EN_ISO_639_1_GL = 26476UL,
      FI_EN_ISO_639_1_GN = 26478UL,
      FI_EN_ISO_639_1_GU = 26485UL,
      FI_EN_ISO_639_1_GV = 26486UL,
      FI_EN_ISO_639_1_HA = 26721UL,
      FI_EN_ISO_639_1_HE = 26725UL,
      FI_EN_ISO_639_1_HI = 26729UL,
      FI_EN_ISO_639_1_HO = 26735UL,
      FI_EN_ISO_639_1_HR = 26738UL,
      FI_EN_ISO_639_1_HU = 26741UL,
      FI_EN_ISO_639_1_HY = 26745UL,
      FI_EN_ISO_639_1_HZ = 26746UL,
      FI_EN_ISO_639_1_IA = 26977UL,
      FI_EN_ISO_639_1_ID = 26980UL,
      FI_EN_ISO_639_1_IE = 26981UL,
      FI_EN_ISO_639_1_IG = 26983UL,
      FI_EN_ISO_639_1_II = 26985UL,
      FI_EN_ISO_639_1_IK = 26987UL,
      FI_EN_ISO_639_1_IO = 26991UL,
      FI_EN_ISO_639_1_IS = 26995UL,
      FI_EN_ISO_639_1_IT = 26996UL,
      FI_EN_ISO_639_1_IU = 26997UL,
      FI_EN_ISO_639_1_JA = 27233UL,
      FI_EN_ISO_639_1_JV = 27254UL,
      FI_EN_ISO_639_1_KA = 27489UL,
      FI_EN_ISO_639_1_KG = 27495UL,
      FI_EN_ISO_639_1_KI = 27497UL,
      FI_EN_ISO_639_1_KJ = 27498UL,
      FI_EN_ISO_639_1_KK = 27499UL,
      FI_EN_ISO_639_1_KL = 27500UL,
      FI_EN_ISO_639_1_KM = 27501UL,
      FI_EN_ISO_639_1_KN = 27502UL,
      FI_EN_ISO_639_1_KO = 27503UL,
      FI_EN_ISO_639_1_KR = 27506UL,
      FI_EN_ISO_639_1_KS = 27507UL,
      FI_EN_ISO_639_1_KU = 27509UL,
      FI_EN_ISO_639_1_KV = 27510UL,
      FI_EN_ISO_639_1_KW = 27511UL,
      FI_EN_ISO_639_1_KY = 27513UL,
      FI_EN_ISO_639_1_LA = 27745UL,
      FI_EN_ISO_639_1_LB = 27746UL,
      FI_EN_ISO_639_1_LG = 27751UL,
      FI_EN_ISO_639_1_LI = 27753UL,
      FI_EN_ISO_639_1_LN = 27758UL,
      FI_EN_ISO_639_1_LO = 27759UL,
      FI_EN_ISO_639_1_LT = 27764UL,
      FI_EN_ISO_639_1_LU = 27765UL,
      FI_EN_ISO_639_1_LV = 27766UL,
      FI_EN_ISO_639_1_MG = 28007UL,
      FI_EN_ISO_639_1_MH = 28008UL,
      FI_EN_ISO_639_1_MI = 28009UL,
      FI_EN_ISO_639_1_MK = 28011UL,
      FI_EN_ISO_639_1_ML = 28012UL,
      FI_EN_ISO_639_1_MN = 28014UL,
      FI_EN_ISO_639_1_MO = 28015UL,
      FI_EN_ISO_639_1_MR = 28018UL,
      FI_EN_ISO_639_1_MS = 28019UL,
      FI_EN_ISO_639_1_MT = 28020UL,
      FI_EN_ISO_639_1_MY = 28025UL,
      FI_EN_ISO_639_1_NA = 28257UL,
      FI_EN_ISO_639_1_NB = 28258UL,
      FI_EN_ISO_639_1_ND = 28260UL,
      FI_EN_ISO_639_1_NE = 28261UL,
      FI_EN_ISO_639_1_NG = 28263UL,
      FI_EN_ISO_639_1_NL = 28268UL,
      FI_EN_ISO_639_1_NN = 28270UL,
      FI_EN_ISO_639_1_NO = 28271UL,
      FI_EN_ISO_639_1_NR = 28274UL,
      FI_EN_ISO_639_1_NV = 28278UL,
      FI_EN_ISO_639_1_NY = 28281UL,
      FI_EN_ISO_639_1_OC = 28515UL,
      FI_EN_ISO_639_1_OJ = 28522UL,
      FI_EN_ISO_639_1_OM = 28525UL,
      FI_EN_ISO_639_1_OR = 28530UL,
      FI_EN_ISO_639_1_OS = 28531UL,
      FI_EN_ISO_639_1_PA = 28769UL,
      FI_EN_ISO_639_1_PI = 28777UL,
      FI_EN_ISO_639_1_PL = 28780UL,
      FI_EN_ISO_639_1_PS = 28787UL,
      FI_EN_ISO_639_1_PT = 28788UL,
      FI_EN_ISO_639_1_QU = 29045UL,
      FI_EN_ISO_639_1_RM = 29293UL,
      FI_EN_ISO_639_1_RN = 29294UL,
      FI_EN_ISO_639_1_RO = 29295UL,
      FI_EN_ISO_639_1_RU = 29301UL,
      FI_EN_ISO_639_1_RW = 29303UL,
      FI_EN_ISO_639_1_SA = 29537UL,
      FI_EN_ISO_639_1_SC = 29539UL,
      FI_EN_ISO_639_1_SD = 29540UL,
      FI_EN_ISO_639_1_SE = 29541UL,
      FI_EN_ISO_639_1_SG = 29543UL,
      FI_EN_ISO_639_1_SH = 29544UL,
      FI_EN_ISO_639_1_SI = 29545UL,
      FI_EN_ISO_639_1_SK = 29547UL,
      FI_EN_ISO_639_1_SL = 29548UL,
      FI_EN_ISO_639_1_SM = 29549UL,
      FI_EN_ISO_639_1_SN = 29550UL,
      FI_EN_ISO_639_1_SO = 29551UL,
      FI_EN_ISO_639_1_SQ = 29553UL,
      FI_EN_ISO_639_1_SR = 29554UL,
      FI_EN_ISO_639_1_SS = 29555UL,
      FI_EN_ISO_639_1_ST = 29556UL,
      FI_EN_ISO_639_1_SU = 29557UL,
      FI_EN_ISO_639_1_SV = 29558UL,
      FI_EN_ISO_639_1_SW = 29559UL,
      FI_EN_ISO_639_1_TA = 29793UL,
      FI_EN_ISO_639_1_TE = 29797UL,
      FI_EN_ISO_639_1_TG = 29799UL,
      FI_EN_ISO_639_1_TH = 29800UL,
      FI_EN_ISO_639_1_TI = 29801UL,
      FI_EN_ISO_639_1_TK = 29803UL,
      FI_EN_ISO_639_1_TL = 29804UL,
      FI_EN_ISO_639_1_TN = 29806UL,
      FI_EN_ISO_639_1_TO = 29807UL,
      FI_EN_ISO_639_1_TR = 29810UL,
      FI_EN_ISO_639_1_TS = 29811UL,
      FI_EN_ISO_639_1_TT = 29812UL,
      FI_EN_ISO_639_1_TW = 29815UL,
      FI_EN_ISO_639_1_TY = 29817UL,
      FI_EN_ISO_639_1_UE = 30053UL,
      FI_EN_ISO_639_1_UG = 30055UL,
      FI_EN_ISO_639_1_UK = 30059UL,
      FI_EN_ISO_639_1_UR = 30066UL,
      FI_EN_ISO_639_1_UZ = 30074UL,
      FI_EN_ISO_639_1_VE = 30309UL,
      FI_EN_ISO_639_1_VI = 30313UL,
      FI_EN_ISO_639_1_VO = 30319UL,
      FI_EN_ISO_639_1_WA = 30561UL,
      FI_EN_ISO_639_1_WO = 30575UL,
      FI_EN_ISO_639_1_XH = 30824UL,
      FI_EN_ISO_639_1_YI = 31081UL,
      FI_EN_ISO_639_1_YO = 31087UL,
      FI_EN_ISO_639_1_ZA = 31329UL,
      FI_EN_ISO_639_1_ZH = 31336UL,
      FI_EN_ISO_639_1_ZU = 31349UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_e16_ISOLanguageCode& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_LanguageID : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_LanguageID():ISO639_LanguageCode(),ISO3166_CountryCode() {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_LanguageID& operator=(const fw_fi_tcl_LanguageID& coRef);
   fw_fi_tcl_LanguageID(const fw_fi_tcl_LanguageID& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   fw_fi_tcl_e16_ISOLanguageCode ISO639_LanguageCode;
   fw_fi_tcl_e16_ISOCountryCode ISO3166_CountryCode;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_LanguageID& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_u8_DirectionAbsolute : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_u8_DirectionAbsolute(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_u8_DirectionAbsolute& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_u8_DirectionRelative : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_u8_DirectionRelative(tU8 _u8Value = 0):u8Value(_u8Value) {} 

   tU8 u8Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_u8_DirectionRelative& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_CentiDegree : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_CentiDegree(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_CentiDegree& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_Degree : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_Degree(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_Degree& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_u16_DirectionAbsolute_CentiDegree : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_u16_DirectionAbsolute_CentiDegree(tU16 _u16Value = 0):u16Value(_u16Value) {} 

   tU16 u16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_u16_DirectionAbsolute_CentiDegree& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_s16_DirectionRelative_CentiDegree : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_s16_DirectionRelative_CentiDegree(tS16 _s16Value = 0):s16Value(_s16Value) {} 

   tS16 s16Value;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_s16_DirectionRelative_CentiDegree& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_e8_FuelType : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_e8_FuelType():enType(FI_EN_RESERVED) {}

   enum tenType {
      FI_EN_RESERVED = 0UL,
      FI_EN_PETROL = 1UL,
      FI_EN_DIESEL = 2UL,
      FI_EN_HYDROGEN = 3UL,
      FI_EN_COMPRESSEDNATURALGAS = 4UL,
      FI_EN_LIQUIFIEDPETROLEUMGAS = 5UL
   };
   tenType enType;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_e8_FuelType& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_ServiceRegistry : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_ServiceRegistry():u16RegisterId(0),u16ServiceId(0),u16ClientAppId(0),u16ClientSubId(0),u8ServiceState(0),u16MajorVersion(0),u16MinorVersion(0),u16PatchVersion(0) {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_ServiceRegistry& operator=(const fw_fi_tcl_ServiceRegistry& coRef);
   fw_fi_tcl_ServiceRegistry(const fw_fi_tcl_ServiceRegistry& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RegisterId;
   tU16 u16ServiceId;
   tU16 u16ClientAppId;
   tU16 u16ClientSubId;
   tU8 u8ServiceState;
   tU16 u16MajorVersion;
   tU16 u16MinorVersion;
   tU16 u16PatchVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_ServiceRegistry& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_ServiceReference : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_ServiceReference():u16RegisterId(0),u16ServiceId(0),u16ServerAppId(0),u16ServerSubId(0),u8ServiceState(0),u16MajorVersion(0),u16MinorVersion(0),u16PatchVersion(0) {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_ServiceReference& operator=(const fw_fi_tcl_ServiceReference& coRef);
   fw_fi_tcl_ServiceReference(const fw_fi_tcl_ServiceReference& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16RegisterId;
   tU16 u16ServiceId;
   tU16 u16ServerAppId;
   tU16 u16ServerSubId;
   tU8 u8ServiceState;
   tU16 u16MajorVersion;
   tU16 u16MinorVersion;
   tU16 u16PatchVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_ServiceReference& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_ServiceRequest : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_ServiceRequest():u16ClientSubId(0),u16ServiceMajorVersion(0),u16ServiceMinorVersion(0) {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_ServiceRequest& operator=(const fw_fi_tcl_ServiceRequest& coRef);
   fw_fi_tcl_ServiceRequest(const fw_fi_tcl_ServiceRequest& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16ClientSubId;
   tU16 u16ServiceMajorVersion;
   tU16 u16ServiceMinorVersion;

   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_ServiceRequest& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

class fw_fi_tcl_ServerApplication : public fw_fi_tclVisitableTypeBase
{
public:

   fw_fi_tcl_ServerApplication():u16AppId(0),u16ServiceId(0),bDedicatedServer(0),u8ServerAppState(0) {}

#ifdef VARIANT_S_FTR_ENABLE_DEEP_COPY
   fw_fi_tcl_ServerApplication& operator=(const fw_fi_tcl_ServerApplication& coRef);
   fw_fi_tcl_ServerApplication(const fw_fi_tcl_ServerApplication& coRef);
#endif // VARIANT_S_FTR_ENABLE_DEEP_COPY

   tU16 u16AppId;
   tU16 u16ServiceId;
   tBool bDedicatedServer;
   tU8 u8ServerAppState;
   std::vector<fw_fi_tcl_ServiceRequest, std::allocator<fw_fi_tcl_ServiceRequest> > oServiceRequestList;

   virtual tVoid vDestroy();
   virtual tU32 u32GetSize(tU16 u16MajorVersion FI_DEFAULT_VERSION) const;
   virtual fi_tclOutContext& oWrite(fi_tclOutContext& rfoOut) const;
   virtual fi_tclInContext& oRead(fi_tclInContext& rfoIn);
   virtual tBool operator==(const fw_fi_tcl_ServerApplication& rfoCmp) const;
   virtual tS32 s32GetTypeId() const;
   virtual tVoid vTakeVisitor(fw_fi_tclVisitorBase& rfoVisitor);
};

#endif
