#if (defined OSAL_OS) || (defined OSAL_CONF)
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#else
#include "myosal.h"
#endif

#define FW_FI_S_IMPORT_INTERFACE_FW_AILFI_DBGVISITORS
#include "fw_fi_if.h"

// convert a semantic token into its description text
tCString convertSemToken2Text(fw_ailfi_tclSemanticDomain::tenType token) {
   switch (token)
   {
   case fw_ailfi_tclSemanticDomain::EN_CONTAINERDATALIST:
      return "ContainerDataList";
   case fw_ailfi_tclSemanticDomain::EN_BDEDICATEDSERVER:
      return "bDedicatedServer";
   case fw_ailfi_tclSemanticDomain::EN_OSERVICEREQUESTLIST:
      return "oServiceRequestList";
   case fw_ailfi_tclSemanticDomain::EN_U16APPID:
      return "u16AppId";
   case fw_ailfi_tclSemanticDomain::EN_U16CLIENTAPPID:
      return "u16ClientAppId";
   case fw_ailfi_tclSemanticDomain::EN_U16CLIENTSUBID:
      return "u16ClientSubId";
   case fw_ailfi_tclSemanticDomain::EN_U16MAJORVERSION:
      return "u16MajorVersion";
   case fw_ailfi_tclSemanticDomain::EN_U16MINORVERSION:
      return "u16MinorVersion";
   case fw_ailfi_tclSemanticDomain::EN_U16PATCHVERSION:
      return "u16PatchVersion";
   case fw_ailfi_tclSemanticDomain::EN_U16REGISTERID:
      return "u16RegisterId";
   case fw_ailfi_tclSemanticDomain::EN_U16SERVERAPPID:
      return "u16ServerAppId";
   case fw_ailfi_tclSemanticDomain::EN_U16SERVERSUBID:
      return "u16ServerSubId";
   case fw_ailfi_tclSemanticDomain::EN_U16SERVICEID:
      return "u16ServiceId";
   case fw_ailfi_tclSemanticDomain::EN_U16SERVICEMAJORVERSION:
      return "u16ServiceMajorVersion";
   case fw_ailfi_tclSemanticDomain::EN_U16SERVICEMINORVERSION:
      return "u16ServiceMinorVersion";
   case fw_ailfi_tclSemanticDomain::EN_U8SERVERAPPSTATE:
      return "u8ServerAppState";
   case fw_ailfi_tclSemanticDomain::EN_U8SERVICESTATE:
      return "u8ServiceState";
   case fw_ailfi_tclSemanticDomain::EN_MSG_OSERVERAPPLICATIONLIST:
      return "oServerApplicationList";
   case fw_ailfi_tclSemanticDomain::EN_MSG_OSERVICEREFERENCELIST:
      return "oServiceReferenceList";
   case fw_ailfi_tclSemanticDomain::EN_MSG_OSERVICEREGISTRYLIST:
      return "oServiceRegistryList";
   case fw_ailfi_tclSemanticDomain::EN_DATA_TYPE:
      return "DataType";
   case fw_ailfi_tclSemanticDomain::EN_DATA_MASK:
      return "DataMask";
   case fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT:
      return "DataMask";
   case fw_ailfi_tclSemanticDomain::EN_BINCONTAINER:
      return "BinContainer";
   case fw_ailfi_tclSemanticDomain::EN_UNKNOWN:
   case fw_ailfi_tclSemanticDomain::EN_LAST_SEMANTICDOMAIN:
   default:
      return "unknown semantic";
   }
}

// convert a Token token into its description text
tCString convertTypeToken2Text(fw_ailfi_tclToken::tenType token) 
{
   switch (token)
   {   
   case fw_ailfi_tclToken::EN_LAST_TOKEN:
      return "invalid token";
   case fw_ailfi_tclToken::EN_UNKNOWN:
      return "unknown";
   case fw_ailfi_tclToken::EN_END_OF_STRUCT:
      return "<EOS>";
   case fw_ailfi_tclToken::EN_LIST:
      return "tU32 (list size)";
   case fw_ailfi_tclToken::EN_U8:
      return "tU8";
   case fw_ailfi_tclToken::EN_U16:
      return "tU16";
   case fw_ailfi_tclToken::EN_U24:
      return "tU24";
   case fw_ailfi_tclToken::EN_U32:
      return "tU32";
   case fw_ailfi_tclToken::EN_U64:
      return "tU64";
   case fw_ailfi_tclToken::EN_S8:
      return "tS8";
   case fw_ailfi_tclToken::EN_S16:
      return "tS16";
   case fw_ailfi_tclToken::EN_S24:
      return "tS24";
   case fw_ailfi_tclToken::EN_S32:
      return "tS32";
   case fw_ailfi_tclToken::EN_S64:
      return "tS64";
   case fw_ailfi_tclToken::EN_F32:
      return "tF32";
   case fw_ailfi_tclToken::EN_F64:
      return "tF64";
   case fw_ailfi_tclToken::EN_BOOL:
      return "tBool";
   case fw_ailfi_tclToken::EN_STRING:
      return "tString";
   case fw_ailfi_tclToken::EN_MULTILANGUAGESTRING:
      return "tMultiLanguageString";
//   case navifi_tclToken::EN_BINCONTAINER:
//      return "T_Bincontainer";
   case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTGET:
      return "ServiceRegistryList.Get";
   case fw_ailfi_tclToken::EN_MSG_SERVICEREGISTRYLISTSTATUS:
      return "ServiceRegistryList.Status";
   case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTGET:
      return "ServiceReferenceList.Get";
   case fw_ailfi_tclToken::EN_MSG_SERVICEREFERENCELISTSTATUS:
      return "ServiceReferenceList.Status";
   case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTGET:
      return "ServerApplicationList.Get";
   case fw_ailfi_tclToken::EN_MSG_SERVERAPPLICATIONLISTSTATUS:
      return "ServerApplicationList.Status";
   case fw_ailfi_tclToken::EN_BINCONTAINER:
      return "T_BinContainer";
   case fw_ailfi_tclToken::EN_SERVICEREGISTRY:
      return "T_ServiceRegistry";
   case fw_ailfi_tclToken::EN_SERVICEREFERENCE:
      return "T_ServiceReference";
   case fw_ailfi_tclToken::EN_SERVICEREQUEST:
      return "T_ServiceRequest";
   case fw_ailfi_tclToken::EN_SERVERAPPLICATION:
      return "T_ServerApplication";
   default:
      return "unknown token";
   }
}

// --Implementierungen der Methoden der Besucher-Basisklasse
// visit base types
tVoid fw_ailfi_tclPrintVisitor::vVisitU8(fw_fi_tclU8& oU8) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU8[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//    cout << setw(u32IndentSize*2) << "" << "tU8[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU8 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tU8 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%d\r\n",oU8.u8Value);
//  cout << int(oU8.u8Value) << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitS8(fw_fi_tclS8& oS8) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS8[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tS8[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS8 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tS8 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%d\r\n",oS8.s8Value);
//  cout << int(oS8.s8Value) << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitU16(fw_fi_tclU16& oU16) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU16[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tU16[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU16 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tU16 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%d\r\n",oU16.u16Value);
//  cout << oU16.u16Value << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitS16(fw_fi_tclS16& oS16) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS16[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tS16[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS16 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tS16 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%d\r\n",oS16.s16Value);
//  cout << oS16.s16Value << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitU24(fw_fi_tclU24& oU24) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU24[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tU24[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU24 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tU24 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%ul\r\n",oU24.u24Value.u24Value);
//  cout << oU24.u24Value << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitS24(fw_fi_tclS24& oS24) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS24[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tU24[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS24 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tU24 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%d\r\n",oS24.s24Value.s24Value);
//  cout << oS24.s24Value << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitU32(fw_fi_tclU32& oU32) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU32[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tU32[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU32 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tU32 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%u\r\n",oU32.u32Value);
//  cout << oU32.u32Value << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitS32(fw_fi_tclS32& oS32) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS32[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tS32[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS32 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tS32 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%d\r\n",oS32.s32Value);
//  cout << oS32.s32Value << "\n";
  poOutput->vPrintLine(line);
}

#if (OSAL_OS == OSAL_WINNT)
tVoid fw_ailfi_tclPrintVisitor::vVisitU64(fw_fi_tclU64& oU64) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU64[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tU64[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stU64 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tU32 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%I64u\r\n",oU64.u64Value);
//  cout << oU32.u32Value << "\n";
  poOutput->vPrintLine(line);
}
#else
tVoid fw_ailfi_tclPrintVisitor::vVisitU64(fw_fi_tclU64& /*oU64*/) {
}
#endif

#if (OSAL_OS == OSAL_WINNT)
tVoid fw_ailfi_tclPrintVisitor::vVisitS64(fw_fi_tclS64& oS64) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS64[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tS64[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stS64 %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tS64 " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%I64d\r\n",oS64.s64Value);
//  cout << oS32.s32Value << "\n";
  poOutput->vPrintLine(line);
}
#else
tVoid fw_ailfi_tclPrintVisitor::vVisitS64(fw_fi_tclS64& /*oS64*/) {
}
#endif

tVoid fw_ailfi_tclPrintVisitor::vVisitBool(fw_fi_tclBool& oBool) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stBool[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tBool[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stBool %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tBool " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%s\r\n",(oBool.bValue)?"TRUE":"FALSE");
//  cout << oBool.bValue << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitString(fw_fi_tclString& oString) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stString[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tString[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stString %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tString " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  if (s32LineLength < 255)
  {
    s32LineLength += OSALUTIL_s32SaveNPrintFormat(line+s32LineLength,(tU32)(255 - s32LineLength),"%s\r\n",oString.szValue);
  }
//  cout << oString.szValue << "\n";
  poOutput->vPrintLine(line);
}

tVoid fw_ailfi_tclPrintVisitor::vVisitMultiLanguageString(fw_fi_tclMultiLanguageString& oString) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stString[%u] = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "tString[" << oIterator.u32ListIndex() << "] = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*stString %s = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << "tString " << convertSemToken2Text(enSemanticDomain) << " = ";
  }
  if (s32LineLength < 255)
  {
    s32LineLength += OSALUTIL_s32SaveNPrintFormat(line+s32LineLength,(tU32)(255 - s32LineLength),"%s\r\n",oString.szValue);
  }
//  cout << oString.szValue << "\n";
  poOutput->vPrintLine(line);
}

// visit lists 
tVoid fw_ailfi_tclPrintVisitor::vVisitList(fw_fi_tclList& oList) {
  //navifi_tclToken::tenType enToken=oIterator.oKnot().enToken;
  fw_ailfi_tclSemanticDomain::tenType enSemanticDomain=oIterator.oKnot().enSemanticDomain;
  tU32 u32IndentSize=oIterator.u32Position();
  tS32 s32LineLength = 0;
  if (enSemanticDomain == fw_ailfi_tclSemanticDomain::EN_LIST_ELEMENT) {
    s32LineLength = OSAL_s32PrintFormat(line,"%*sList[%u] listSize = ",(int)u32IndentSize*2,"",oIterator.oKnot().u32Index);
//	cout << setw(u32IndentSize*2) << "" << "List[" << oIterator.u32ListIndex() << "] listSize = ";
  } else {
    s32LineLength = OSAL_s32PrintFormat(line,"%*s%s listSize = ",(int)u32IndentSize*2,"",convertSemToken2Text(enSemanticDomain));
//    cout << setw(u32IndentSize*2) << "" << convertSemToken2Text(enSemanticDomain) << " listSize = ";
  }
  s32LineLength += OSAL_s32PrintFormat(line+s32LineLength,"%u\r\n",oList.u32ListSize);
//  cout << oList.u32ListSize << "\n";
  poOutput->vPrintLine(line);
}

// visit rest of types
// #include "printvisitor.cpp"

// visit rest of types
