

#ifndef AES_WRITER_H
#define AES_WRITER_H

#ifdef USE_DIRECT_OS
   #define SYSTEM_S_IMPORT_INTERFACE_TYPES
   #include "system_pif.h"
#else
   #define OSAL_S_IMPORT_INTERFACE_TYPES
   #include "osal_if.h"
#endif
// #define OSAL_S_IMPORT_INTERFACE_TYPES
// #include "osal_if.h"
#include "osabstraction.h"

class AES;

class AESWriter
{
   private:
      FileHandle m_hFile;

      tU32 m_u32NumBytesWritten;
      tU32 m_u32BlocksWritten;

      AES *m_poAES;

      /** in byte */
      static const tU32 BLOCKSIZE = 16;
      tU8  m_au8Cache[BLOCKSIZE];
      tU32 m_u32NumBytesCached;

   public:
      AESWriter();
      virtual ~AESWriter();

      /**
       *  Opens given filename for writing.
       */
      tBool bOpen ( tCString szName, tBool bOverwriteExisting );

      tBool bClose();

      tBool bWrite(tU8 *pu8Data, tU32 u32NumBytes);

   private:
      tBool bFlush();
      tBool bWriteHeader();
      AESWriter(const AESWriter&);                 // Prevent copy-construction
      AESWriter& operator=(const AESWriter&);      // Prevent assignment      
};



#endif    //   AES_WRITER_H

