/*****************************************************************************
| FILE:         bosch_exception_catcher.cpp
| PROJECT:      GM MY13 NGA
| SW-COMPONENT: GM54 - DEBUG TOOL
|-----------------------------------------------------------------------------
| DESCRIPTION:  exception throw catcher/callstack/rethrow
| 
| Thanks for exception to http://zbigg.blogspot.com/search/label/exceptions
|
| Link as
|   -u __cxa_throw -lcpp_exception_a -lstdc++
|   -u __cxa_throw -u __cxa_pure_virtual -u __cxa_deleted_virtual -lcpp_exception_a -lstdc++
|
| See http://hi0vm019.de.bosch.com/wiki/index.php?title=GM_Gen2_Cpp_Exception
| and http://hi0vm019.de.bosch.com/wiki/index.php?title=GM_Gen2_Cpp_Virtual_Method
|
|-----------------------------------------------------------------------------
| COPYRIGHT  (C) 2011 Robert Bosch Car Multimedia GmbH, Hildesheim
| 
| HISTORY:
| Id  | Date        | Modification                     | Author
| 7   | 09.08.2011  | fix include, string prefix       | CM-AI/PJ-GM54 VNC
|                     change name display logic
|.....................add pure & deleted virtual
| 6   | 22.07.2011  | use project definition           | CM-AI/PJ-GM54 VNC
| 5   | 18.07.2011  | integration in build system      | CM-AI/PJ-GM54 VNC
| 4   | 15.07.2011  | demangling exception's name      | CM-AI/PJ-GM54 VNC, Greulich Christian (Fa. ESE, CM-AI/PJ-GM36)
| 3   | 14.07.2011  | Write exception's name in EM     | CM-AI/PJ-GM54 VNC
| 2   | 13.07.2011  | dlclose only if ptr != 0         | CM-AI/PJ-GM54 VNC, Greulich Christian (Fa. ESE, CM-AI/PJ-GM36)
| 1   | 12.07.2011  | Initial revision                 | CM-AI/PJ-GM54 VNC
|*****************************************************************************/
#include <typeinfo>
#include <stdexcept>
#include <iostream>
#include <dlfcn.h>
#include <cstdlib>
#include <cstring>

#define __PLACEMENT_NEW_INLINE

/* NORMAL_M_ASSERT_ALWAYS */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <fcntl.h>

/* Demangling exception's name */
#include <cxxabi.h>
#include <unistd.h>
int     status;
char   *realname;

static OSAL_tIODescriptor fd_errmem = OSAL_ERROR;


#if !defined(CPP_EXCEPTION_CATCH_DISABLE_XVIRTUAL)
    #define RBCM_AI "RBCM-AI; C++ Exception / xVirtual Method Call Catch r7: "
#else
    #define RBCM_AI "RBCM-AI; C++ Exception Catch r7: "
#endif
#define EXCEPTION_NAME_LGENTH_MINIMUM    5

typedef void (*bosch_cxa_throw_type)(void* , void *, void (*) (void *));
static bosch_cxa_throw_type bosch_original_cxa_throw = 0;


static void vTraceErrmem(tCString pcFormat, ...)
{
   tChar pcBuffer[ERRMEM_MAX_ENTRY_LENGTH] = {0};
   OSAL_tVarArgList argList;
   tS32 s32Size;
   tS32 trClass = TR_COMP_OSALCORE;
   OSAL_tIODescriptor fd_errmem;
   trErrmemEntry  rErrmemEntry = {0};

   fd_errmem = OSAL_IOOpen(OSAL_C_STRING_DEVICE_ERRMEM, OSAL_EN_WRITEONLY);
   if(fd_errmem != OSAL_ERROR)
   {
      OSAL_VarArgStart(argList, pcFormat);  //lint !e1055 !e64 !e516 !e530 !e534 !e416 !e662 !e1773  
      s32Size = OSALUTIL_s32SaveVarNPrintFormat(pcBuffer, ERRMEM_MAX_ENTRY_LENGTH, pcFormat, argList); //lint !e530
      OSAL_VarArgEnd(argList);

      rErrmemEntry.u16Entry = TR_COMP_OSALCORE;
      rErrmemEntry.eEntryType = eErrmemEntryNormal;
      rErrmemEntry.u16EntryLength = (tU16)(s32Size+3);
      if (rErrmemEntry.u16EntryLength > (ERRMEM_MAX_ENTRY_LENGTH - 2))
      {
         rErrmemEntry.u16EntryLength = ERRMEM_MAX_ENTRY_LENGTH - 2;
      }
      rErrmemEntry.au8EntryData[0] = (tU8) (((tU16)trClass) & 0xFF);/*lint !e778*/
      rErrmemEntry.au8EntryData[1] = (tU8) (((tU16)trClass) >> 8) & 0xFF;
      rErrmemEntry.au8EntryData[2] = 0xf1;

      (tVoid) OSAL_pvMemoryCopy(&rErrmemEntry.au8EntryData[3], pcBuffer, rErrmemEntry.u16EntryLength);
      if (OSAL_ERROR == OSAL_s32IOWrite( fd_errmem, (tPCS8)&rErrmemEntry, sizeof(rErrmemEntry)))
      {
		  NORMAL_M_ASSERT_ALWAYS();
      }
      (tVoid) OSAL_s32IOClose(fd_errmem);
   }
}




extern "C" 
void __cxa_throw(void *thrown_exception, void *pvtinfo, void (*dest) (void *) )
{
    std::type_info const* tinfo = reinterpret_cast<std::type_info const*>(pvtinfo); 
    if (tinfo != 0)
    {
        const char *exception_name = tinfo->name();
        if ( (exception_name != 0) && 
             (strlen(exception_name) > 0) )
        {
            realname = abi::__cxa_demangle(exception_name, 0, 0, &status);
            if ( (realname == 0) ||
                 (strlen(realname) < EXCEPTION_NAME_LGENTH_MINIMUM) )
            {
                vTraceErrmem("Detected throw of %s", exception_name);
            }
            if (realname != 0)
            {
                vTraceErrmem("Detected throw of %s", realname);
                free(realname);
            }
        }
        else
        {
            vTraceErrmem("Detected throw");
        }
    }
    else
    {
        vTraceErrmem("Detected throw of exception");
    }

    if (bosch_original_cxa_throw == 0)
    {
        void* original_libcxx = dlopen("libstdc++.so.6", RTLD_LAZY);
        std::cerr << RBCM_AI << "loaded original libc++ @" << original_libcxx << ".\n";

        if (original_libcxx != 0)
        {
            bosch_original_cxa_throw = (bosch_cxa_throw_type)( dlsym(original_libcxx, "__cxa_throw") );
            std::cerr << RBCM_AI << "loaded orig_cxa_throw @" << (void*)bosch_original_cxa_throw << ".\n";
            dlclose(original_libcxx);
        }

    }

    // ASSERT -> shall add a backtrace in Error Memory 
 //   NORMAL_M_ASSERT_ALWAYS();
    if (bosch_original_cxa_throw != 0)
    {
        bosch_original_cxa_throw(thrown_exception, pvtinfo, dest);
    }
    else
    {
        vTraceErrmem("Original throw NOT FOUND: abort()");
        abort();
    }
}

#if !defined(CPP_EXCEPTION_CATCH_DISABLE_XVIRTUAL)
extern "C" void __cxa_pure_virtual()
{
    vTraceErrmem("Pure Virtual Call detected");
	NORMAL_M_ASSERT_ALWAYS();
    abort();
}

extern "C" void __cxa_deleted_virtual()
{
    vTraceErrmem("Deleted Virtual Call detected");
    NORMAL_M_ASSERT_ALWAYS();
    abort();
}
#endif
