#ifndef CCAPOWER_HEADER
#define CCAPOWER_HEADER

/* --ccapower.h
	
	This file contains the various application states and the values
	of the power messages of famous car computer architecture. 		

	Author: Michael Uelschen, CM-DI/ESN2

	$Log:   //hi230124/projects/Vasco/swnavi/archives/components/cca/ccapower.h-arc  $		
 * 
 *    Rev 1.2   31 Oct 2002 13:11:14   UNM2HI
 * Update

*/

/* --Definition of application states. */
#define CCA_C_U32_STATE_INVALID			(tU32)0x00
#define CCA_C_U32_STATE_UNINITALIZED            (tU32)0x01
#define CCA_C_U32_STATE_INITIALIZED             (tU32)0x02
#define CCA_C_U32_STATE_NORMAL                  (tU32)0x03
#define CCA_C_U32_STATE_DIAGNOSIS               (tU32)0x04
#define CCA_C_U32_STATE_PAUSE                   (tU32)0x05
#define CCA_C_U32_STATE_PREPARE_DOWNLOAD        (tU32)0x06
#define CCA_C_U32_STATE_RECEIVE_READY           (tU32)0x07
#define CCA_C_U32_STATE_OFF                     (tU32)0x08



/* --ACHTUNG !!! NAMENSGEBUNG NDERT SICH NOCH !!! */
#define CCA_C_U16_PWR_APP_START_REQ                     (tU16)0x00
#define CCA_C_U16_PWR_APP_INITIALIZED                   (tU16)0x01
#define CCA_C_U16_PWR_APP_RESTART                       (tU16)0x02
#define CCA_C_U16_PWR_PROXY_START_CONF                  (tU16)0x03
#define CCA_C_U16_PWR_PROXY_START_REJ                   (tU16)0x04
#define CCA_C_U16_PWR_PROXY_STATE_CHANGE_REQ            (tU16)0x10
#define CCA_C_U16_PWR_APP_STATE_ACK                     (tU16)0x11
#define CCA_C_U16_PWR_APP_STATE_REJ                     (tU16)0x12
#define CCA_C_U16_PWR_PROXY_STATE_CHANGE_IMMEDIATELY    (tU16)0x13

#define CCA_C_U16_PWR_PROXY_END_APP                     (tU16)0x20
#define CCA_C_U16_PWR_APP_END_SUCCESSFUL                (tU16)0x21
#define CCA_C_U16_PWR_APP_END_FAILURE                   (tU16)0x22


#define CCA_C_U16_PWR_APP_ERROR_DETECT                  (tU16)0x30

#define CCA_C_U16_PWR_WDOGTIMER                         (tU16)0x40
#define CCA_C_U16_PWR_SVM_APP_REGISTER                  (tU16)0x41

      // subcodes for power-data1 field of app-register message. The following
      // values must be identical to the definitions in the WinCE Headerfile 
      // "cpm.h" (which is part of the WinCE SDK)
      // Following coding is used: REGISTRY_FLAGS: Bits 24-31
      //                           RECOVERY_FLAGS: Bits 16-23
      //                           Bits 8-15 unused, Bits 0-7 unused, 
      // REMARK: Any modification has effect on some methods in "SystemEntry.cpp"!!

      // make a log entry only

#define CCA_C_U32_PWR_SVM_APPRECOVER_LOG              (tU32)0x01000000
#define CCA_C_U32_PWR_SVM_APPRECOVER_RELAUNCH         (tU32)0x02000000

      // process will notify on specific time quantum
#define CCA_C_U32_PWR_SVM_APPREG_ENTRYNOTIFY          (tU32)0x00030000

      // process will be watched to see if it goes away (actually no support!)
#define CCA_C_U32_PWR_SVM_APPREG_ENTRYWATCH           (tU32)0x00040000

#define CCA_C_U16_PWR_SVM_APP_UNREGISTER                (tU16)0x42
#define CCA_C_U16_PWR_SVM_APP_NOTIFY                    (tU16)0x43
#define CCA_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM            (tU16)0x44
#define CCA_C_U16_PWR_SVM_APP_NOTIFY_PROBLEM_RESPONSE   (tU16)0x45

      // notification codes (used by notify problem response)
      // subcodes for application states (whenever needed). The following 
      // values must be identical to the definitions in the WinCE Headerfile
      //  "syi_LpmTypes.h" (which is part of the WinCE SDK)
      // Following coding is used: REGISTRY_FLAGS: Bits 24-31

#define CCA_C_U32_PWR_APP_STATE_UNDEFINED             (tU32)0x00000000
#define CCA_C_U32_PWR_LPM_APP_STATE_RESTART           (tU32)0x00000001
#define CCA_C_U32_PWR_APP_STATE_OK                    (tU32)0x00000002

#define CCA_C_U16_PWR_PROXY_CVM_SIGNAL_CHANGED          (tU16)0x50
#define CCA_C_U16_PWR_APP_REQ_SYSTEM_STATE              (tU16)0x60
#define CCA_C_U16_PWR_APP_RAM_INIT_READY                (tU16)0x70


#endif
