//*****************************************************************************
//** FILE:         amt_Trace.h
//** PROJECT:      VASCO
//** SW-COMPONENT: AMT
//** --------------------------------------------------------------------------
//** DESCRIPTION:  (A)pplication (M)essage (T)emplate
//**               Settings for AMT module
//** --------------------------------------------------------------------------
//** COPYRIGHT:    (c) 2000 Robert Bosch GmbH, Hildesheim
//** HISTORY:      
//** Date      |   Modification                         | Author
//** 20.04.01  |   Initial revision                     | Bruns,EFG32
//**
//**
//** REMARK: This trace module completely uses OSAL's trace functionality.
//**
//**---------------------------------------------------------------------------
//** REMARK: switches MUST be set in "amt_settings.h"
//*****************************************************************************


#ifndef AMT_TRACE_H
   #define AMT_TRACE_H

// TR_CLASS_AIL                 TR_COMP_CCA + 0 = 0x8A00
// TR_CLASS_SCD                 TR_COMP_CCA + 1 = 0x8A01
// TR_CLASS_AMT                 TR_COMP_CCA + 2 = 0x8A02
// TR_CLASS_AHL_CCA_EXTENSION   TR_COMP_CCA + 3 = 0x8A03
#define TR_CLASS_AMT                      ((TR_tenTraceClass)(TR_COMP_CCA + 2))

/******************************************************************************
 *FUNCTION:    amt_bInitTrace
 *DESCRIPTION: Trace initialisation for AMT
 *
 *PARAMETER:   -
 *
 *RETURNVALUE: TRUE on success, else FALSE
 *
 *HISTORY:     20.04.2001  -  BNS2HI
 *             Initial revision
 *****************************************************************************/
tBool amt_bInitTrace(tVoid);



/******************************************************************************
 *FUNCTION:    amt_bDeInitTrace
 *DESCRIPTION: Trace de-initialisation for AMT; frees used ressources.
 *
 *PARAMETER:   -
 *
 *RETURNVALUE: TRUE on success, else FALSE
 *
 *HISTORY:     -
 *****************************************************************************/
tBool amt_bDeInitTrace(tVoid);



/******************************************************************************
 *FUNCTION:    amt_vTraceOutString
 *DESCRIPTION: Trace out a string.
 *
 *PARAMETER:   tU32   u32Level (->I)
 *             The trace level for output
 *
 *             const tChar *coszFormatString (->I)
 *             The format string (see printf-documentation)
 *
 *RETURNVALUE: -
 *
 *HISTORY:     20.04.2001  -  BNS2HI
 *             Initial revision
 *****************************************************************************/
tVoid amt_vTraceOutString(TR_tenTraceLevel enTraceLevel, const tChar *coszFormatString, ...);



/******************************************************************************
 *FUNCTION:    amt_vTraceOutBufferN
 *DESCRIPTION: Trace out a buffer contents.
 *
 *PARAMETER:   tU32   u32Level (->I)
 *             The trace level for output
 *
 *             const tChar *coszBuffer (->I)
 *             Pointer to the buffer
 *
 *             tU32   u32BufferLength
 *             Length of the output
 *
 *RETURNVALUE: -
 *
 *HISTORY:     20.04.2001  -  BNS2HI
 *             Initial revision
 *****************************************************************************/
tVoid amt_vTraceOutBufferN(TR_tenTraceLevel enTraceLevel, const tChar *coszBuffer, tU32 u32BufferLength);

#endif /* AMT_TRACE_H */
